/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

public class SCMSecurityProtocolClientSideTranslatorPB
implements SCMSecurityProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final SCMSecurityProtocolPB rpcProxy;

    public SCMSecurityProtocolClientSideTranslatorPB(SCMSecurityProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dataNodeDetails, String certSignReq) throws IOException {
        return this.getDataNodeCertificateChain(dataNodeDetails, certSignReq).getX509Certificate();
    }

    @Override
    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        return this.getOMCertChain(omDetails, certSignReq).getX509Certificate();
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getOMCertChain(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetOMCertRequestProto.Builder builder = SCMSecurityProtocolProtos.SCMGetOMCertRequestProto.newBuilder().setCSR(certSignReq).setOmDetails(omDetails);
        try {
            return this.rpcProxy.getOMCertificate(NULL_RPC_CONTROLLER, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public String getCertificate(String certSerialId) throws IOException {
        SCMSecurityProtocolProtos.SCMGetCertificateRequestProto.Builder builder = SCMSecurityProtocolProtos.SCMGetCertificateRequestProto.newBuilder().setCertSerialId(certSerialId);
        try {
            return this.rpcProxy.getCertificate(NULL_RPC_CONTROLLER, builder.build()).getX509Certificate();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public SCMSecurityProtocolProtos.SCMGetCertResponseProto getDataNodeCertificateChain(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto.Builder builder = SCMSecurityProtocolProtos.SCMGetDataNodeCertRequestProto.newBuilder().setCSR(certSignReq).setDatanodeDetails(dnDetails);
        try {
            return this.rpcProxy.getDataNodeCertificate(NULL_RPC_CONTROLLER, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public String getCACertificate() throws IOException {
        SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto protoIns = SCMSecurityProtocolProtos.SCMGetCACertificateRequestProto.getDefaultInstance();
        try {
            return this.rpcProxy.getCACertificate(NULL_RPC_CONTROLLER, protoIns).getX509Certificate();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

