/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.ConfigurationException;

@InterfaceAudience.Private
public class OzoneConfiguration
extends Configuration {
    public OzoneConfiguration() {
        OzoneConfiguration.activate();
        this.loadDefaults();
    }

    public OzoneConfiguration(Configuration conf) {
        super(conf);
        this.setClassLoader(conf.getClassLoader());
        if (!(conf instanceof OzoneConfiguration)) {
            this.loadDefaults();
        }
    }

    private void loadDefaults() {
        try {
            Enumeration<URL> generatedDefaults = OzoneConfiguration.class.getClassLoader().getResources("ozone-default-generated.xml");
            while (generatedDefaults.hasMoreElements()) {
                this.addResource(generatedDefaults.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addResource("ozone-site.xml");
    }

    public List<Property> readPropertyFromXml(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLConfiguration.class});
        Unmarshaller um = context.createUnmarshaller();
        XMLConfiguration config = (XMLConfiguration)um.unmarshal(url);
        return config.getProperties();
    }

    public <T> T getObject(Class<T> configurationClass) {
        T configuration;
        try {
            configuration = configurationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Configuration class can't be created: " + configurationClass, (Throwable)e);
        }
        ConfigGroup configGroup = configurationClass.getAnnotation(ConfigGroup.class);
        String prefix = configGroup.prefix();
        for (Method setterMethod : configurationClass.getMethods()) {
            if (!setterMethod.isAnnotationPresent(Config.class)) continue;
            String methodLocation = configurationClass + "." + setterMethod.getName();
            Config configAnnotation = setterMethod.getAnnotation(Config.class);
            String key = prefix + "." + configAnnotation.key();
            Class<?>[] parameterTypes = setterMethod.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new ConfigurationException("@Config annotation should be used on simple setter: " + methodLocation);
            }
            ConfigType type = configAnnotation.type();
            if (type == ConfigType.AUTO) {
                type = this.detectConfigType(parameterTypes[0], methodLocation);
            }
            try {
                switch (type) {
                    case STRING: {
                        setterMethod.invoke(configuration, this.get(key));
                        break;
                    }
                    case INT: {
                        setterMethod.invoke(configuration, this.getInt(key, 0));
                        break;
                    }
                    case BOOLEAN: {
                        setterMethod.invoke(configuration, this.getBoolean(key, false));
                        break;
                    }
                    case LONG: {
                        setterMethod.invoke(configuration, this.getLong(key, 0L));
                        break;
                    }
                    case TIME: {
                        setterMethod.invoke(configuration, this.getTimeDuration(key, 0L, configAnnotation.timeUnit()));
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Unsupported ConfigType " + type + " on " + methodLocation);
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigurationException("Can't inject configuration to " + methodLocation, (Throwable)e);
            }
        }
        return configuration;
    }

    private ConfigType detectConfigType(Class<?> parameterType, String methodLocation) {
        ConfigType type;
        if (parameterType == String.class) {
            type = ConfigType.STRING;
        } else if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            type = ConfigType.INT;
        } else if (parameterType == Long.class || parameterType == Long.TYPE) {
            type = ConfigType.LONG;
        } else if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
            type = ConfigType.BOOLEAN;
        } else {
            throw new ConfigurationException("Unsupported configuration type " + parameterType + " in " + methodLocation);
        }
        return type;
    }

    public static void activate() {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"ozone-default.xml");
    }

    public Properties getAllPropertiesByTag(String tag) {
        Properties updatedProps = this.getProps();
        Properties propertiesByTag = super.getAllPropertiesByTag(tag);
        Properties props = new Properties();
        Enumeration<?> properties = propertiesByTag.propertyNames();
        while (properties.hasMoreElements()) {
            Object propertyName = properties.nextElement();
            String value = updatedProps.getProperty(propertyName.toString());
            if (value == null) continue;
            props.put(propertyName, value);
        }
        return props;
    }

    static {
        OzoneConfiguration.activate();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="property")
    public static class Property
    implements Comparable<Property> {
        private String name;
        private String value;
        private String tag;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(Property o) {
            if (this == o) {
                return 0;
            }
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.getName() + " " + this.getValue() + " " + this.getTag();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Property && ((Property)obj).getName().equals(this.getName());
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="configuration")
    public static class XMLConfiguration {
        @XmlElement(name="property", type=Property.class)
        private List<Property> properties = new ArrayList<Property>();

        public XMLConfiguration() {
        }

        public XMLConfiguration(List<Property> properties) {
            this.properties = properties;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }
    }
}

