/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.snappy.LoadSnappy;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class SnappyCodec
implements Configurable,
CompressionCodec {
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeCodeLoaded() {
        return LoadSnappy.isLoaded() && NativeCodeLoader.isNativeCodeLoaded();
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.snappy.buffersize", 262144);
        int compressionOverhead = bufferSize / 6 + 32;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        return SnappyCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.snappy.buffersize", 262144);
        return new SnappyCompressor(bufferSize);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt("io.compression.codec.snappy.buffersize", 262144));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        return SnappyDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!SnappyCodec.isNativeCodeLoaded()) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt("io.compression.codec.snappy.buffersize", 262144);
        return new SnappyDecompressor(bufferSize);
    }

    @Override
    public String getDefaultExtension() {
        return ".snappy";
    }

    static {
        LoadSnappy.isLoaded();
    }
}

