/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.util.StringUtils;

class OperationData {
    private static final String SEP = ",";
    private Constants.Distribution distribution;
    private Double percent;

    OperationData(Constants.Distribution d, Double p) {
        this.distribution = d;
        this.percent = p;
    }

    OperationData(String data) {
        String[] pieces = Helper.getTrimmedStrings(data);
        this.distribution = Constants.Distribution.UNIFORM;
        this.percent = null;
        if (pieces.length == 1) {
            this.percent = Double.parseDouble(pieces[0]) / 100.0;
        } else if (pieces.length >= 2) {
            this.percent = Double.parseDouble(pieces[0]) / 100.0;
            this.distribution = Constants.Distribution.valueOf(StringUtils.toUpperCase((String)pieces[1]));
        }
    }

    Constants.Distribution getDistribution() {
        return this.distribution;
    }

    Double getPercent() {
        return this.percent;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.getPercent() != null) {
            str.append(this.getPercent() * 100.0);
        } else {
            str.append(Double.NaN);
        }
        str.append(SEP);
        str.append(this.getDistribution().lowerName());
        return str.toString();
    }
}

