/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActivityNodeInfo {
    private String name;
    private Integer appPriority;
    private Integer requestPriority;
    private Long allocationRequestId;
    private String allocationState;
    private String diagnostic;
    private String nodeId;
    private Integer count;
    private List<String> nodeIds;
    protected List<ActivityNodeInfo> children;

    ActivityNodeInfo() {
    }

    public ActivityNodeInfo(String name, ActivityState activityState, String diagnostic, NodeId nId) {
        this.name = name;
        this.allocationState = activityState.name();
        this.diagnostic = diagnostic;
        this.setNodeId(nId);
    }

    public ActivityNodeInfo(ActivityState groupActivityState, String groupDiagnostic, List<String> groupNodeIds) {
        this.allocationState = groupActivityState.name();
        this.diagnostic = groupDiagnostic;
        this.count = groupNodeIds.size();
        this.nodeIds = groupNodeIds;
    }

    ActivityNodeInfo(ActivityNode node, RMWSConsts.ActivitiesGroupBy groupBy) {
        this.name = node.getName();
        this.setPriority(node);
        this.setNodeId(node.getNodeId());
        this.allocationState = node.getState().name();
        this.diagnostic = node.getDiagnostic();
        this.requestPriority = node.getRequestPriority();
        this.allocationRequestId = node.getAllocationRequestId();
        this.children = node.isRequestType() ? ActivitiesUtils.getRequestActivityNodeInfos(node.getChildren(), groupBy) : node.getChildren().stream().map(e -> new ActivityNodeInfo((ActivityNode)e, groupBy)).collect(Collectors.toList());
    }

    public void setNodeId(NodeId nId) {
        if (nId != null && !Strings.isNullOrEmpty((String)nId.getHost())) {
            this.nodeId = nId.toString();
        }
    }

    private void setPriority(ActivityNode node) {
        if (node.isAppType()) {
            this.appPriority = node.getAppPriority();
        } else {
            this.requestPriority = node.getRequestPriority();
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public Long getAllocationRequestId() {
        return this.allocationRequestId;
    }

    public Integer getCount() {
        return this.count;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public List<ActivityNodeInfo> getChildren() {
        return this.children;
    }

    public String getAllocationState() {
        return this.allocationState;
    }

    public String getName() {
        return this.name;
    }

    public Integer getAppPriority() {
        return this.appPriority;
    }

    public Integer getRequestPriority() {
        return this.requestPriority;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }
}

