/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public class CapacitySchedulerQueueContext {
    private final CapacitySchedulerContext csContext;
    private final CapacitySchedulerQueueManager queueManager;
    private final RMNodeLabelsManager labelManager;
    private final PreemptionManager preemptionManager;
    private final ActivitiesManager activitiesManager;
    private final ResourceCalculator resourceCalculator;
    private CapacitySchedulerConfiguration configuration;
    private Resource minimumAllocation;

    public CapacitySchedulerQueueContext(CapacitySchedulerContext csContext) {
        this.csContext = csContext;
        this.queueManager = csContext.getCapacitySchedulerQueueManager();
        this.labelManager = csContext.getRMContext().getNodeLabelManager();
        this.preemptionManager = csContext.getPreemptionManager();
        this.activitiesManager = csContext.getActivitiesManager();
        this.resourceCalculator = csContext.getResourceCalculator();
        this.configuration = new CapacitySchedulerConfiguration(csContext.getConfiguration());
        this.minimumAllocation = csContext.getMinimumResourceCapability();
    }

    public void reinitialize() {
        this.configuration = new CapacitySchedulerConfiguration(this.csContext.getConfiguration(), false);
        this.minimumAllocation = this.csContext.getMinimumResourceCapability();
    }

    public CapacitySchedulerQueueManager getQueueManager() {
        return this.queueManager;
    }

    public RMNodeLabelsManager getLabelManager() {
        return this.labelManager;
    }

    public PreemptionManager getPreemptionManager() {
        return this.preemptionManager;
    }

    public ActivitiesManager getActivitiesManager() {
        return this.activitiesManager;
    }

    public ResourceCalculator getResourceCalculator() {
        return this.resourceCalculator;
    }

    public CapacitySchedulerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfigurationEntry(String name, String value) {
        this.configuration.set(name, value);
    }

    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    public Resource getClusterResource() {
        return this.csContext.getClusterResource();
    }

    public ResourceUsage getClusterResourceUsage() {
        return this.queueManager.getRootQueue().getQueueResourceUsage();
    }

    public SchedulerHealth getSchedulerHealth() {
        return this.csContext.getSchedulerHealth();
    }

    public long getLastNodeUpdateTime() {
        return this.csContext.getLastNodeUpdateTime();
    }

    public FiCaSchedulerNode getNode(NodeId nodeId) {
        return this.csContext.getNode(nodeId);
    }

    public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        return this.csContext.getApplicationAttempt(applicationAttemptId);
    }

    public CapacityScheduler.PendingApplicationComparator getApplicationComparator() {
        return this.csContext.getPendingApplicationComparator();
    }
}

