/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class PriorityRouterPolicy
extends AbstractRouterPolicy {
    @Override
    protected SubClusterId chooseSubCluster(String queue, Map<SubClusterId, SubClusterInfo> preSelectSubclusters) throws YarnException {
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        SubClusterId chosen = null;
        Float currentBest = Float.valueOf(Float.MIN_VALUE);
        for (SubClusterId id : preSelectSubclusters.keySet()) {
            SubClusterIdInfo idInfo = new SubClusterIdInfo(id);
            if (!weights.containsKey(idInfo) || !(weights.get(idInfo).floatValue() > currentBest.floatValue())) continue;
            currentBest = weights.get(idInfo);
            chosen = id;
        }
        if (chosen == null) {
            throw new FederationPolicyException("No Active Subcluster with weight vector greater than zero.");
        }
        return chosen;
    }
}

