/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.sun.codemodel.JClassContainer;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Jsonschema2Pojo;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Schema;
import org.apache.hadoop.shaded.org.jsonschema2pojo.exception.GenerationException;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;

public class SchemaRule
implements Rule<JClassContainer, JType> {
    private final RuleFactory ruleFactory;

    protected SchemaRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode schemaNode, JsonNode parent, JClassContainer generatableType, Schema schema) {
        if (schemaNode.has("$ref")) {
            String nameFromRef = this.nameFromRef(schemaNode.get("$ref").asText());
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            schemaNode = schema.getContent();
            if (schema.isGenerated()) {
                return schema.getJavaType();
            }
            return this.apply(nameFromRef != null ? nameFromRef : nodeName, schemaNode, parent, generatableType, schema);
        }
        schema = schema.deriveChildSchema(schemaNode);
        JType javaType = schemaNode.has("enum") ? this.ruleFactory.getEnumRule().apply(nodeName, schemaNode, parent, generatableType, schema) : this.ruleFactory.getTypeRule().apply(nodeName, schemaNode, parent, generatableType.getPackage(), schema);
        schema.setJavaTypeIfEmpty(javaType);
        return javaType;
    }

    private String nameFromRef(String ref) {
        String nameFromRef;
        if ("#".equals(ref)) {
            return null;
        }
        if (!StringUtils.contains((CharSequence)ref, (CharSequence)"#")) {
            nameFromRef = Jsonschema2Pojo.getNodeName(ref, this.ruleFactory.getGenerationConfig());
        } else {
            String[] nameParts = StringUtils.split((String)ref, (String)"/\\#");
            nameFromRef = nameParts[nameParts.length - 1];
        }
        try {
            return URLDecoder.decode(nameFromRef, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GenerationException("Failed to decode ref: " + ref, e);
        }
    }
}

