/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.apache.jute.Record;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.Time;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapShot;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapshotInfo;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.TxnDigest;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnSnapLog {
    final File dataDir;
    final File snapDir;
    TxnLog txnLog;
    SnapShot snapLog;
    private final boolean autoCreateDB;
    private final boolean trustEmptySnapshot;
    public static final int VERSION = 2;
    public static final String version = "version-";
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLog.class);
    public static final String ZOOKEEPER_DATADIR_AUTOCREATE = "zookeeper.datadir.autocreate";
    public static final String ZOOKEEPER_DATADIR_AUTOCREATE_DEFAULT = "true";
    static final String ZOOKEEPER_DB_AUTOCREATE = "zookeeper.db.autocreate";
    private static final String ZOOKEEPER_DB_AUTOCREATE_DEFAULT = "true";
    public static final String ZOOKEEPER_SNAPSHOT_TRUST_EMPTY = "zookeeper.snapshot.trust.empty";
    private static final String EMPTY_SNAPSHOT_WARNING = "No snapshot found, but there are log entries. ";

    public FileTxnSnapLog(File dataDir, File snapDir) throws IOException {
        LOG.debug("Opening datadir:{} snapDir:{}", (Object)dataDir, (Object)snapDir);
        this.dataDir = new File(dataDir, "version-2");
        this.snapDir = new File(snapDir, "version-2");
        boolean enableAutocreate = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DATADIR_AUTOCREATE, "true"));
        this.trustEmptySnapshot = Boolean.getBoolean(ZOOKEEPER_SNAPSHOT_TRUST_EMPTY);
        LOG.info("{} : {}", (Object)ZOOKEEPER_SNAPSHOT_TRUST_EMPTY, (Object)this.trustEmptySnapshot);
        if (!this.dataDir.exists()) {
            if (!enableAutocreate) {
                throw new DatadirException(String.format("Missing data directory %s, automatic data directory creation is disabled (%s is false). Please create this directory manually.", this.dataDir, ZOOKEEPER_DATADIR_AUTOCREATE));
            }
            if (!this.dataDir.mkdirs() && !this.dataDir.exists()) {
                throw new DatadirException("Unable to create data directory " + this.dataDir);
            }
        }
        if (!this.dataDir.canWrite()) {
            throw new DatadirException("Cannot write to data directory " + this.dataDir);
        }
        if (!this.snapDir.exists()) {
            if (!enableAutocreate) {
                throw new DatadirException(String.format("Missing snap directory %s, automatic data directory creation is disabled (%s is false).Please create this directory manually.", this.snapDir, ZOOKEEPER_DATADIR_AUTOCREATE));
            }
            if (!this.snapDir.mkdirs() && !this.snapDir.exists()) {
                throw new DatadirException("Unable to create snap directory " + this.snapDir);
            }
        }
        if (!this.snapDir.canWrite()) {
            throw new DatadirException("Cannot write to snap directory " + this.snapDir);
        }
        if (!this.dataDir.getPath().equals(this.snapDir.getPath())) {
            this.checkLogDir();
            this.checkSnapDir();
        }
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
        this.autoCreateDB = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DB_AUTOCREATE, "true"));
    }

    public void setServerStats(ServerStats serverStats) {
        this.txnLog.setServerStats(serverStats);
    }

    private void checkLogDir() throws LogDirContentCheckException {
        File[] files = this.dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Util.isSnapshotFileName(name);
            }
        });
        if (files != null && files.length > 0) {
            throw new LogDirContentCheckException("Log directory has snapshot files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    private void checkSnapDir() throws SnapDirContentCheckException {
        File[] files = this.snapDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Util.isLogFileName(name);
            }
        });
        if (files != null && files.length > 0) {
            throw new SnapDirContentCheckException("Snapshot directory has log files. Check if dataLogDir and dataDir configuration is correct.");
        }
    }

    public File getDataLogDir() {
        return this.dataDir;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    public SnapshotInfo getLastSnapshotInfo() {
        return this.snapLog.getLastSnapshotInfo();
    }

    public boolean shouldForceWriteInitialSnapshotAfterLeaderElection() {
        return this.trustEmptySnapshot && this.getLastSnapshotInfo() == null;
    }

    public long restore(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        boolean trustEmptyDB;
        long snapLoadingStartTime = Time.currentElapsedTime();
        long deserializeResult = this.snapLog.deserialize(dt, sessions);
        ServerMetrics.getMetrics().STARTUP_SNAP_LOAD_TIME.add(Time.currentElapsedTime() - snapLoadingStartTime);
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        File initFile = new File(this.dataDir.getParent(), "initialize");
        if (Files.deleteIfExists(initFile.toPath())) {
            LOG.info("Initialize file found, an empty database will not block voting participation");
            trustEmptyDB = true;
        } else {
            trustEmptyDB = this.autoCreateDB;
        }
        RestoreFinalizer finalizer = () -> {
            long highestZxid = this.fastForwardFromEdits(dt, sessions, listener);
            DataTree.ZxidDigest snapshotZxidDigest = dt.getDigestFromLoadedSnapshot();
            if (snapshotZxidDigest != null) {
                LOG.warn("Highest txn zxid 0x{} is not covering the snapshot digest zxid 0x{}, which might lead to inconsistent state", (Object)Long.toHexString(highestZxid), (Object)Long.toHexString(snapshotZxidDigest.getZxid()));
            }
            return highestZxid;
        };
        if (-1L == deserializeResult) {
            if (txnLog.getLastLoggedZxid() != -1L) {
                if (!this.trustEmptySnapshot) {
                    throw new IOException("No snapshot found, but there are log entries. Something is broken!");
                }
                LOG.warn("{}This should only be allowed during upgrading.", (Object)EMPTY_SNAPSHOT_WARNING);
                return finalizer.run();
            }
            if (trustEmptyDB) {
                this.save(dt, (ConcurrentHashMap)sessions, false);
                return 0L;
            }
            LOG.warn("Unexpected empty data tree, setting zxid to -1");
            dt.lastProcessedZxid = -1L;
            return -1L;
        }
        return finalizer.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fastForwardFromEdits(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        TxnLog.TxnIterator itr = this.txnLog.read(dt.lastProcessedZxid + 1L);
        long highestZxid = dt.lastProcessedZxid;
        int txnLoaded = 0;
        long startTime = Time.currentElapsedTime();
        try {
            do {
                TxnHeader hdr;
                if ((hdr = itr.getHeader()) == null) {
                    long l = dt.lastProcessedZxid;
                    return l;
                }
                if (hdr.getZxid() < highestZxid && highestZxid != 0L) {
                    LOG.error("{}(highestZxid) > {}(next log) for type {}", new Object[]{highestZxid, hdr.getZxid(), hdr.getType()});
                } else {
                    highestZxid = hdr.getZxid();
                }
                try {
                    this.processTransaction(hdr, dt, sessions, itr.getTxn());
                    dt.compareDigest(hdr, itr.getTxn(), itr.getDigest());
                    ++txnLoaded;
                }
                catch (KeeperException.NoNodeException e) {
                    throw new IOException("Failed to process transaction type: " + hdr.getType() + " error: " + e.getMessage(), e);
                }
                listener.onTxnLoaded(hdr, itr.getTxn(), itr.getDigest());
            } while (itr.next());
        }
        finally {
            if (itr != null) {
                itr.close();
            }
        }
        long loadTime = Time.currentElapsedTime() - startTime;
        LOG.info("{} txns loaded in {} ms", (Object)txnLoaded, (Object)loadTime);
        ServerMetrics.getMetrics().STARTUP_TXNS_LOADED.add(txnLoaded);
        ServerMetrics.getMetrics().STARTUP_TXNS_LOAD_TIME.add(loadTime);
        return highestZxid;
    }

    public TxnLog.TxnIterator readTxnLog(long zxid) throws IOException {
        return this.readTxnLog(zxid, true);
    }

    public TxnLog.TxnIterator readTxnLog(long zxid, boolean fastForward) throws IOException {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.read(zxid, fastForward);
    }

    public void processTransaction(TxnHeader hdr, DataTree dt, Map<Long, Integer> sessions, Record txn) throws KeeperException.NoNodeException {
        DataTree.ProcessTxnResult rc;
        switch (hdr.getType()) {
            case -10: {
                sessions.put(hdr.getClientId(), ((CreateSessionTxn)txn).getTimeOut());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: 0x" + Long.toHexString(hdr.getClientId()) + " with timeout: " + ((CreateSessionTxn)txn).getTimeOut());
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            case -11: {
                sessions.remove(hdr.getClientId());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: 0x" + Long.toHexString(hdr.getClientId()));
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            default: {
                rc = dt.processTxn(hdr, txn);
            }
        }
        if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr: {}, error: {}, path: {}", new Object[]{hdr.getType(), rc.err, rc.path});
        }
    }

    public long getLastLoggedZxid() {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.getLastLoggedZxid();
    }

    public void save(DataTree dataTree, ConcurrentHashMap<Long, Integer> sessionsWithTimeouts, boolean syncSnap) throws IOException {
        long lastZxid = dataTree.lastProcessedZxid;
        File snapshotFile = new File(this.snapDir, Util.makeSnapshotName(lastZxid));
        LOG.info("Snapshotting: 0x{} to {}", (Object)Long.toHexString(lastZxid), (Object)snapshotFile);
        try {
            this.snapLog.serialize(dataTree, sessionsWithTimeouts, snapshotFile, syncSnap);
        }
        catch (IOException e) {
            if (snapshotFile.length() == 0L) {
                if (snapshotFile.delete()) {
                    LOG.info("Deleted empty snapshot file: {}", (Object)snapshotFile.getAbsolutePath());
                } else {
                    LOG.warn("Could not delete empty snapshot file: {}", (Object)snapshotFile.getAbsolutePath());
                }
            }
            throw e;
        }
    }

    public boolean truncateLog(long zxid) {
        boolean bl;
        this.close();
        FileTxnLog truncLog = new FileTxnLog(this.dataDir);
        try {
            boolean truncated = truncLog.truncate(zxid);
            this.txnLog = new FileTxnLog(this.dataDir);
            this.snapLog = new FileSnap(this.snapDir);
            bl = truncated;
        }
        catch (Throwable throwable) {
            try {
                try {
                    truncLog.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Unable to truncate Txn log", (Throwable)e);
                return false;
            }
        }
        truncLog.close();
        return bl;
    }

    public File findMostRecentSnapshot() throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findMostRecentSnapshot();
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findNRecentSnapshots(n);
    }

    public List<File> findNValidSnapshots(int n) {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findNValidSnapshots(n);
    }

    public File[] getSnapshotLogs(long zxid) {
        return FileTxnLog.getLogFiles(this.dataDir.listFiles(), zxid);
    }

    public boolean append(Request si) throws IOException {
        return this.txnLog.append(si.getHdr(), si.getTxn(), si.getTxnDigest());
    }

    public void commit() throws IOException {
        this.txnLog.commit();
    }

    public long getTxnLogElapsedSyncTime() {
        return this.txnLog.getTxnLogSyncElapsedTime();
    }

    public void rollLog() throws IOException {
        this.txnLog.rollLog();
    }

    public void close() throws IOException {
        TxnLog txnLogToClose = this.txnLog;
        if (txnLogToClose != null) {
            txnLogToClose.close();
        }
        this.txnLog = null;
        SnapShot snapSlogToClose = this.snapLog;
        if (snapSlogToClose != null) {
            snapSlogToClose.close();
        }
        this.snapLog = null;
    }

    public void setTotalLogSize(long size) {
        this.txnLog.setTotalLogSize(size);
    }

    public long getTotalLogSize() {
        return this.txnLog.getTotalLogSize();
    }

    public static class SnapDirContentCheckException
    extends DatadirException {
        public SnapDirContentCheckException(String msg) {
            super(msg);
        }
    }

    public static class LogDirContentCheckException
    extends DatadirException {
        public LogDirContentCheckException(String msg) {
            super(msg);
        }
    }

    public static class DatadirException
    extends IOException {
        public DatadirException(String msg) {
            super(msg);
        }

        public DatadirException(String msg, Exception e) {
            super(msg, e);
        }
    }

    private static interface RestoreFinalizer {
        public long run() throws IOException;
    }

    public static interface PlayBackListener {
        public void onTxnLoaded(TxnHeader var1, Record var2, TxnDigest var3);
    }
}

