/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.CekTable;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.CekTableEntry;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.Column;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.CryptoMetadata;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLIdentifier;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SSType;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamColInfo;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamPacket;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamTabName;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.TDSReader;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.TypeInfo;

final class StreamColumns
extends StreamPacket {
    private Column[] columns;
    private CekTable cekTable = null;
    private boolean shouldHonorAEForRead = false;

    CekTable getCekTable() {
        return this.cekTable;
    }

    StreamColumns() {
        super(129);
    }

    StreamColumns(boolean honorAE) {
        super(129);
        this.shouldHonorAEForRead = honorAE;
    }

    CekTableEntry readCEKTableEntry(TDSReader tdsReader) throws SQLServerException {
        int databaseId = tdsReader.readInt();
        int cekId = tdsReader.readInt();
        int cekVersion = tdsReader.readInt();
        byte[] cekMdVersion = new byte[8];
        tdsReader.readBytes(cekMdVersion, 0, 8);
        int cekValueCount = tdsReader.readUnsignedByte();
        CekTableEntry cekTableEntry = new CekTableEntry(cekValueCount);
        for (int i = 0; i < cekValueCount; ++i) {
            short encryptedCEKlength = tdsReader.readShort();
            byte[] encryptedCek = new byte[encryptedCEKlength];
            tdsReader.readBytes(encryptedCek, 0, encryptedCEKlength);
            int keyStoreLength = tdsReader.readUnsignedByte();
            String keyStoreName = tdsReader.readUnicodeString(keyStoreLength);
            short keyPathLength = tdsReader.readShort();
            String keyPath = tdsReader.readUnicodeString(keyPathLength);
            int algorithmLength = tdsReader.readUnsignedByte();
            String algorithmName = tdsReader.readUnicodeString(algorithmLength);
            cekTableEntry.add(encryptedCek, databaseId, cekId, cekVersion, cekMdVersion, keyPath, keyStoreName, algorithmName);
        }
        return cekTableEntry;
    }

    void readCEKTable(TDSReader tdsReader) throws SQLServerException {
        int tableSize = tdsReader.readShort();
        if (0 != tableSize) {
            this.cekTable = new CekTable(tableSize);
            for (int i = 0; i < tableSize; ++i) {
                this.cekTable.setCekTableEntry(i, this.readCEKTableEntry(tdsReader));
            }
        }
    }

    CryptoMetadata readCryptoMetadata(TDSReader tdsReader) throws SQLServerException {
        short ordinal = 0;
        if (null != this.cekTable) {
            ordinal = tdsReader.readShort();
        }
        TypeInfo typeInfo = TypeInfo.getInstance(tdsReader, false);
        byte algorithmId = (byte)tdsReader.readUnsignedByte();
        String algorithmName = null;
        if (0 == algorithmId) {
            int nameSize = tdsReader.readUnsignedByte();
            algorithmName = tdsReader.readUnicodeString(nameSize);
        }
        byte encryptionType = (byte)tdsReader.readUnsignedByte();
        byte normalizationRuleVersion = (byte)tdsReader.readUnsignedByte();
        CryptoMetadata cryptoMeta = new CryptoMetadata(this.cekTable == null ? null : this.cekTable.getCekTableEntry(ordinal), ordinal, algorithmId, algorithmName, encryptionType, normalizationRuleVersion);
        cryptoMeta.setBaseTypeInfo(typeInfo);
        return cryptoMeta;
    }

    @Override
    void setFromTDS(TDSReader tdsReader) throws SQLServerException {
        if (129 != tdsReader.readUnsignedByte()) assert (false);
        int nTotColumns = tdsReader.readUnsignedShort();
        if (65535 == nTotColumns) {
            return;
        }
        if (tdsReader.getServerSupportsColumnEncryption()) {
            this.readCEKTable(tdsReader);
        }
        this.columns = new Column[nTotColumns];
        for (int numColumns = 0; numColumns < nTotColumns; ++numColumns) {
            TypeInfo typeInfo = TypeInfo.getInstance(tdsReader, true);
            SQLIdentifier tableName = new SQLIdentifier();
            if (SSType.TEXT == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType()) {
                tableName = tdsReader.readSQLIdentifier();
            }
            CryptoMetadata cryptoMeta = null;
            if (tdsReader.getServerSupportsColumnEncryption() && typeInfo.isEncrypted()) {
                cryptoMeta = this.readCryptoMetadata(tdsReader);
                cryptoMeta.baseTypeInfo.setFlags(typeInfo.getFlagsAsShort());
                typeInfo.setSQLCollation(cryptoMeta.baseTypeInfo.getSQLCollation());
            }
            String columnName = tdsReader.readUnicodeString(tdsReader.readUnsignedByte());
            this.columns[numColumns] = this.shouldHonorAEForRead ? new Column(typeInfo, columnName, tableName, cryptoMeta) : new Column(typeInfo, columnName, tableName, null);
        }
    }

    Column[] buildColumns(StreamColInfo colInfoToken, StreamTabName tabNameToken) throws SQLServerException {
        if (null != colInfoToken && null != tabNameToken) {
            tabNameToken.applyTo(this.columns, colInfoToken.applyTo(this.columns));
        }
        return this.columns;
    }
}

