/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.volume.csi;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.com.google.gson.JsonObject;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.volume.csi.VolumeCapabilityRange;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;

public class VolumeMetaData {
    private VolumeId volumeId;
    private String volumeName;
    private VolumeCapabilityRange volumeCapabilityRange;
    private String driverName;
    private String mountPoint;

    private void setVolumeId(VolumeId volumeId) {
        this.volumeId = volumeId;
    }

    private void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    private void setVolumeCapabilityRange(VolumeCapabilityRange capability) {
        this.volumeCapabilityRange = capability;
    }

    private void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    private void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public boolean isProvisionedVolume() {
        return this.volumeId != null;
    }

    public VolumeId getVolumeId() {
        return this.volumeId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public VolumeCapabilityRange getVolumeCapabilityRange() {
        return this.volumeCapabilityRange;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public static VolumeSpecBuilder newBuilder() {
        return new VolumeSpecBuilder();
    }

    public static List<VolumeMetaData> fromResource(ResourceInformation resourceInfo) throws InvalidVolumeException {
        ArrayList<VolumeMetaData> volumeMetaData = new ArrayList<VolumeMetaData>();
        if (resourceInfo != null && resourceInfo.getTags() != null && resourceInfo.getTags().contains("system:csi-volume")) {
            VolumeSpecBuilder builder = VolumeMetaData.newBuilder();
            if (resourceInfo.getAttributes().containsKey("volume.id")) {
                String id = (String)resourceInfo.getAttributes().get("volume.id");
                builder.volumeId(new VolumeId(id));
            }
            if (resourceInfo.getAttributes().containsKey("volume.name")) {
                builder.volumeName((String)resourceInfo.getAttributes().get("volume.name"));
            }
            if (resourceInfo.getAttributes().containsKey("driver.name")) {
                builder.driverName((String)resourceInfo.getAttributes().get("driver.name"));
            }
            if (resourceInfo.getAttributes().containsKey("volume.mount")) {
                builder.mountPoint((String)resourceInfo.getAttributes().get("volume.mount"));
            }
            VolumeCapabilityRange volumeCapabilityRange = VolumeCapabilityRange.newBuilder().minCapacity(resourceInfo.getValue()).unit(resourceInfo.getUnits()).build();
            builder.capability(volumeCapabilityRange);
            volumeMetaData.add(builder.build());
        }
        return volumeMetaData;
    }

    public String toString() {
        JsonObject json = new JsonObject();
        if (!Strings.isNullOrEmpty((String)this.volumeName)) {
            json.addProperty("volume.name", this.volumeName);
        }
        if (this.volumeId != null) {
            json.addProperty("volume.id", this.volumeId.toString());
        }
        if (this.volumeCapabilityRange != null) {
            json.addProperty("volume.capability", this.volumeCapabilityRange.toString());
        }
        if (!Strings.isNullOrEmpty((String)this.driverName)) {
            json.addProperty("driver.name", this.driverName);
        }
        if (!Strings.isNullOrEmpty((String)this.mountPoint)) {
            json.addProperty("volume.mount", this.mountPoint);
        }
        return json.toString();
    }

    public static class VolumeSpecBuilder {
        private VolumeId volumeId;
        private String volumeName;
        private VolumeCapabilityRange volumeCapabilityRange;
        private String driverName;
        private String mountPoint;

        public VolumeSpecBuilder volumeId(VolumeId volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public VolumeSpecBuilder volumeName(String name) {
            this.volumeName = name;
            return this;
        }

        public VolumeSpecBuilder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public VolumeSpecBuilder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public VolumeSpecBuilder capability(VolumeCapabilityRange capability) {
            this.volumeCapabilityRange = capability;
            return this;
        }

        public VolumeMetaData build() throws InvalidVolumeException {
            VolumeMetaData spec = new VolumeMetaData();
            spec.setVolumeId(this.volumeId);
            spec.setVolumeName(this.volumeName);
            spec.setVolumeCapabilityRange(this.volumeCapabilityRange);
            spec.setDriverName(this.driverName);
            spec.setMountPoint(this.mountPoint);
            this.validate(spec);
            return spec;
        }

        private void validate(VolumeMetaData spec) throws InvalidVolumeException {
            if (Strings.isNullOrEmpty((String)spec.getVolumeName()) && spec.getVolumeId() == null) {
                throw new InvalidVolumeException("Invalid volume, both volume name and ID are missing from the spec. Volume spec: " + spec.toString());
            }
            if (spec.getVolumeCapabilityRange() == null) {
                throw new InvalidVolumeException("Invalid volume, volume capability is missing. Volume spec: " + spec.toString());
            }
            if (Strings.isNullOrEmpty((String)spec.getDriverName())) {
                throw new InvalidVolumeException("Invalid volume, the csi-driver name is missing. Volume spec: " + spec.toString());
            }
            if (Strings.isNullOrEmpty((String)spec.getMountPoint())) {
                throw new InvalidVolumeException("Invalid volume, the mount point is missing. Volume spec: " + spec.toString());
            }
        }
    }
}

