/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler;

import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerScheduler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ResourceUtilizationTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationBasedResourceUtilizationTracker
implements ResourceUtilizationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AllocationBasedResourceUtilizationTracker.class);
    private ResourceUtilization containersAllocation = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    private ContainerScheduler scheduler;

    AllocationBasedResourceUtilizationTracker(ContainerScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public ResourceUtilization getCurrentUtilization() {
        return this.containersAllocation;
    }

    @Override
    public void addContainerResources(Container container) {
        ContainersMonitor.increaseResourceUtilization(this.getContainersMonitor(), this.containersAllocation, container.getResource());
    }

    @Override
    public void subtractContainerResource(Container container) {
        ContainersMonitor.decreaseResourceUtilization(this.getContainersMonitor(), this.containersAllocation, container.getResource());
    }

    @Override
    public boolean hasResourcesAvailable(Container container) {
        long pMemBytes = container.getResource().getMemorySize() * 1024L * 1024L;
        return this.hasResourcesAvailable(pMemBytes, (long)(this.getContainersMonitor().getVmemRatio() * (float)pMemBytes), container.getResource().getVirtualCores());
    }

    private boolean hasResourcesAvailable(long pMemBytes, long vMemBytes, int cpuVcores) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pMemCheck [current={} + asked={} > allowed={}]", new Object[]{this.containersAllocation.getPhysicalMemory(), pMemBytes >> 20, this.getContainersMonitor().getPmemAllocatedForContainers() >> 20});
        }
        if (this.containersAllocation.getPhysicalMemory() + (int)(pMemBytes >> 20) > (int)(this.getContainersMonitor().getPmemAllocatedForContainers() >> 20)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("before vMemCheck[isEnabled={}, current={} + asked={} > allowed={}]", new Object[]{this.getContainersMonitor().isVmemCheckEnabled(), this.containersAllocation.getVirtualMemory(), vMemBytes >> 20, this.getContainersMonitor().getVmemAllocatedForContainers() >> 20});
        }
        if (this.getContainersMonitor().isVmemCheckEnabled() && this.containersAllocation.getVirtualMemory() + (int)(vMemBytes >> 20) > (int)(this.getContainersMonitor().getVmemAllocatedForContainers() >> 20)) {
            return false;
        }
        LOG.debug("before cpuCheck [asked={} > allowed={}]", (Object)Float.valueOf(this.containersAllocation.getCPU()), (Object)this.getContainersMonitor().getVCoresAllocatedForContainers());
        return !(this.containersAllocation.getCPU() + (float)cpuVcores > (float)this.getContainersMonitor().getVCoresAllocatedForContainers());
    }

    public ContainersMonitor getContainersMonitor() {
        return this.scheduler.getContainersMonitor();
    }
}

