/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin;

import java.io.Serializable;
import java.util.Objects;

public final class Device
implements Serializable,
Comparable {
    private static final long serialVersionUID = -7270474563684671656L;
    private final int id;
    private final String devPath;
    private final int majorNumber;
    private final int minorNumber;
    private final String busID;
    private boolean isHealthy;
    private String status;

    private Device(Builder builder) {
        if (builder.id == -1) {
            throw new IllegalArgumentException("Please set the id for Device");
        }
        this.id = builder.id;
        this.devPath = builder.devPath;
        this.majorNumber = builder.majorNumber;
        this.minorNumber = builder.minorNumber;
        this.busID = builder.busID;
        this.isHealthy = builder.isHealthy;
        this.status = builder.status;
    }

    public int getId() {
        return this.id;
    }

    public String getDevPath() {
        return this.devPath;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public String getBusID() {
        return this.busID;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return this.id == device.getId() && Objects.equals(this.devPath, device.getDevPath()) && this.majorNumber == device.getMajorNumber() && this.minorNumber == device.getMinorNumber() && Objects.equals(this.busID, device.getBusID());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.devPath, this.majorNumber, this.minorNumber, this.busID);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Device)) {
            return -1;
        }
        Device other = (Device)o;
        int result = Integer.compare(this.id, other.getId());
        if (0 != result) {
            return result;
        }
        result = Integer.compare(this.majorNumber, other.getMajorNumber());
        if (0 != result) {
            return result;
        }
        result = Integer.compare(this.minorNumber, other.getMinorNumber());
        if (0 != result) {
            return result;
        }
        result = this.devPath.compareTo(other.getDevPath());
        if (0 != result) {
            return result;
        }
        return this.busID.compareTo(other.getBusID());
    }

    public String toString() {
        return "(" + this.getId() + ", " + this.getDevPath() + ", " + this.getMajorNumber() + ":" + this.getMinorNumber() + ")";
    }

    public static final class Builder {
        private int id = -1;
        private String devPath = "";
        private int majorNumber = -1;
        private int minorNumber = -1;
        private String busID = "";
        private boolean isHealthy;
        private String status = "";

        public static Builder newInstance() {
            return new Builder();
        }

        public Device build() {
            return new Device(this);
        }

        public Builder setId(int i) {
            this.id = i;
            return this;
        }

        public Builder setDevPath(String dp) {
            this.devPath = dp;
            return this;
        }

        public Builder setMajorNumber(int maN) {
            this.majorNumber = maN;
            return this;
        }

        public Builder setMinorNumber(int miN) {
            this.minorNumber = miN;
            return this;
        }

        public Builder setBusID(String bI) {
            this.busID = bI;
            return this;
        }

        public Builder setHealthy(boolean healthy) {
            this.isHealthy = healthy;
            return this;
        }

        public Builder setStatus(String s) {
            this.status = s;
            return this;
        }
    }
}

