/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.junit;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.finder.AllInvocationsFinder;
import org.apache.hadoop.shaded.org.mockito.internal.junit.UnusedStubbings;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.UnusedStubbingReporting;
import org.apache.hadoop.shaded.org.mockito.internal.util.collections.ListUtil;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.stubbing.Stubbing;

public class UnusedStubbingsFinder {
    public UnusedStubbings getUnusedStubbings(Iterable<Object> mocks) {
        Set<Stubbing> stubbings = AllInvocationsFinder.findStubbings(mocks);
        LinkedList<Stubbing> unused = ListUtil.filter(stubbings, new ListUtil.Filter<Stubbing>(){

            @Override
            public boolean isOut(Stubbing s) {
                return !UnusedStubbingReporting.shouldBeReported(s);
            }
        });
        return new UnusedStubbings(unused);
    }

    public Collection<Invocation> getUnusedStubbingsByLocation(Iterable<Object> mocks) {
        Set<Stubbing> stubbings = AllInvocationsFinder.findStubbings(mocks);
        HashSet<String> locationsOfUsedStubbings = new HashSet<String>();
        for (Stubbing s : stubbings) {
            if (UnusedStubbingReporting.shouldBeReported(s)) continue;
            String location = s.getInvocation().getLocation().toString();
            locationsOfUsedStubbings.add(location);
        }
        LinkedHashMap<String, Invocation> out = new LinkedHashMap<String, Invocation>();
        for (Stubbing s : stubbings) {
            String location = s.getInvocation().getLocation().toString();
            if (locationsOfUsedStubbings.contains(location)) continue;
            out.put(location, s.getInvocation());
        }
        return out.values();
    }
}

