/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ProbeNotifier;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.DataStructures;

public class FixedThreadPool
extends AbstractThreadPool {
    protected final BlockingQueue<Runnable> workQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedThreadPool(ThreadPoolConfig config) {
        super(config);
        this.workQueue = config.getQueue() != null ? (BlockingQueue)config.getQueue() : (BlockingQueue)config.setQueue(DataStructures.getLTQInstance(Runnable.class)).getQueue();
        int poolSize = config.getMaxPoolSize();
        ProbeNotifier.notifyThreadPoolStarted(this);
        Object object = this.stateLock;
        synchronized (object) {
            while (poolSize-- > 0) {
                this.doStartWorker();
            }
        }
        super.onMaxNumberOfThreadsReached();
    }

    private void doStartWorker() {
        this.startWorker(new BasicWorker());
    }

    @Override
    public void execute(Runnable command) {
        if (this.running) {
            if (this.workQueue.offer(command)) {
                if (!this.running && this.workQueue.remove(command)) {
                    throw new RejectedExecutionException("ThreadPool is not running");
                }
                this.onTaskQueued(command);
                return;
            }
            this.onTaskQueueOverflow();
            return;
        }
        throw new RejectedExecutionException("ThreadPool is not running");
    }

    private final class BasicWorker
    extends AbstractThreadPool.Worker {
        private BasicWorker() {
        }

        @Override
        protected final Runnable getTask() throws InterruptedException {
            return FixedThreadPool.this.workQueue.take();
        }
    }
}

