/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.apache.hadoop.shaded.org.eclipse.jetty.jndi.BindingEnumeration;
import org.apache.hadoop.shaded.org.eclipse.jetty.jndi.NameEnumeration;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.component.Dumpable;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;

public class NamingContext
implements Context,
Dumpable {
    private static final Logger LOG = Log.getLogger(NamingContext.class);
    private static final List<Binding> __empty = Collections.emptyList();
    public static final String DEEP_BINDING = "org.apache.hadoop.shaded.org.eclipse.jetty.jndi.deepBinding";
    public static final String LOCK_PROPERTY = "org.apache.hadoop.shaded.org.eclipse.jetty.jndi.lock";
    public static final String UNLOCK_PROPERTY = "org.apache.hadoop.shaded.org.eclipse.jetty.jndi.unlock";
    protected final Hashtable<String, Object> _env = new Hashtable();
    protected final ConcurrentMap<String, Binding> _bindings;
    protected NamingContext _parent = null;
    protected String _name = null;
    protected NameParser _parser = null;
    private Collection<Listener> _listeners;
    private Object _lock;

    public NamingContext(Hashtable<String, Object> env, String name, NamingContext parent, NameParser parser) {
        this(env, name, parent, parser, null);
    }

    protected NamingContext(Hashtable<String, Object> env, String name, NamingContext parent, NameParser parser, ConcurrentMap<String, Binding> bindings) {
        if (env != null) {
            this._env.putAll(env);
        }
        this._name = name;
        this._parent = parent;
        this._parser = parser;
        ConcurrentHashMap concurrentHashMap = this._bindings = bindings == null ? new ConcurrentHashMap() : bindings;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {}", new Object[]{this});
        }
    }

    public Context shallowCopy(Hashtable<String, Object> env) {
        return new NamingContext(env, this._name, this._parent, this._parser, this._bindings);
    }

    public boolean isDeepBindingSupported() {
        Object support = this._env.get(DEEP_BINDING);
        if (support != null) {
            return Boolean.parseBoolean(String.valueOf(support));
        }
        if (this._parent != null) {
            return this._parent.isDeepBindingSupported();
        }
        return Boolean.parseBoolean(System.getProperty(DEEP_BINDING, "false"));
    }

    public String getName() {
        return this._name;
    }

    public Context getParent() {
        return this._parent;
    }

    public void setNameParser(NameParser parser) {
        this._parser = parser;
    }

    public final void setEnv(Hashtable<String, Object> env) {
        Object lock = this._env.get(LOCK_PROPERTY);
        try {
            this._env.clear();
            if (env == null) {
                return;
            }
            this._env.putAll(env);
        }
        finally {
            if (lock != null) {
                this._env.put(LOCK_PROPERTY, lock);
            }
        }
    }

    private Object dereference(Object ctx, String firstComponent) throws NamingException {
        if (ctx instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(ctx, this._parser.parse(firstComponent), this, this._env);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("", (Throwable)e);
                throw new NamingException(e.getMessage());
            }
        }
        return ctx;
    }

    private Context getContext(Name cname) throws NamingException {
        String firstComponent = cname.get(0);
        if (firstComponent.equals("")) {
            return this;
        }
        Binding binding = this.getBinding(firstComponent);
        if (binding == null) {
            NameNotFoundException nnfe = new NameNotFoundException(firstComponent + " is not bound");
            nnfe.setRemainingName(cname);
            throw nnfe;
        }
        Object ctx = this.dereference(binding.getObject(), firstComponent);
        if (!(ctx instanceof Context)) {
            throw new NotContextException(firstComponent + " not a context in " + this.getNameInNamespace());
        }
        return (Context)ctx;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            this.addBinding(cname, objToBind);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(firstComponent);
                if (binding == null) {
                    if (this.isDeepBindingSupported()) {
                        Name subname = this._parser.parse(firstComponent);
                        NamingContext subctx = new NamingContext(this._env, firstComponent, this, this._parser, null);
                        this.addBinding(subname, subctx);
                        binding = this.getBinding(subname);
                    } else {
                        throw new NameNotFoundException(firstComponent + " is not bound");
                    }
                }
                ctx = this.dereference(binding.getObject(), firstComponent);
            }
            if (ctx instanceof Context) {
                ((Context)ctx).bind(cname.getSuffix(1), obj);
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this._parser.parse(name), obj);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (this.isLocked()) {
            NamingException ne = new NamingException("This context is immutable");
            ne.setRemainingName(name);
            throw ne;
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding != null) {
                throw new NameAlreadyBoundException(cname.toString());
            }
            NamingContext ctx = new NamingContext(this._env, cname.get(0), this, this._parser);
            this.addBinding(cname, ctx);
            return ctx;
        }
        return this.getContext(cname).createSubcontext(cname.getSuffix(1));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.removeBinding(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.removeBinding(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Name cname;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up name=\"" + name + "\"", new Object[0]);
        }
        if ((cname = this.toCanonicalName(name)) == null || cname.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Null or empty name, returning shallowCopy of this context", new Object[0]);
            }
            return this.shallowCopy(this._env);
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            Object o = binding.getObject();
            if (o instanceof LinkRef) {
                String linkName = ((LinkRef)o).getLinkName();
                if (linkName.startsWith("./")) {
                    return this.lookup(linkName.substring(2));
                }
                InitialContext ictx = new InitialContext();
                return ictx.lookup(linkName);
            }
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname, this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        return this.getContext(cname).lookup(cname.getSuffix(1));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null || name.isEmpty()) {
            return this.shallowCopy(this._env);
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            return this.dereference(binding.getObject(), cname.getPrefix(1).toString());
        }
        return this.getContext(cname).lookup(cname.getSuffix(1));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this._parser.parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Name cname;
        if (LOG.isDebugEnabled()) {
            LOG.debug("list() on Context=" + this.getName() + " for name=" + name, new Object[0]);
        }
        if ((cname = this.toCanonicalName(name)) == null) {
            return new NameEnumeration(__empty.iterator());
        }
        if (cname.size() == 0) {
            return new NameEnumeration(this._bindings.values().iterator());
        }
        return this.getContext(cname).list(cname.getSuffix(1));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            return new BindingEnumeration(__empty.iterator());
        }
        if (cname.size() == 0) {
            return new BindingEnumeration(this._bindings.values().iterator());
        }
        return this.getContext(cname).listBindings(cname.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            this.removeBinding(cname);
            this.addBinding(cname, objToBind);
        } else {
            this.getContext(cname).rebind(cname.getSuffix(1), obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this._parser.parse(name), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this._parser.parse(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            return;
        }
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            this.removeBinding(cname);
        } else {
            this.getContext(cname).unbind(cname.getSuffix(1));
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        CompoundName compoundName = (CompoundName)prefix.clone();
        compoundName.addAll(name);
        return compoundName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        Name compoundName = this._parser.parse(prefix);
        compoundName.add(name);
        return compoundName.toString();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public NameParser getNameParser(Name name) {
        return this._parser;
    }

    @Override
    public NameParser getNameParser(String name) {
        return this._parser;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        Name name = this._parser.parse("");
        for (NamingContext c = this; c != null; c = (NamingContext)c.getParent()) {
            String str = c.getName();
            if (str == null) continue;
            name.add(0, str);
        }
        return name.toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        switch (propName) {
            case "org.apache.hadoop.shaded.org.eclipse.jetty.jndi.lock": {
                if (this._lock == null) {
                    this._lock = propVal;
                }
                return null;
            }
            case "org.apache.hadoop.shaded.org.eclipse.jetty.jndi.unlock": {
                if (propVal != null && propVal.equals(this._lock)) {
                    this._lock = null;
                }
                return null;
            }
        }
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        return this._env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        return this._env.remove(propName);
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public void addBinding(Name name, Object obj) throws NameAlreadyBoundException {
        Listener listener;
        String key = name.toString();
        Binding binding = new Binding(key, obj);
        Collection<Listener> list = this.findListeners();
        Iterator<Listener> iterator = list.iterator();
        while (iterator.hasNext() && (binding = (listener = iterator.next()).bind(this, binding)) != null) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding binding with key=" + key + " obj=" + obj + " for context=" + this._name + " as " + binding, new Object[0]);
        }
        if (binding != null && this._bindings.putIfAbsent(key, binding) != null) {
            if (this.isDeepBindingSupported()) {
                return;
            }
            throw new NameAlreadyBoundException(name.toString());
        }
    }

    public Binding getBinding(Name name) {
        return (Binding)this._bindings.get(name.toString());
    }

    public Binding getBinding(String name) {
        return (Binding)this._bindings.get(name);
    }

    public void removeBinding(Name name) {
        Binding binding;
        String key = name.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing binding with key=" + key, new Object[0]);
        }
        if ((binding = (Binding)this._bindings.remove(key)) != null) {
            Collection<Listener> list = this.findListeners();
            for (Listener listener : list) {
                listener.unbind(this, binding);
            }
        }
    }

    public Name toCanonicalName(Name name) {
        Name canonicalName = name;
        if (name != null && canonicalName.size() > 1) {
            if (canonicalName.get(0).equals("")) {
                canonicalName = canonicalName.getSuffix(1);
            }
            if (canonicalName.get(canonicalName.size() - 1).equals("")) {
                canonicalName = canonicalName.getPrefix(canonicalName.size() - 1);
            }
        }
        return canonicalName;
    }

    public boolean isLocked() {
        return this._lock != null;
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (Map.Entry binding : this._bindings.entrySet()) {
            bindings.put((String)binding.getKey(), ((Binding)binding.getValue()).getObject());
        }
        Dumpable.dumpObject((Appendable)out, (Object)this);
        Dumpable.dumpMapEntries((Appendable)out, (String)indent, bindings, (boolean)this._env.isEmpty());
        if (!this._env.isEmpty()) {
            out.append(indent).append("+> environment\n");
            Dumpable.dumpMapEntries((Appendable)out, (String)(indent + "   "), this._env, (boolean)true);
        }
    }

    private Collection<Listener> findListeners() {
        ArrayList<Listener> list = new ArrayList<Listener>();
        for (NamingContext ctx = this; ctx != null; ctx = (NamingContext)ctx.getParent()) {
            if (ctx._listeners == null) continue;
            list.addAll(ctx._listeners);
        }
        return list;
    }

    public void addListener(Listener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<Listener>();
        }
        this._listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this._listeners.remove(listener);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName()).append('@').append(Integer.toHexString(this.hashCode()));
        buf.append("[name=").append(this._name);
        buf.append(",parent=");
        if (this._parent != null) {
            buf.append(this._parent.getClass().getName()).append('@').append(Integer.toHexString(this._parent.hashCode()));
        }
        buf.append(",bindings");
        if (this._bindings == null) {
            buf.append("=<null>");
        } else {
            buf.append(".size=").append(this._bindings.size());
        }
        buf.append(']');
        return buf.toString();
    }

    public static interface Listener {
        public Binding bind(NamingContext var1, Binding var2);

        public void unbind(NamingContext var1, Binding var2);
    }
}

