/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.shaded.com.google.inject.Binding;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.com.google.inject.Injector;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.servlet.FilterChainInvocation;
import org.apache.hadoop.shaded.com.google.inject.servlet.FilterDefinition;
import org.apache.hadoop.shaded.com.google.inject.servlet.FilterPipeline;
import org.apache.hadoop.shaded.com.google.inject.servlet.ManagedServletPipeline;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.RequestDispatcher;
import org.apache.hadoop.shaded.javax.servlet.ServletContext;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequestWrapper;

@Singleton
class ManagedFilterPipeline
implements FilterPipeline {
    private final FilterDefinition[] filterDefinitions;
    private final ManagedServletPipeline servletPipeline;
    private final Provider<ServletContext> servletContext;
    private final Injector injector;
    private volatile boolean initialized = false;
    private static final TypeLiteral<FilterDefinition> FILTER_DEFS = TypeLiteral.get(FilterDefinition.class);

    @Inject
    public ManagedFilterPipeline(Injector injector, ManagedServletPipeline servletPipeline, Provider<ServletContext> servletContext) {
        this.injector = injector;
        this.servletPipeline = servletPipeline;
        this.servletContext = servletContext;
        this.filterDefinitions = this.collectFilterDefinitions(injector);
    }

    private FilterDefinition[] collectFilterDefinitions(Injector injector) {
        ArrayList filterDefinitions = Lists.newArrayList();
        for (Binding<FilterDefinition> entry : injector.findBindingsByType(FILTER_DEFS)) {
            filterDefinitions.add(entry.getProvider().get());
        }
        return filterDefinitions.toArray(new FilterDefinition[filterDefinitions.size()]);
    }

    @Override
    public synchronized void initPipeline(ServletContext servletContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        Set initializedSoFar = Sets.newIdentityHashSet();
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.init(servletContext, this.injector, initializedSoFar);
        }
        this.servletPipeline.init(servletContext, this.injector);
        this.initialized = true;
    }

    @Override
    public void dispatch(ServletRequest request, ServletResponse response, FilterChain proceedingFilterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.initPipeline(this.servletContext.get());
        }
        new FilterChainInvocation(this.filterDefinitions, this.servletPipeline, proceedingFilterChain).doFilter(this.withDispatcher(request, this.servletPipeline), response);
    }

    private ServletRequest withDispatcher(ServletRequest servletRequest, final ManagedServletPipeline servletPipeline) {
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        return new HttpServletRequestWrapper(request){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }

    @Override
    public void destroyPipeline() {
        this.servletPipeline.destroy();
        Set destroyedSoFar = Sets.newIdentityHashSet();
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.destroy(destroyedSoFar);
        }
    }
}

