/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.cedarsoftware.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class IOUtilities {
    private static final int TRANSFER_BUFFER = 32768;

    private IOUtilities() {
    }

    public static InputStream getInputStream(URLConnection c) throws IOException {
        InputStream is = c.getInputStream();
        String enc = c.getContentEncoding();
        if ("gzip".equalsIgnoreCase(enc) || "x-gzip".equalsIgnoreCase(enc)) {
            is = new GZIPInputStream(is, 32768);
        } else if ("deflate".equalsIgnoreCase(enc)) {
            is = new InflaterInputStream(is, new Inflater(), 32768);
        }
        return new BufferedInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File f, URLConnection c, TransferCallback cb) throws Exception {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            out = new BufferedOutputStream(c.getOutputStream());
            IOUtilities.transfer((InputStream)in, out, cb);
        }
        catch (Throwable throwable) {
            IOUtilities.close(in);
            IOUtilities.close(out);
            throw throwable;
        }
        IOUtilities.close(in);
        IOUtilities.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(URLConnection c, File f, TransferCallback cb) throws Exception {
        InputStream in = null;
        try {
            in = IOUtilities.getInputStream(c);
            IOUtilities.transfer(in, f, cb);
        }
        finally {
            IOUtilities.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(InputStream s, File f, TransferCallback cb) throws Exception {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            IOUtilities.transfer(s, out, cb);
        }
        catch (Throwable throwable) {
            IOUtilities.close(out);
            throw throwable;
        }
        IOUtilities.close(out);
    }

    public static void transfer(InputStream in, OutputStream out, TransferCallback cb) throws IOException {
        int count;
        byte[] bytes = new byte[32768];
        while ((count = in.read(bytes)) != -1) {
            out.write(bytes, 0, count);
            if (cb == null) continue;
            cb.bytesTransferred(bytes, count);
            if (!cb.isCancelled()) continue;
            break;
        }
    }

    public static void transfer(InputStream in, byte[] bytes) throws IOException {
        int offset;
        int numRead;
        for (offset = 0; offset < bytes.length && (numRead = in.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Retry:  Not all bytes were transferred correctly.");
        }
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] bytes = new byte[32768];
        while ((count = in.read(bytes)) != -1) {
            out.write(bytes, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File file, OutputStream out) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file), 32768);
            IOUtilities.transfer((InputStream)in, out);
        }
        catch (Throwable throwable) {
            IOUtilities.flush(out);
            IOUtilities.close(in);
            throw throwable;
        }
        IOUtilities.flush(out);
        IOUtilities.close(in);
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void flush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] inputStreamToBytes(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtilities.transfer(in, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void compressBytes(ByteArrayOutputStream original, ByteArrayOutputStream compressed) throws IOException {
        GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)compressed, 32768);
        original.writeTo(gzipStream);
        gzipStream.flush();
        gzipStream.close();
    }

    public static interface TransferCallback {
        public void bytesTransferred(byte[] var1, int var2);

        public boolean isCancelled();
    }
}

