/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.hadoop.shaded.org.apache.commons.cli.Option;

class ConfigOption<T>
extends Option {
    private static final long serialVersionUID = 7218954906367671150L;
    private static final String SLIVE_PREFIX = "slive";
    static final ConfigOption<Integer> MAPS = new ConfigOption<Integer>("maps", true, "Number of maps", "slive.maps", 10);
    static final ConfigOption<Integer> REDUCES = new ConfigOption<Integer>("reduces", true, "Number of reduces", "slive.reduces", 1);
    static final ConfigOption<Integer> OPS = new ConfigOption<Integer>("ops", true, "Max number of operations per map", "slive.map.ops", 1000);
    static final ConfigOption<Integer> DURATION = new ConfigOption<Integer>("duration", true, "Duration of a map task in seconds (MAX_INT for no limit)", "slive.duration", Integer.MAX_VALUE);
    static final ConfigOption<Boolean> EXIT_ON_ERROR = new ConfigOption<Boolean>("exitOnError", false, "Exit on first error", "slive.exit.on.error", false);
    static final ConfigOption<Integer> FILES = new ConfigOption<Integer>("files", true, "Max total number of files", "slive.total.files", 10);
    static final ConfigOption<Integer> DIR_SIZE = new ConfigOption<Integer>("dirSize", true, "Max files per directory", "slive.dir.size", 32);
    static final ConfigOption<String> BASE_DIR = new ConfigOption<String>("baseDir", true, "Base directory path", "slive.base.dir", "/test/slive");
    static final ConfigOption<String> RESULT_FILE = new ConfigOption<String>("resFile", true, "Result file name", "slive.result.file", "part-0000");
    static final ConfigOption<Short> REPLICATION_AM = new ConfigOption<Short>("replication", true, "Min,max value for replication amount", "slive.file.replication", (short)3);
    static final ConfigOption<Long> BLOCK_SIZE = new ConfigOption<Long>("blockSize", true, "Min,max for dfs file block size", "slive.block.size", 0x4000000L);
    static final ConfigOption<Long> READ_SIZE = new ConfigOption<Object>("readSize", true, "Min,max for size to read (min=max=MAX_LONG=read entire file)", "slive.op.read.size", null);
    static final ConfigOption<Long> WRITE_SIZE = new ConfigOption<Object>("writeSize", true, "Min,max for size to write (min=max=MAX_LONG=blocksize)", "slive.op.write.size", null);
    static final ConfigOption<Long> SLEEP_TIME = new ConfigOption<Object>("sleep", true, "Min,max for millisecond of random sleep to perform (between operations)", "slive.op.sleep.range", null);
    static final ConfigOption<Long> APPEND_SIZE = new ConfigOption<Object>("appendSize", true, "Min,max for size to append (min=max=MAX_LONG=blocksize)", "slive.op.append.size", null);
    static final ConfigOption<Boolean> TRUNCATE_WAIT = new ConfigOption<Boolean>("truncateWait", true, "Should wait for truncate recovery", "slive.op.truncate.wait", true);
    static final ConfigOption<Long> TRUNCATE_SIZE = new ConfigOption<Object>("truncateSize", true, "Min,max for size to truncate (min=max=MAX_LONG=blocksize)", "slive.op.truncate.size", null);
    static final ConfigOption<Long> RANDOM_SEED = new ConfigOption<Object>("seed", true, "Random number seed", "slive.seed", null);
    static final Option HELP = new Option("help", false, "Usage information");
    static final Option CLEANUP = new Option("cleanup", true, "Cleanup & remove directory after reporting");
    static final ConfigOption<String> QUEUE_NAME = new ConfigOption<String>("queue", true, "Queue name", "mapred.job.queue.name", "default");
    static final ConfigOption<String> PACKET_SIZE = new ConfigOption<Object>("packetSize", true, "Dfs write packet size", "dfs.write.packet.size", null);
    private String cfgOption;
    private T defaultValue;

    ConfigOption(String cliOption, boolean hasArg, String description, String cfgOption, T def) {
        super(cliOption, hasArg, description);
        this.cfgOption = cfgOption;
        this.defaultValue = def;
    }

    String getCfgOption() {
        return this.cfgOption;
    }

    T getDefault() {
        return this.defaultValue;
    }
}

