/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TimelineACLsManager {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineACLsManager.class);
    private static final int DOMAIN_ACCESS_ENTRY_CACHE_SIZE = 100;
    private AdminACLsManager adminAclsManager;
    private Map<String, AccessControlListExt> aclExts;
    private TimelineStore store;

    public TimelineACLsManager(Configuration conf) {
        this.adminAclsManager = new AdminACLsManager(conf);
        this.aclExts = Collections.synchronizedMap(new LRUMap(100));
    }

    public void setTimelineStore(TimelineStore store) {
        this.store = store;
    }

    private AccessControlListExt loadDomainFromTimelineStore(String domainId) throws IOException {
        if (this.store == null) {
            return null;
        }
        TimelineDomain domain = this.store.getDomain(domainId);
        if (domain == null) {
            return null;
        }
        return this.putDomainIntoCache(domain);
    }

    public void replaceIfExist(TimelineDomain domain) {
        if (this.aclExts.containsKey(domain.getId())) {
            this.putDomainIntoCache(domain);
        }
    }

    private AccessControlListExt putDomainIntoCache(TimelineDomain domain) {
        HashMap<ApplicationAccessType, AccessControlList> acls = new HashMap<ApplicationAccessType, AccessControlList>(2);
        acls.put(ApplicationAccessType.VIEW_APP, new AccessControlList(StringHelper.cjoin((Object[])new Object[]{domain.getReaders()})));
        acls.put(ApplicationAccessType.MODIFY_APP, new AccessControlList(StringHelper.cjoin((Object[])new Object[]{domain.getWriters()})));
        AccessControlListExt aclExt = new AccessControlListExt(domain.getOwner(), acls);
        this.aclExts.put(domain.getId(), aclExt);
        return aclExt;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, ApplicationAccessType applicationAccessType, TimelineEntity entity) throws YarnException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verifying the access of " + (callerUGI == null ? null : callerUGI.getShortUserName()) + " on the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType()));
        }
        if (!this.adminAclsManager.areACLsEnabled()) {
            return true;
        }
        AccessControlListExt aclExt = this.aclExts.get(entity.getDomainId());
        if (aclExt == null) {
            aclExt = this.loadDomainFromTimelineStore(entity.getDomainId());
        }
        if (aclExt == null) {
            throw new YarnException("Domain information of the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType()) + " doesn't exist.");
        }
        String owner = aclExt.owner;
        AccessControlList domainACL = (AccessControlList)aclExt.acls.get(applicationAccessType);
        if (domainACL == null) {
            LOG.debug("ACL not found for access-type {} for domain {} owned by {}. Using default [{}]", new Object[]{applicationAccessType, entity.getDomainId(), owner, " "});
            domainACL = new AccessControlList(" ");
        }
        return callerUGI != null && (this.adminAclsManager.isAdmin(callerUGI) || callerUGI.getShortUserName().equals(owner) || domainACL.isUserAllowed(callerUGI));
    }

    public boolean checkAccess(UserGroupInformation callerUGI, TimelineDomain domain) throws YarnException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verifying the access of " + (callerUGI == null ? null : callerUGI.getShortUserName()) + " on the timeline domain " + domain);
        }
        if (!this.adminAclsManager.areACLsEnabled()) {
            return true;
        }
        String owner = domain.getOwner();
        if (owner == null || owner.length() == 0) {
            throw new YarnException("Owner information of the timeline domain " + domain.getId() + " is corrupted.");
        }
        return callerUGI != null && (this.adminAclsManager.isAdmin(callerUGI) || callerUGI.getShortUserName().equals(owner));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public AdminACLsManager setAdminACLsManager(AdminACLsManager adminAclsManager) {
        AdminACLsManager oldAdminACLsManager = this.adminAclsManager;
        this.adminAclsManager = adminAclsManager;
        return oldAdminACLsManager;
    }

    private static class AccessControlListExt {
        private String owner;
        private Map<ApplicationAccessType, AccessControlList> acls;

        public AccessControlListExt(String owner, Map<ApplicationAccessType, AccessControlList> acls) {
            this.owner = owner;
            this.acls = acls;
        }
    }
}

