/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivityNodeInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppRequestAllocationInfo {
    private Integer requestPriority;
    private Long allocationRequestId;
    private String allocationState;
    private String diagnostic;
    private List<ActivityNodeInfo> children;

    AppRequestAllocationInfo() {
    }

    AppRequestAllocationInfo(List<ActivityNode> activityNodes, RMWSConsts.ActivitiesGroupBy groupBy) {
        ActivityNode lastActivityNode = (ActivityNode)Iterables.getLast(activityNodes);
        this.requestPriority = lastActivityNode.getRequestPriority();
        this.allocationRequestId = lastActivityNode.getAllocationRequestId();
        this.allocationState = lastActivityNode.getState().name();
        if (lastActivityNode.isRequestType() && lastActivityNode.getDiagnostic() != null) {
            this.diagnostic = lastActivityNode.getDiagnostic();
        }
        this.children = ActivitiesUtils.getRequestActivityNodeInfos(activityNodes, groupBy);
    }

    public Integer getRequestPriority() {
        return this.requestPriority;
    }

    public Long getAllocationRequestId() {
        return this.allocationRequestId;
    }

    public String getAllocationState() {
        return this.allocationState;
    }

    public List<ActivityNodeInfo> getChildren() {
        return this.children;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }
}

