/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSConfigToCSConfigRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FSConfigToCSConfigRuleHandler.class);
    private ConversionOptions conversionOptions;
    public static final String MAX_CHILD_QUEUE_LIMIT = "maxChildQueue.limit";
    public static final String MAX_CAPACITY_PERCENTAGE = "maxCapacityPercentage.action";
    public static final String MAX_CHILD_CAPACITY = "maxChildCapacity.action";
    public static final String MAX_RESOURCES = "maxResources.action";
    public static final String MIN_RESOURCES = "minResources.action";
    public static final String USER_MAX_RUNNING_APPS = "userMaxRunningApps.action";
    public static final String USER_MAX_APPS_DEFAULT = "userMaxAppsDefault.action";
    public static final String DYNAMIC_MAX_ASSIGN = "dynamicMaxAssign.action";
    public static final String SPECIFIED_NOT_FIRST = "specifiedNotFirstRule.action";
    public static final String RESERVATION_SYSTEM = "reservationSystem.action";
    public static final String QUEUE_AUTO_CREATE = "queueAutoCreate.action";
    public static final String FAIR_AS_DRF = "fairAsDrf.action";
    public static final String MAPPED_DYNAMIC_QUEUE = "mappedDynamicQueue.action";
    private Map<String, RuleAction> actions;
    private Properties properties;

    void loadRulesFromFile(String ruleFile) throws IOException {
        if (ruleFile == null) {
            throw new IllegalArgumentException("Rule file cannot be null!");
        }
        this.properties = new Properties();
        try (FileInputStream is = new FileInputStream(new File(ruleFile));){
            this.properties.load(is);
        }
        this.actions = new HashMap<String, RuleAction>();
    }

    public FSConfigToCSConfigRuleHandler(ConversionOptions conversionOptions) {
        this.properties = new Properties();
        this.actions = new HashMap<String, RuleAction>();
        this.conversionOptions = conversionOptions;
    }

    @VisibleForTesting
    FSConfigToCSConfigRuleHandler(Properties props, ConversionOptions conversionOptions) {
        this.properties = props;
        this.actions = new HashMap<String, RuleAction>();
        this.conversionOptions = conversionOptions;
        this.initPropertyActions();
    }

    public void initPropertyActions() {
        this.setActionForProperty(MAX_CAPACITY_PERCENTAGE);
        this.setActionForProperty(MAX_CHILD_CAPACITY);
        this.setActionForProperty(MAX_RESOURCES);
        this.setActionForProperty(MIN_RESOURCES);
        this.setActionForProperty(USER_MAX_RUNNING_APPS);
        this.setActionForProperty(USER_MAX_APPS_DEFAULT);
        this.setActionForProperty(DYNAMIC_MAX_ASSIGN);
        this.setActionForProperty(SPECIFIED_NOT_FIRST);
        this.setActionForProperty(RESERVATION_SYSTEM);
        this.setActionForProperty(QUEUE_AUTO_CREATE);
        this.setActionForProperty(FAIR_AS_DRF);
        this.setActionForProperty(MAPPED_DYNAMIC_QUEUE);
    }

    public void handleMaxCapacityPercentage(String queueName) {
        this.handle(MAX_CAPACITY_PERCENTAGE, null, String.format("<maxResources> defined in percentages for queue %s", queueName));
    }

    public void handleMaxChildCapacity() {
        this.handle(MAX_CHILD_CAPACITY, "<maxChildResources>", null);
    }

    public void handleMaxResources() {
        this.handle(MAX_RESOURCES, "<maxResources>", null);
    }

    public void handleMinResources() {
        this.handle(MIN_RESOURCES, "<minResources>", null);
    }

    public void handleChildQueueCount(String queue, int count) {
        String value = this.properties.getProperty(MAX_CHILD_QUEUE_LIMIT);
        if (value != null) {
            if (StringUtils.isNumeric((CharSequence)value)) {
                int maxChildQueue = Integer.parseInt(value);
                if (count > maxChildQueue) {
                    throw new ConversionException(String.format("Queue %s has too many children: %d", queue, count));
                }
            } else {
                throw new ConversionException("Rule setting: maxChildQueue.limit is not an integer");
            }
        }
    }

    public void handleUserMaxApps() {
        this.handle(USER_MAX_RUNNING_APPS, "<maxRunningApps>", null);
    }

    public void handleUserMaxAppsDefault() {
        this.handle(USER_MAX_APPS_DEFAULT, "<userMaxAppsDefault>", null);
    }

    public void handleDynamicMaxAssign() {
        this.handle(DYNAMIC_MAX_ASSIGN, "yarn.scheduler.fair.dynamic.max.assign", null);
    }

    public void handleSpecifiedNotFirstRule() {
        this.handle(SPECIFIED_NOT_FIRST, null, "The <specified> tag is not the first placement rule, this cannot be converted properly");
    }

    public void handleReservationSystem() {
        this.handle(RESERVATION_SYSTEM, null, "Conversion of reservation system is not supported");
    }

    public void handleQueueAutoCreate(String placementRule) {
        this.handle(QUEUE_AUTO_CREATE, null, String.format("Placement rules: queue auto-create is not supported (type: %s), please configure auto-create-child-queue property manually", placementRule));
    }

    public void handleFairAsDrf(String queueName) {
        this.handle(FAIR_AS_DRF, null, String.format("Queue %s will use DRF policy instead of Fair", queueName));
    }

    public void handleDynamicMappedQueue(String mapping, boolean create) {
        String msg = "Mapping rule %s is dynamic - this might cause inconsistent behaviour compared to FS.";
        if (create) {
            msg = msg + " Also, setting auto-create-child-queue=true is necessary, because the create flag was set to true on the original placement rule.";
        }
        this.handle(MAPPED_DYNAMIC_QUEUE, null, String.format(msg, mapping));
    }

    private void handle(String actionName, String fsSetting, String message) {
        RuleAction action = this.actions.get(actionName);
        if (action != null) {
            switch (action) {
                case ABORT: {
                    String exceptionMessage = message != null ? message : String.format("Setting %s is not supported", fsSetting);
                    this.conversionOptions.handleError(exceptionMessage);
                    break;
                }
                case WARNING: {
                    String loggedMsg = message != null ? message : String.format("Setting %s is not supported, ignoring conversion", fsSetting);
                    this.conversionOptions.handleWarning(loggedMsg, LOG);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown action " + (Object)((Object)action));
                }
            }
        }
    }

    private void setActionForProperty(String property) {
        String action = this.properties.getProperty(property);
        if (action == null) {
            LOG.info("No rule set for {}, defaulting to WARNING", (Object)property);
            this.actions.put(property, RuleAction.WARNING);
        } else if (action.equalsIgnoreCase("warning")) {
            this.actions.put(property, RuleAction.WARNING);
        } else if (action.equalsIgnoreCase("abort")) {
            this.actions.put(property, RuleAction.ABORT);
        } else {
            LOG.warn("Unknown action {} set for rule {}, defaulting to WARNING", (Object)action, (Object)property);
            this.actions.put(property, RuleAction.WARNING);
        }
    }

    @VisibleForTesting
    public Map<String, RuleAction> getActions() {
        return this.actions;
    }

    @VisibleForTesting
    static enum RuleAction {
        WARNING,
        ABORT;

    }
}

