/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.AllocationFileParser;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSYarnSiteConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.PreconditionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.QueuePlacementConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FSConfigToCSConfigConverter {
    public static final Logger LOG = LoggerFactory.getLogger((String)FSConfigToCSConfigConverter.class.getName());
    private static final String YARN_SITE_XML = "yarn-site.xml";
    private static final String CAPACITY_SCHEDULER_XML = "capacity-scheduler.xml";
    private static final String FAIR_SCHEDULER_XML = "fair-scheduler.xml";
    public static final String WARNING_TEXT = "WARNING: This feature is experimental and not intended for production use!";
    private Resource clusterResource;
    private boolean preemptionEnabled = false;
    private int queueMaxAppsDefault;
    private float queueMaxAMShareDefault;
    private boolean autoCreateChildQueues = false;
    private boolean sizeBasedWeight = false;
    private boolean userAsDefaultQueue = false;
    private ConversionOptions conversionOptions;
    private boolean drfUsed = false;
    private Configuration convertedYarnSiteConfig;
    private Configuration capacitySchedulerConfig;
    private FSConfigToCSConfigRuleHandler ruleHandler;
    private QueuePlacementConverter placementConverter;
    private OutputStream yarnSiteOutputStream;
    private OutputStream capacitySchedulerOutputStream;
    private boolean consoleMode = false;
    private boolean convertPlacementRules = false;

    public FSConfigToCSConfigConverter(FSConfigToCSConfigRuleHandler ruleHandler, ConversionOptions conversionOptions) {
        this.ruleHandler = ruleHandler;
        this.conversionOptions = conversionOptions;
        this.yarnSiteOutputStream = System.out;
        this.capacitySchedulerOutputStream = System.out;
        this.placementConverter = new QueuePlacementConverter();
    }

    public void convert(FSConfigToCSConfigConverterParams params) throws Exception {
        this.validateParams(params);
        this.prepareOutputFiles(params.getOutputDirectory(), params.isConsole());
        this.loadConversionRules(params.getConversionRulesConfig());
        Configuration inputYarnSiteConfig = this.getInputYarnSiteConfig(params);
        this.handleFairSchedulerConfig(params, inputYarnSiteConfig);
        this.clusterResource = this.getClusterResource(params);
        this.convertPlacementRules = params.isConvertPlacementRules();
        this.convert(inputYarnSiteConfig);
    }

    private void prepareOutputFiles(String outputDirectory, boolean console) throws FileNotFoundException {
        if (console) {
            LOG.info("Console mode is enabled, yarn-site.xml and capacity-scheduler.xml will be only emitted to the console!");
            this.consoleMode = true;
            return;
        }
        File yarnSiteXmlOutput = new File(outputDirectory, YARN_SITE_XML);
        File schedulerXmlOutput = new File(outputDirectory, CAPACITY_SCHEDULER_XML);
        LOG.info("Output directory for yarn-site.xml and capacity-scheduler.xml is: {}", (Object)outputDirectory);
        this.yarnSiteOutputStream = new FileOutputStream(yarnSiteXmlOutput);
        this.capacitySchedulerOutputStream = new FileOutputStream(schedulerXmlOutput);
    }

    private void validateParams(FSConfigToCSConfigConverterParams params) {
        if (params.getYarnSiteXmlConfig() == null) {
            throw new PreconditionException("yarn-site.xml configuration is not defined but it is mandatory!");
        }
        if (params.getOutputDirectory() == null && !params.isConsole()) {
            throw new PreconditionException("Output directory configuration is not defined but it is mandatory!");
        }
    }

    private Resource getClusterResource(FSConfigToCSConfigConverterParams params) {
        Resource resource = null;
        if (params.getClusterResource() != null) {
            ConfigurableResource configurableResource;
            try {
                configurableResource = FairSchedulerConfiguration.parseResourceConfigValue(params.getClusterResource());
            }
            catch (AllocationConfigurationException e) {
                throw new ConversionException("Error while parsing resource.", e);
            }
            resource = configurableResource.getResource();
        }
        return resource;
    }

    private void loadConversionRules(String rulesFile) throws IOException {
        if (rulesFile != null) {
            LOG.info("Reading conversion rules file from: " + rulesFile);
            this.ruleHandler.loadRulesFromFile(rulesFile);
        } else {
            LOG.info("Conversion rules file is not defined, using default conversion config!");
        }
        this.ruleHandler.initPropertyActions();
    }

    private Configuration getInputYarnSiteConfig(FSConfigToCSConfigConverterParams params) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.addResource(new Path(params.getYarnSiteXmlConfig()));
        return conf;
    }

    private void handleFairSchedulerConfig(FSConfigToCSConfigConverterParams params, Configuration conf) {
        String fairSchedulerXmlConfig = params.getFairSchedulerXmlConfig();
        if (fairSchedulerXmlConfig != null) {
            LOG.info("Using explicitly defined fair-scheduler.xml");
        } else if (conf.get("yarn.scheduler.fair.allocation.file") != null) {
            LOG.info("Using fair-scheduler.xml defined in yarn-site.xml by key: yarn.scheduler.fair.allocation.file");
        } else {
            throw new PreconditionException("fair-scheduler.xml is not defined neither in yarn-site.xml(with property: yarn.scheduler.fair.allocation.file) nor directly with its own parameter!");
        }
        if (fairSchedulerXmlConfig != null) {
            conf.set("yarn.scheduler.fair.allocation.file", params.getFairSchedulerXmlConfig());
        }
    }

    @VisibleForTesting
    void convert(Configuration inputYarnSiteConfig) throws Exception {
        System.out.println(WARNING_TEXT);
        RMContextImpl ctx = new RMContextImpl();
        PlacementManager placementManager = new PlacementManager();
        ctx.setQueuePlacementManager(placementManager);
        Configuration fsConfig = new Configuration(inputYarnSiteConfig);
        fsConfig.setBoolean("yarn.scheduler.fair.migration.mode", true);
        fsConfig.setBoolean("yarn.scheduler.fair.no-terminal-rule.check", this.conversionOptions.isNoRuleTerminalCheck());
        fsConfig.setClass("yarn.authorization-provider", ConfiguredYarnAuthorizer.class, YarnAuthorizationProvider.class);
        FairScheduler fs = new FairScheduler();
        fs.setRMContext(ctx);
        fs.init(fsConfig);
        boolean havePlacementPolicies = this.checkPlacementPoliciesPresent(fs, inputYarnSiteConfig);
        this.drfUsed = this.isDrfUsed(fs);
        AllocationConfiguration allocConf = fs.getAllocationConfiguration();
        this.queueMaxAppsDefault = allocConf.getQueueMaxAppsDefault();
        this.queueMaxAMShareDefault = allocConf.getQueueMaxAMShareDefault();
        this.convertedYarnSiteConfig = new Configuration(false);
        this.capacitySchedulerConfig = new Configuration(false);
        this.checkUserMaxApps(allocConf);
        this.checkUserMaxAppsDefault(allocConf);
        this.convertYarnSiteXml(inputYarnSiteConfig, havePlacementPolicies);
        this.convertCapacitySchedulerXml(fs);
        if (this.consoleMode) {
            System.out.println("======= capacity-scheduler.xml =======");
        }
        this.capacitySchedulerConfig.writeXml(this.capacitySchedulerOutputStream);
        if (this.consoleMode) {
            System.out.println();
            System.out.println("======= yarn-site.xml =======");
        }
        this.convertedYarnSiteConfig.writeXml(this.yarnSiteOutputStream);
    }

    private void convertYarnSiteXml(Configuration inputYarnSiteConfig, boolean havePlacementPolicies) {
        FSYarnSiteConverter siteConverter = new FSYarnSiteConverter();
        siteConverter.convertSiteProperties(inputYarnSiteConfig, this.convertedYarnSiteConfig, this.drfUsed);
        this.autoCreateChildQueues = !havePlacementPolicies && siteConverter.isAutoCreateChildQueues();
        this.userAsDefaultQueue = !havePlacementPolicies && siteConverter.isUserAsDefaultQueue();
        this.preemptionEnabled = siteConverter.isPreemptionEnabled();
        this.sizeBasedWeight = siteConverter.isSizeBasedWeight();
        this.checkReservationSystem(inputYarnSiteConfig);
    }

    private void convertCapacitySchedulerXml(FairScheduler fs) {
        FSParentQueue rootQueue = fs.getQueueManager().getRootQueue();
        this.emitDefaultMaxApplications();
        this.emitDefaultMaxAMShare();
        FSQueueConverter queueConverter = FSQueueConverterBuilder.create().withRuleHandler(this.ruleHandler).withCapacitySchedulerConfig(this.capacitySchedulerConfig).withPreemptionEnabled(this.preemptionEnabled).withSizeBasedWeight(this.sizeBasedWeight).withAutoCreateChildQueues(this.autoCreateChildQueues).withClusterResource(this.clusterResource).withQueueMaxAMShareDefault(this.queueMaxAMShareDefault).withQueueMaxAppsDefault(this.queueMaxAppsDefault).withConversionOptions(this.conversionOptions).withDrfUsed(this.drfUsed).build();
        queueConverter.convertQueueHierarchy(rootQueue);
        this.emitACLs(fs);
        if (this.convertPlacementRules) {
            LOG.info("Converting placement rules");
            PlacementManager placementManager = fs.getRMContext().getQueuePlacementManager();
            if (placementManager.getPlacementRules().size() > 0) {
                Map<String, String> properties = this.placementConverter.convertPlacementPolicy(placementManager, this.ruleHandler, this.userAsDefaultQueue);
                properties.forEach((k, v) -> this.capacitySchedulerConfig.set(k, v));
            }
        } else {
            LOG.info("Ignoring the conversion of placement rules");
        }
    }

    private void emitDefaultMaxApplications() {
        if (this.queueMaxAppsDefault != Integer.MAX_VALUE) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity.maximum-applications", String.valueOf(this.queueMaxAppsDefault));
        }
    }

    private void emitDefaultMaxAMShare() {
        if (this.queueMaxAMShareDefault == -1.0f) {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 1.0f);
        } else {
            this.capacitySchedulerConfig.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", this.queueMaxAMShareDefault);
        }
    }

    private void emitACLs(FairScheduler fs) {
        fs.getAllocationConfiguration().getQueueAcls().forEach(this::generateQueueAcl);
    }

    private void generateQueueAcl(String queue, Map<AccessType, AccessControlList> access) {
        AccessControlList submitAcls = access.get(AccessType.SUBMIT_APP);
        AccessControlList adminAcls = access.get(AccessType.ADMINISTER_QUEUE);
        if (!submitAcls.getGroups().isEmpty() || !submitAcls.getUsers().isEmpty()) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queue + ".acl_submit_applications", submitAcls.getAclString());
        }
        if (!adminAcls.getGroups().isEmpty() || !adminAcls.getUsers().isEmpty()) {
            this.capacitySchedulerConfig.set("yarn.scheduler.capacity." + queue + ".acl_administer_queue", adminAcls.getAclString());
        }
    }

    private void checkReservationSystem(Configuration conf) {
        if (conf.getBoolean("yarn.resourcemanager.reservation-system.enable", false)) {
            this.ruleHandler.handleReservationSystem();
        }
    }

    private void checkUserMaxApps(AllocationConfiguration allocConf) {
        if (allocConf.getUserMaxApps() != null && allocConf.getUserMaxApps().size() > 0) {
            this.ruleHandler.handleUserMaxApps();
        }
    }

    private void checkUserMaxAppsDefault(AllocationConfiguration allocConf) {
        if (allocConf.getUserMaxAppsDefault() > 0) {
            this.ruleHandler.handleUserMaxAppsDefault();
        }
    }

    private boolean isDrfUsed(FairScheduler fs) {
        FSParentQueue rootQueue = fs.getQueueManager().getRootQueue();
        AllocationConfiguration allocConf = fs.getAllocationConfiguration();
        String defaultPolicy = allocConf.getDefaultSchedulingPolicy().getName();
        return "DRF".equals(defaultPolicy) || this.isDrfUsedOnQueueLevel(rootQueue);
    }

    private boolean isDrfUsedOnQueueLevel(FSQueue queue) {
        String policy = queue.getPolicy().getName();
        boolean usesDrf = "DRF".equals(policy);
        if (usesDrf) {
            return true;
        }
        List<FSQueue> children = queue.getChildQueues();
        if (children != null) {
            for (FSQueue child : children) {
                usesDrf |= this.isDrfUsedOnQueueLevel(child);
            }
        }
        return usesDrf;
    }

    @VisibleForTesting
    Resource getClusterResource() {
        return this.clusterResource;
    }

    @VisibleForTesting
    public void setClusterResource(Resource clusterResource) {
        this.clusterResource = clusterResource;
    }

    @VisibleForTesting
    FSConfigToCSConfigRuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    @VisibleForTesting
    Configuration getYarnSiteConfig() {
        return this.convertedYarnSiteConfig;
    }

    @VisibleForTesting
    Configuration getCapacitySchedulerConfig() {
        return this.capacitySchedulerConfig;
    }

    @VisibleForTesting
    void setConvertPlacementRules(boolean convertPlacementRules) {
        this.convertPlacementRules = convertPlacementRules;
    }

    @VisibleForTesting
    void setPlacementConverter(QueuePlacementConverter converter) {
        this.placementConverter = converter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkPlacementPoliciesPresent(FairScheduler scheduler, Configuration inputYarnSiteConfig) throws RuntimeException {
        try (AllocationFileLoaderService loader = new AllocationFileLoaderService(scheduler);){
            Path allocFilePath = loader.getAllocationFile(inputYarnSiteConfig);
            FileSystem fs = allocFilePath.getFileSystem(inputYarnSiteConfig);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse((InputStream)fs.open(allocFilePath));
            Element root = doc.getDocumentElement();
            NodeList elements = root.getChildNodes();
            AllocationFileParser allocationFileParser = new AllocationFileParser(elements);
            allocationFileParser.parse();
            docBuilderFactory.setIgnoringComments(true);
            boolean bl = allocationFileParser.getQueuePlacementPolicy().isPresent();
            return bl;
        }
        catch (Exception e) {
            throw new PreconditionException("Unable to parse allocation file", e);
        }
    }
}

