/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocation.QueueProperties;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AllocationFileQueueParser {
    private static final Logger LOG = LoggerFactory.getLogger(AllocationFileQueueParser.class);
    public static final String ROOT = "root";
    public static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private static final String MIN_RESOURCES = "minResources";
    private static final String MAX_RESOURCES = "maxResources";
    private static final String MAX_CHILD_RESOURCES = "maxChildResources";
    private static final String MAX_RUNNING_APPS = "maxRunningApps";
    private static final String MAX_AMSHARE = "maxAMShare";
    public static final String MAX_CONTAINER_ALLOCATION = "maxContainerAllocation";
    private static final String WEIGHT = "weight";
    private static final String MIN_SHARE_PREEMPTION_TIMEOUT = "minSharePreemptionTimeout";
    private static final String FAIR_SHARE_PREEMPTION_TIMEOUT = "fairSharePreemptionTimeout";
    private static final String FAIR_SHARE_PREEMPTION_THRESHOLD = "fairSharePreemptionThreshold";
    private static final String SCHEDULING_POLICY = "schedulingPolicy";
    private static final String SCHEDULING_MODE = "schedulingMode";
    private static final String ACL_SUBMIT_APPS = "aclSubmitApps";
    private static final String ACL_ADMINISTER_APPS = "aclAdministerApps";
    private static final String ACL_ADMINISTER_RESERVATIONS = "aclAdministerReservations";
    private static final String ACL_LIST_RESERVATIONS = "aclListReservations";
    private static final String ACL_SUBMIT_RESERVATIONS = "aclSubmitReservations";
    private static final String RESERVATION = "reservation";
    private static final String ALLOW_PREEMPTION_FROM = "allowPreemptionFrom";
    private static final String QUEUE = "queue";
    private static final String POOL = "pool";
    private final List<Element> elements;

    public AllocationFileQueueParser(List<Element> elements) {
        this.elements = elements;
    }

    public QueueProperties parse() throws AllocationConfigurationException {
        QueueProperties.Builder queuePropertiesBuilder = new QueueProperties.Builder();
        for (Element element : this.elements) {
            String parent = ROOT;
            if (element.getAttribute("name").equalsIgnoreCase(ROOT)) {
                if (this.elements.size() > 1) {
                    throw new AllocationConfigurationException("If configuring root queue, no other queues can be placed alongside it.");
                }
                parent = null;
            }
            this.loadQueue(parent, element, queuePropertiesBuilder);
        }
        return queuePropertiesBuilder.build();
    }

    private void loadQueue(String parentName, Element element, QueueProperties.Builder builder) throws AllocationConfigurationException {
        String queueName = FairSchedulerUtilities.trimQueueName(element.getAttribute("name"));
        if (queueName.contains(".")) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: queue name (" + queueName + ") shouldn't contain period.");
        }
        if (queueName.isEmpty()) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: queue name shouldn't be empty or consist only of whitespace.");
        }
        if (parentName != null) {
            queueName = parentName + "." + queueName;
        }
        NodeList fields = element.getChildNodes();
        boolean isLeaf = true;
        boolean isReservable = false;
        for (int j = 0; j < fields.getLength(); ++j) {
            String text;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if (MIN_RESOURCES.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                ConfigurableResource val = FairSchedulerConfiguration.parseResourceConfigValue(text, 0L);
                builder.minQueueResources(queueName, val.getResource());
                continue;
            }
            if (MAX_RESOURCES.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                ConfigurableResource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                builder.maxQueueResources(queueName, val);
                continue;
            }
            if (MAX_CHILD_RESOURCES.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                ConfigurableResource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                builder.maxChildQueueResources(queueName, val);
                continue;
            }
            if (MAX_RUNNING_APPS.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                int val = Integer.parseInt(text);
                builder.queueMaxApps(queueName, val);
                continue;
            }
            if (MAX_AMSHARE.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                float val = Float.parseFloat(text);
                val = Math.min(val, 1.0f);
                builder.queueMaxAMShares(queueName, val);
                continue;
            }
            if (MAX_CONTAINER_ALLOCATION.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                ConfigurableResource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                builder.queueMaxContainerAllocation(queueName, val.getResource());
                continue;
            }
            if (WEIGHT.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                double val = Double.parseDouble(text);
                builder.queueWeights(queueName, (float)val);
                continue;
            }
            if (MIN_SHARE_PREEMPTION_TIMEOUT.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                long val = Long.parseLong(text) * 1000L;
                builder.minSharePreemptionTimeouts(queueName, val);
                continue;
            }
            if (FAIR_SHARE_PREEMPTION_TIMEOUT.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                long val = Long.parseLong(text) * 1000L;
                builder.fairSharePreemptionTimeouts(queueName, val);
                continue;
            }
            if (FAIR_SHARE_PREEMPTION_THRESHOLD.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                float val = Float.parseFloat(text);
                val = Math.max(Math.min(val, 1.0f), 0.0f);
                builder.fairSharePreemptionThresholds(queueName, val);
                continue;
            }
            if (SCHEDULING_POLICY.equals(field.getTagName()) || SCHEDULING_MODE.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                SchedulingPolicy policy = SchedulingPolicy.parse(text);
                builder.queuePolicies(queueName, policy);
                continue;
            }
            if (ACL_SUBMIT_APPS.equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                builder.queueAcls(queueName, AccessType.SUBMIT_APP, new AccessControlList(text));
                continue;
            }
            if (ACL_ADMINISTER_APPS.equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                builder.queueAcls(queueName, AccessType.ADMINISTER_QUEUE, new AccessControlList(text));
                continue;
            }
            if (ACL_ADMINISTER_RESERVATIONS.equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                builder.reservationAcls(queueName, ReservationACL.ADMINISTER_RESERVATIONS, new AccessControlList(text));
                continue;
            }
            if (ACL_LIST_RESERVATIONS.equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                builder.reservationAcls(queueName, ReservationACL.LIST_RESERVATIONS, new AccessControlList(text));
                continue;
            }
            if (ACL_SUBMIT_RESERVATIONS.equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                builder.reservationAcls(queueName, ReservationACL.SUBMIT_RESERVATIONS, new AccessControlList(text));
                continue;
            }
            if (RESERVATION.equals(field.getTagName())) {
                isReservable = true;
                builder.reservableQueues(queueName);
                builder.configuredQueues(FSQueueType.PARENT, queueName);
                continue;
            }
            if (ALLOW_PREEMPTION_FROM.equals(field.getTagName())) {
                text = this.getTrimmedTextData(field);
                if (Boolean.parseBoolean(text)) continue;
                builder.nonPreemptableQueues(queueName);
                continue;
            }
            if (!QUEUE.endsWith(field.getTagName()) && !POOL.equals(field.getTagName())) continue;
            this.loadQueue(queueName, field, builder);
            isLeaf = false;
        }
        if (isLeaf && !"parent".equals(element.getAttribute("type"))) {
            if (!isReservable) {
                builder.configuredQueues(FSQueueType.LEAF, queueName);
            }
        } else {
            if (isReservable) {
                throw new AllocationConfigurationException("The configuration settings for " + queueName + " are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
            }
            builder.configuredQueues(FSQueueType.PARENT, queueName);
        }
        for (QueueACL acl : QueueACL.values()) {
            AccessType accessType = SchedulerUtils.toAccessType(acl);
            if (builder.isAclDefinedForAccessType(queueName, accessType)) continue;
            AccessControlList defaultAcl = queueName.equals(ROOT) ? EVERYBODY_ACL : NOBODY_ACL;
            builder.queueAcls(queueName, accessType, defaultAcl);
        }
        this.checkMinAndMaxResource(builder.getMinQueueResources(), builder.getMaxQueueResources(), queueName);
    }

    private String getTrimmedTextData(Element element) {
        return ((Text)element.getFirstChild()).getData().trim();
    }

    private void checkMinAndMaxResource(Map<String, Resource> minResources, Map<String, ConfigurableResource> maxResources, String queueName) {
        Resource maxResource;
        ConfigurableResource maxConfigurableResource = maxResources.get(queueName);
        Resource minResource = minResources.get(queueName);
        if (maxConfigurableResource != null && minResource != null && (maxResource = maxConfigurableResource.getResource()) != null && !Resources.fitsIn((Resource)minResource, (Resource)maxResource)) {
            LOG.warn(String.format("Queue %s has max resources %s less than min resources %s", queueName, maxResource, minResource));
        }
    }
}

