/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementFactory;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
final class QueuePlacementPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QueuePlacementPolicy.class);
    private static final Map<String, RuleMap> RULES;

    private QueuePlacementPolicy() {
    }

    private static void updateRuleSet(List<PlacementRule> newRules, List<Boolean> newTerminalState, FairScheduler fs) throws AllocationConfigurationException {
        if (newRules.isEmpty()) {
            LOG.debug("Empty rule set defined, ignoring update");
            return;
        }
        LOG.debug("Placement rule order check");
        for (int i = 0; i < newTerminalState.size() - 1; ++i) {
            if (!newTerminalState.get(i).booleanValue()) continue;
            String errorMsg = "Rules after rule " + (i + 1) + " in queue placement policy can never be reached";
            if (fs.isNoTerminalRuleCheck()) {
                LOG.warn(errorMsg);
                continue;
            }
            throw new AllocationConfigurationException(errorMsg);
        }
        if (!newTerminalState.get(newTerminalState.size() - 1).booleanValue()) {
            throw new AllocationConfigurationException("Could get past last queue placement rule without assigning");
        }
        LOG.debug("Initialising new rule set");
        try {
            for (PlacementRule rule : newRules) {
                rule.initialize(fs);
            }
        }
        catch (IOException ioe) {
            throw new AllocationConfigurationException("Rule initialisation failed with exception", ioe);
        }
        fs.getRMContext().getQueuePlacementManager().updateRules(newRules);
        LOG.debug("PlacementManager active with new rule set");
    }

    static void fromXml(Element confElement, FairScheduler fs) throws AllocationConfigurationException {
        LOG.debug("Reloading placement policy from allocation config");
        if (confElement == null || !confElement.hasChildNodes()) {
            throw new AllocationConfigurationException("Empty configuration for QueuePlacementPolicy is not allowed");
        }
        ArrayList<PlacementRule> newRules = new ArrayList<PlacementRule>();
        ArrayList<Boolean> newTerminalState = new ArrayList<Boolean>();
        NodeList elements = confElement.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equalsIgnoreCase("rule")) continue;
            String name = ((Element)node).getAttribute("name");
            LOG.debug("Creating new rule: {}", (Object)name);
            PlacementRule rule = QueuePlacementPolicy.createRule((Element)node);
            PlacementRule parentRule = null;
            String parentName = null;
            Element child = QueuePlacementPolicy.getParentRuleElement(node);
            if (child != null) {
                parentName = child.getAttribute("name");
                parentRule = QueuePlacementPolicy.getParentRule(child, fs);
            }
            if (name.equalsIgnoreCase("nestedUserQueue") && parentRule == null) {
                throw new AllocationConfigurationException("Rule '" + name + "' must have a parent rule set");
            }
            newRules.add(rule);
            if (parentRule == null) {
                newTerminalState.add(QueuePlacementPolicy.getTerminal(RULES.get(name).terminal, rule));
                continue;
            }
            ((FSPlacementRule)rule).setParentRule(parentRule);
            newTerminalState.add(QueuePlacementPolicy.getTerminal(RULES.get(name).terminal, rule) != false && QueuePlacementPolicy.getTerminal(RULES.get(parentName).terminal, parentRule) != false);
        }
        QueuePlacementPolicy.updateRuleSet(newRules, newTerminalState, fs);
    }

    private static Element getParentRuleElement(Node node) throws AllocationConfigurationException {
        String parentName;
        Element parent = null;
        if (node.hasChildNodes()) {
            NodeList childList = node.getChildNodes();
            for (int j = 0; j < childList.getLength(); ++j) {
                Node child = childList.item(j);
                if (!(child instanceof Element) || !child.getNodeName().equalsIgnoreCase("rule")) continue;
                if (parent != null) {
                    LOG.warn("Rule '{}' has multiple parent rules defined, only the last parent rule will be used", (Object)((Element)node).getAttribute("name"));
                }
                parent = (Element)child;
            }
        }
        if (parent != null && ((parentName = parent.getAttribute("name")).equals("reject") || parentName.equals("nestedUserQueue"))) {
            throw new AllocationConfigurationException("Rule '" + parentName + "' is not allowed as a parent rule for any rule");
        }
        return parent;
    }

    private static PlacementRule getParentRule(Element parent, FairScheduler fs) throws AllocationConfigurationException {
        LOG.debug("Creating new parent rule: {}", (Object)parent.getAttribute("name"));
        PlacementRule parentRule = QueuePlacementPolicy.createRule(parent);
        try {
            parentRule.initialize(fs);
        }
        catch (IOException ioe) {
            throw new AllocationConfigurationException("Parent Rule initialisation failed with exception", ioe);
        }
        return parentRule;
    }

    private static Boolean getTerminal(String terminal, PlacementRule rule) {
        switch (terminal) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return ((FSPlacementRule)rule).getCreateFlag();
    }

    private static PlacementRule createRule(Element element) throws AllocationConfigurationException {
        String ruleName = element.getAttribute("name");
        if ("".equals(ruleName)) {
            throw new AllocationConfigurationException("No name provided for a rule element");
        }
        Class ruleClass = null;
        if (RULES.containsKey(ruleName)) {
            ruleClass = RULES.get(ruleName).ruleClass;
        }
        if (ruleClass == null) {
            throw new AllocationConfigurationException("No rule class found for " + ruleName);
        }
        return PlacementFactory.getPlacementRule(ruleClass, element);
    }

    static void fromConfiguration(FairScheduler fs) {
        LOG.debug("Creating base placement policy from config");
        Configuration conf = fs.getConfig();
        boolean create = conf.getBoolean("yarn.scheduler.fair.allow-undeclared-pools", true);
        boolean userAsDefaultQueue = conf.getBoolean("yarn.scheduler.fair.user-as-default-queue", true);
        ArrayList<PlacementRule> newRules = new ArrayList<PlacementRule>();
        ArrayList<Boolean> newTerminalState = new ArrayList<Boolean>();
        Class clazz = RULES.get("specified").ruleClass;
        newRules.add(PlacementFactory.getPlacementRule(clazz, create));
        newTerminalState.add(false);
        if (userAsDefaultQueue) {
            clazz = RULES.get("user").ruleClass;
            newRules.add(PlacementFactory.getPlacementRule(clazz, create));
            newTerminalState.add(create);
        }
        if (!userAsDefaultQueue || !create) {
            clazz = RULES.get("default").ruleClass;
            newRules.add(PlacementFactory.getPlacementRule(clazz, true));
            newTerminalState.add(true);
        }
        try {
            QueuePlacementPolicy.updateRuleSet(newRules, newTerminalState, fs);
        }
        catch (AllocationConfigurationException ex) {
            throw new RuntimeException("Should never hit exception when loadingplacement policy from conf", ex);
        }
    }

    static {
        HashMap<String, RuleMap> map = new HashMap<String, RuleMap>();
        map.put("user", new RuleMap(UserPlacementRule.class, "create"));
        map.put("primaryGroup", new RuleMap(PrimaryGroupPlacementRule.class, "create"));
        map.put("secondaryGroupExistingQueue", new RuleMap(SecondaryGroupExistingPlacementRule.class, "false"));
        map.put("specified", new RuleMap(SpecifiedPlacementRule.class, "false"));
        map.put("nestedUserQueue", new RuleMap(UserPlacementRule.class, "create"));
        map.put("default", new RuleMap(DefaultPlacementRule.class, "create"));
        map.put("reject", new RuleMap(RejectPlacementRule.class, "true"));
        RULES = Collections.unmodifiableMap(map);
    }

    private static final class RuleMap {
        private final Class<? extends PlacementRule> ruleClass;
        private final String terminal;

        private RuleMap(Class<? extends PlacementRule> clazz, String terminate) {
            this.ruleClass = clazz;
            this.terminal = terminate;
        }
    }
}

