/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.timelineservice;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerPauseEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResumeEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelineEvent;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelineEventType;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMTimelinePublisher
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(NMTimelinePublisher.class);
    private Dispatcher dispatcher;
    private Context context;
    private NodeId nodeId;
    private String httpAddress;
    private String httpPort;
    private UserGroupInformation nmLoginUGI;
    private final Map<ApplicationId, TimelineV2Client> appToClientMap;
    private boolean publishNMContainerEvents = true;

    public NMTimelinePublisher(Context context) {
        super(NMTimelinePublisher.class.getName());
        this.context = context;
        this.appToClientMap = new ConcurrentHashMap<ApplicationId, TimelineV2Client>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = this.createDispatcher();
        this.dispatcher.register(NMTimelineEventType.class, (EventHandler)new ForwardingEventHandler());
        this.addIfService(this.dispatcher);
        this.nmLoginUGI = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.getLoginUser() : UserGroupInformation.getCurrentUser();
        LOG.info("Initialized NMTimelinePublisher UGI to " + this.nmLoginUGI);
        String webAppURLWithoutScheme = WebAppUtils.getNMWebAppURLWithoutScheme((Configuration)conf);
        if (webAppURLWithoutScheme.contains(":")) {
            this.httpPort = webAppURLWithoutScheme.split(":")[1];
        }
        this.publishNMContainerEvents = conf.getBoolean("yarn.nodemanager.emit-container-events", true);
        super.serviceInit(conf);
    }

    protected AsyncDispatcher createDispatcher() {
        return new AsyncDispatcher("NM Timeline dispatcher");
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.nodeId = this.context.getNodeId();
        this.httpAddress = this.nodeId.getHost() + ":" + this.httpPort;
    }

    protected void serviceStop() throws Exception {
        for (ApplicationId app : this.appToClientMap.keySet()) {
            this.stopTimelineClient(app);
        }
        super.serviceStop();
    }

    @VisibleForTesting
    Map<ApplicationId, TimelineV2Client> getAppToClientMap() {
        return this.appToClientMap;
    }

    protected void handleNMTimelineEvent(NMTimelineEvent event) {
        switch ((NMTimelineEventType)event.getType()) {
            case TIMELINE_ENTITY_PUBLISH: {
                this.putEntity(((TimelinePublishEvent)event).getTimelineEntityToPublish(), ((TimelinePublishEvent)event).getApplicationId());
                break;
            }
            case STOP_TIMELINE_CLIENT: {
                this.removeAndStopTimelineClient(event.getApplicationId());
                break;
            }
            default: {
                LOG.error("Unknown NMTimelineEvent type: " + event.getType());
            }
        }
    }

    public void reportContainerResourceUsage(Container container, Long pmemUsage, Float cpuUsagePercentPerCore) {
        if (this.publishNMContainerEvents && (pmemUsage != -1L || cpuUsagePercentPerCore.floatValue() != -1.0f)) {
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(container.getContainerId());
            long currentTimeMillis = System.currentTimeMillis();
            if (pmemUsage != -1L) {
                TimelineMetric memoryMetric = new TimelineMetric();
                memoryMetric.setId(ContainersMonitorImpl.ContainerMetric.MEMORY.toString());
                memoryMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                memoryMetric.addValue(currentTimeMillis, (Number)pmemUsage);
                entity.addMetric(memoryMetric);
            }
            if (cpuUsagePercentPerCore.floatValue() != -1.0f) {
                TimelineMetric cpuMetric = new TimelineMetric();
                cpuMetric.setId(ContainersMonitorImpl.ContainerMetric.CPU.toString());
                cpuMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                cpuMetric.addValue(currentTimeMillis, (Number)Math.round(cpuUsagePercentPerCore.floatValue()));
                entity.addMetric(cpuMetric);
            }
            ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
            try {
                TimelineV2Client timelineClient = this.getTimelineClient(appId);
                if (timelineClient != null) {
                    timelineClient.putEntitiesAsync(new TimelineEntity[]{entity});
                } else {
                    LOG.error("Seems like client has been removed before the container metric could be published for " + container.getContainerId());
                }
            }
            catch (IOException e) {
                LOG.error("Failed to publish Container metrics for container " + container.getContainerId());
                LOG.debug("Failed to publish Container metrics for container {}", (Object)container.getContainerId(), (Object)e);
            }
            catch (YarnException e) {
                LOG.error("Failed to publish Container metrics for container " + container.getContainerId(), (Object)e.getMessage());
                LOG.debug("Failed to publish Container metrics for container {}", (Object)container.getContainerId(), (Object)e);
            }
        }
    }

    private void publishContainerCreatedEvent(ContainerEvent event) {
        if (this.publishNMContainerEvents) {
            ContainerId containerId = event.getContainerID();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            Container container = (Container)this.context.getContainers().get(containerId);
            Resource resource = container.getResource();
            HashMap<String, Object> entityInfo = new HashMap<String, Object>();
            entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", resource.getMemorySize());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", resource.getVirtualCores());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", this.nodeId.getHost());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", this.nodeId.getPort());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", container.getPriority().toString());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", this.httpAddress);
            entity.setInfo(entityInfo);
            TimelineEvent tEvent = new TimelineEvent();
            tEvent.setId("YARN_CONTAINER_CREATED");
            tEvent.setTimestamp(event.getTimestamp());
            long containerStartTime = container.getContainerStartTime();
            entity.addEvent(tEvent);
            entity.setCreatedTime(Long.valueOf(containerStartTime));
            this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
        }
    }

    private void publishContainerResumedEvent(ContainerEvent event) {
        if (this.publishNMContainerEvents) {
            ContainerResumeEvent resumeEvent = (ContainerResumeEvent)event;
            ContainerId containerId = resumeEvent.getContainerID();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            HashMap<String, String> entityInfo = new HashMap<String, String>();
            entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", resumeEvent.getDiagnostic());
            entity.setInfo(entityInfo);
            Container container = (Container)this.context.getContainers().get(containerId);
            if (container != null) {
                TimelineEvent tEvent = new TimelineEvent();
                tEvent.setId("YARN_CONTAINER_RESUMED");
                tEvent.setTimestamp(event.getTimestamp());
                entity.addEvent(tEvent);
                this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
            }
        }
    }

    private void publishContainerPausedEvent(ContainerEvent event) {
        if (this.publishNMContainerEvents) {
            ContainerPauseEvent pauseEvent = (ContainerPauseEvent)event;
            ContainerId containerId = pauseEvent.getContainerID();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            HashMap<String, String> entityInfo = new HashMap<String, String>();
            entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", pauseEvent.getDiagnostic());
            entity.setInfo(entityInfo);
            Container container = (Container)this.context.getContainers().get(containerId);
            if (container != null) {
                TimelineEvent tEvent = new TimelineEvent();
                tEvent.setId("YARN_CONTAINER_PAUSED");
                tEvent.setTimestamp(event.getTimestamp());
                entity.addEvent(tEvent);
                this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
            }
        }
    }

    private void publishContainerKilledEvent(ContainerEvent event) {
        if (this.publishNMContainerEvents) {
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            ContainerId containerId = killEvent.getContainerID();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            HashMap<String, Object> entityInfo = new HashMap<String, Object>();
            entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", killEvent.getDiagnostic());
            entityInfo.put("YARN_CONTAINER_EXIT_STATUS", killEvent.getContainerExitStatus());
            entity.setInfo(entityInfo);
            Container container = (Container)this.context.getContainers().get(containerId);
            if (container != null) {
                TimelineEvent tEvent = new TimelineEvent();
                tEvent.setId("YARN_CONTAINER_KILLED");
                tEvent.setTimestamp(event.getTimestamp());
                entity.addEvent(tEvent);
                this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
            }
        }
    }

    private void publishContainerFinishedEvent(ContainerStatus containerStatus, long containerFinishTime, long containerStartTime) {
        if (this.publishNMContainerEvents) {
            ContainerId containerId = containerStatus.getContainerId();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            HashMap<String, Object> entityInfo = new HashMap<String, Object>();
            entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", containerStatus.getDiagnostics());
            entityInfo.put("YARN_CONTAINER_EXIT_STATUS", containerStatus.getExitStatus());
            entityInfo.put("YARN_CONTAINER_STATE", ContainerState.COMPLETE.toString());
            entityInfo.put("YARN_CONTAINER_FINISHED_TIME", containerFinishTime);
            entity.setInfo(entityInfo);
            TimelineEvent tEvent = new TimelineEvent();
            tEvent.setId("YARN_CONTAINER_FINISHED");
            tEvent.setTimestamp(containerFinishTime);
            entity.addEvent(tEvent);
            this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
        }
    }

    private void publishContainerLocalizationEvent(ContainerLocalizationEvent event, String eventType) {
        if (this.publishNMContainerEvents) {
            Container container = event.getContainer();
            ContainerId containerId = container.getContainerId();
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
            TimelineEvent tEvent = new TimelineEvent();
            tEvent.setId(eventType);
            tEvent.setTimestamp(event.getTimestamp());
            entity.addEvent(tEvent);
            ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
            try {
                TimelineV2Client timelineClient = this.getTimelineClient(appId);
                if (timelineClient != null) {
                    timelineClient.putEntitiesAsync(new TimelineEntity[]{entity});
                } else {
                    LOG.error("Seems like client has been removed before the event could be published for " + container.getContainerId());
                }
            }
            catch (IOException e) {
                LOG.error("Failed to publish Container metrics for container " + container.getContainerId());
                LOG.debug("Failed to publish Container metrics for container {}", (Object)container.getContainerId(), (Object)e);
            }
            catch (YarnException e) {
                LOG.error("Failed to publish Container metrics for container " + container.getContainerId(), (Object)e.getMessage());
                LOG.debug("Failed to publish Container metrics for container {}", (Object)container.getContainerId(), (Object)e);
            }
        }
    }

    private static ContainerEntity createContainerEntity(ContainerId containerId) {
        ContainerEntity entity = new ContainerEntity();
        entity.setId(containerId.toString());
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)containerId.getContainerId()));
        TimelineEntity.Identifier parentIdentifier = new TimelineEntity.Identifier();
        parentIdentifier.setType(TimelineEntityType.YARN_APPLICATION_ATTEMPT.name());
        parentIdentifier.setId(containerId.getApplicationAttemptId().toString());
        entity.setParent(parentIdentifier);
        return entity;
    }

    private void putEntity(TimelineEntity entity, ApplicationId appId) {
        try {
            TimelineV2Client timelineClient;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Publishing the entity {} JSON-style content: {}", (Object)entity, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            }
            if ((timelineClient = this.getTimelineClient(appId)) != null) {
                timelineClient.putEntities(new TimelineEntity[]{entity});
            } else {
                LOG.error("Seems like client has been removed before the entity could be published for " + entity);
            }
        }
        catch (IOException e) {
            LOG.error("Error when publishing entity " + entity);
            LOG.debug("Error when publishing entity {}", (Object)entity, (Object)e);
        }
        catch (YarnException e) {
            LOG.error("Error when publishing entity " + entity, (Object)e.getMessage());
            LOG.debug("Error when publishing entity {}", (Object)entity, (Object)e);
        }
    }

    public void publishApplicationEvent(ApplicationEvent event) {
        switch ((ApplicationEventType)event.getType()) {
            case INIT_APPLICATION: 
            case FINISH_APPLICATION: 
            case APPLICATION_LOG_HANDLING_FAILED: {
                break;
            }
            case APPLICATION_CONTAINER_FINISHED: {
                ApplicationContainerFinishedEvent evnt = (ApplicationContainerFinishedEvent)event;
                this.publishContainerFinishedEvent(evnt.getContainerStatus(), event.getTimestamp(), evnt.getContainerStartTime());
                break;
            }
            default: {
                LOG.debug("{} is not a desired ApplicationEvent which needs to be published by NMTimelinePublisher", (Object)event.getType());
            }
        }
    }

    public void publishContainerEvent(ContainerEvent event) {
        switch ((ContainerEventType)event.getType()) {
            case INIT_CONTAINER: {
                this.publishContainerCreatedEvent(event);
                break;
            }
            case KILL_CONTAINER: {
                this.publishContainerKilledEvent(event);
                break;
            }
            case PAUSE_CONTAINER: {
                this.publishContainerPausedEvent(event);
                break;
            }
            case RESUME_CONTAINER: {
                this.publishContainerResumedEvent(event);
                break;
            }
            default: {
                LOG.debug("{} is not a desired ContainerEvent which needs to be  published by NMTimelinePublisher", (Object)event.getType());
            }
        }
    }

    public void publishLocalizationEvent(LocalizationEvent event) {
        switch ((LocalizationEventType)event.getType()) {
            case CONTAINER_RESOURCES_LOCALIZED: {
                this.publishContainerLocalizationEvent((ContainerLocalizationEvent)event, "YARN_NM_CONTAINER_LOCALIZATION_FINISHED");
                break;
            }
            case LOCALIZE_CONTAINER_RESOURCES: {
                this.publishContainerLocalizationEvent((ContainerLocalizationEvent)event, "YARN_NM_CONTAINER_LOCALIZATION_STARTED");
                break;
            }
            default: {
                LOG.debug("{} is not a desired LocalizationEvent which needs to be published by NMTimelinePublisher", (Object)event.getType());
            }
        }
    }

    public void createTimelineClient(final ApplicationId appId) {
        if (!this.appToClientMap.containsKey(appId)) {
            try {
                TimelineV2Client timelineClient = (TimelineV2Client)this.nmLoginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineV2Client>(){

                    @Override
                    public TimelineV2Client run() throws Exception {
                        TimelineV2Client timelineClient = TimelineV2Client.createTimelineClient((ApplicationId)appId);
                        timelineClient.init(NMTimelinePublisher.this.getConfig());
                        timelineClient.start();
                        return timelineClient;
                    }
                });
                this.appToClientMap.put(appId, timelineClient);
            }
            catch (IOException | Error | InterruptedException | RuntimeException e) {
                LOG.warn("Unable to create timeline client for app " + appId, e);
            }
        }
    }

    public void stopTimelineClient(ApplicationId appId) {
        this.dispatcher.getEventHandler().handle((Event)new NMTimelineEvent(NMTimelineEventType.STOP_TIMELINE_CLIENT, appId));
    }

    private void removeAndStopTimelineClient(ApplicationId appId) {
        TimelineV2Client client = this.appToClientMap.remove(appId);
        if (client != null) {
            client.stop();
        }
    }

    public void setTimelineServiceAddress(ApplicationId appId, String collectorAddr) {
        TimelineV2Client client = this.appToClientMap.get(appId);
        if (client != null) {
            client.setTimelineCollectorInfo(CollectorInfo.newInstance((String)collectorAddr));
        }
    }

    private TimelineV2Client getTimelineClient(ApplicationId appId) {
        return this.appToClientMap.get(appId);
    }

    private static class TimelinePublishEvent
    extends NMTimelineEvent {
        private TimelineEntity entityToPublish;

        public TimelinePublishEvent(TimelineEntity entity, ApplicationId appId) {
            super(NMTimelineEventType.TIMELINE_ENTITY_PUBLISH, appId);
            this.entityToPublish = entity;
        }

        public TimelineEntity getTimelineEntityToPublish() {
            return this.entityToPublish;
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<NMTimelineEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(NMTimelineEvent event) {
            NMTimelinePublisher.this.handleNMTimelineEvent(event);
        }
    }
}

