/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class FpgaResourceHandlerImpl
implements ResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FpgaResourceHandlerImpl.class);
    private final String REQUEST_FPGA_IP_ID_KEY = "REQUESTED_FPGA_IP_ID";
    private final AbstractFpgaVendorPlugin vendorPlugin;
    private final FpgaResourceAllocator allocator;
    private final CGroupsHandler cGroupsHandler;
    private final FpgaDiscoverer fpgaDiscoverer;
    public static final String EXCLUDED_FPGAS_CLI_OPTION = "--excluded_fpgas";
    public static final String CONTAINER_ID_CLI_OPTION = "--container_id";
    private PrivilegedOperationExecutor privilegedOperationExecutor;

    @VisibleForTesting
    public FpgaResourceHandlerImpl(Context nmContext, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor, AbstractFpgaVendorPlugin plugin, FpgaDiscoverer fpgaDiscoverer) {
        this.allocator = new FpgaResourceAllocator(nmContext);
        this.vendorPlugin = plugin;
        this.fpgaDiscoverer = fpgaDiscoverer;
        this.cGroupsHandler = cGroupsHandler;
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @VisibleForTesting
    FpgaResourceAllocator getFpgaAllocator() {
        return this.allocator;
    }

    public String getRequestedIPID(Container container) {
        return (String)container.getLaunchContext().getEnvironment().get("REQUESTED_FPGA_IP_ID");
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        if (!this.vendorPlugin.initPlugin(configuration)) {
            throw new ResourceHandlerException("FPGA plugin initialization failed");
        }
        LOG.info("FPGA Plugin bootstrap success.");
        List<FpgaDevice> fpgaDeviceList = this.fpgaDiscoverer.discover();
        this.allocator.addFpgaDevices(this.vendorPlugin.getFpgaType(), fpgaDeviceList);
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.DEVICES);
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        String containerIdStr = container.getContainerId().toString();
        Resource requestedResource = container.getResource();
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
        long deviceCount = requestedResource.getResourceValue("yarn.io/fpga");
        LOG.info(containerIdStr + " requested " + deviceCount + " Intel FPGA(s)");
        String ipFilePath = null;
        try {
            String requestedIPID = this.getRequestedIPID(container);
            String localizedIPIDHash = null;
            ipFilePath = this.vendorPlugin.retrieveIPfilePath(requestedIPID, container.getWorkDir(), container.getResourceSet().getLocalizedResources());
            if (ipFilePath != null) {
                try (FileInputStream fis = new FileInputStream(ipFilePath);){
                    localizedIPIDHash = DigestUtils.sha256Hex((InputStream)fis);
                }
                catch (IOException e) {
                    throw new ResourceHandlerException("Could not calculate SHA-256", e);
                }
            }
            FpgaResourceAllocator.FpgaAllocation allocation = this.allocator.assignFpga(this.vendorPlugin.getFpgaType(), deviceCount, container, localizedIPIDHash);
            LOG.info("FpgaAllocation:" + allocation);
            PrivilegedOperation privilegedOperation = new PrivilegedOperation(PrivilegedOperation.OperationType.FPGA, Arrays.asList(CONTAINER_ID_CLI_OPTION, containerIdStr));
            if (!allocation.getDenied().isEmpty()) {
                ArrayList denied = new ArrayList();
                allocation.getDenied().forEach(device -> denied.add(device.getMinor()));
                privilegedOperation.appendArgs(Arrays.asList(EXCLUDED_FPGAS_CLI_OPTION, StringUtils.join((CharSequence)",", denied)));
            }
            this.privilegedOperationExecutor.executePrivilegedOperation(privilegedOperation, true);
            if (deviceCount > 0L) {
                ipFilePath = this.vendorPlugin.retrieveIPfilePath(this.getRequestedIPID(container), container.getWorkDir(), container.getResourceSet().getLocalizedResources());
                if (ipFilePath == null) {
                    LOG.warn("FPGA plugin failed to downloaded IP, please check the value of environment viable: REQUESTED_FPGA_IP_ID if you want YARN to program the device");
                } else {
                    LOG.info("IP file path:" + ipFilePath);
                    List<FpgaDevice> allowed = allocation.getAllowed();
                    for (int i = 0; i < allowed.size(); ++i) {
                        FpgaDevice device2 = allowed.get(i);
                        String majorMinorNumber = device2.getMajor() + ":" + device2.getMinor();
                        String currentHash = allowed.get(i).getAocxHash();
                        if (currentHash != null && currentHash.equalsIgnoreCase(localizedIPIDHash)) {
                            LOG.info("IP already in device \"" + allowed.get(i).getAliasDevName() + "," + majorMinorNumber + "\", skip reprogramming");
                            continue;
                        }
                        if (!this.vendorPlugin.configureIP(ipFilePath, device2)) continue;
                        this.allocator.updateFpga(containerIdStr, allowed.get(i), requestedIPID, localizedIPIDHash);
                    }
                }
            }
        }
        catch (ResourceHandlerException re) {
            this.allocator.cleanupAssignFpgas(containerIdStr);
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
            throw re;
        }
        catch (PrivilegedOperationException e) {
            this.allocator.cleanupAssignFpgas(containerIdStr);
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
            LOG.warn("Could not update cgroup for container", (Throwable)((Object)e));
            throw new ResourceHandlerException((Throwable)((Object)e));
        }
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.DEVICES, containerIdStr)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        this.allocator.recoverAssignedFpgas(containerId);
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.allocator.cleanupAssignFpgas(containerId.toString());
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return FpgaResourceHandlerImpl.class.getName() + "{vendorPlugin=" + this.vendorPlugin + ", allocator=" + this.allocator + '}';
    }
}

