/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

@Metrics(about="Metrics for AMRMProxy", context="fedr")
public final class AMRMProxyMetrics {
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"AMRMProxyMetrics", (String)"Metrics for the AMRMProxy");
    @Metric(value={"# of failed applications start requests"})
    private MutableGaugeLong failedAppStartRequests;
    @Metric(value={"# of failed register AM requests"})
    private MutableGaugeLong failedRegisterAMRequests;
    @Metric(value={"# of failed finish AM requests"})
    private MutableGaugeLong failedFinishAMRequests;
    @Metric(value={"# of failed allocate requests "})
    private MutableGaugeLong failedAllocateRequests;
    @Metric(value={"# of failed application recoveries"})
    private MutableGaugeLong failedAppRecoveryCount;
    @Metric(value={"Application start request latency(ms)"})
    private MutableRate totalSucceededAppStartRequests;
    @Metric(value={"Register application master latency(ms)"})
    private MutableRate totalSucceededRegisterAMRequests;
    @Metric(value={"Finish application master latency(ms)"})
    private MutableRate totalSucceededFinishAMRequests;
    @Metric(value={"Allocate latency(ms)"})
    private MutableRate totalSucceededAllocateRequests;
    private MutableQuantiles applicationStartLatency;
    private MutableQuantiles registerAMLatency;
    private MutableQuantiles finishAMLatency;
    private MutableQuantiles allocateLatency;
    private static volatile AMRMProxyMetrics instance = null;
    private MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);

    private AMRMProxyMetrics() {
        this.registry.tag(RECORD_INFO, "AMRMProxy");
        this.applicationStartLatency = this.registry.newQuantiles("applicationStartLatency", "latency of app start", "ops", "latency", 10);
        this.registerAMLatency = this.registry.newQuantiles("registerAMLatency", "latency of register AM", "ops", "latency", 10);
        this.finishAMLatency = this.registry.newQuantiles("finishAMLatency", "latency of finish AM", "ops", "latency", 10);
        this.allocateLatency = this.registry.newQuantiles("allocateLatency", "latency of allocate", "ops", "latency", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMRMProxyMetrics getMetrics() {
        Class<AMRMProxyMetrics> clazz = AMRMProxyMetrics.class;
        synchronized (AMRMProxyMetrics.class) {
            if (instance == null) {
                instance = (AMRMProxyMetrics)DefaultMetricsSystem.instance().register("AMRMProxyMetrics", "Metrics for the Yarn AMRMProxy", (Object)new AMRMProxyMetrics());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    long getNumSucceededAppStartRequests() {
        return this.totalSucceededAppStartRequests.lastStat().numSamples();
    }

    @VisibleForTesting
    double getLatencySucceededAppStartRequests() {
        return this.totalSucceededAppStartRequests.lastStat().mean();
    }

    public void succeededAppStartRequests(long duration) {
        this.totalSucceededAppStartRequests.add(duration);
        this.applicationStartLatency.add(duration);
    }

    @VisibleForTesting
    long getNumSucceededRegisterAMRequests() {
        return this.totalSucceededRegisterAMRequests.lastStat().numSamples();
    }

    @VisibleForTesting
    double getLatencySucceededRegisterAMRequests() {
        return this.totalSucceededRegisterAMRequests.lastStat().mean();
    }

    public void succeededRegisterAMRequests(long duration) {
        this.totalSucceededRegisterAMRequests.add(duration);
        this.registerAMLatency.add(duration);
    }

    @VisibleForTesting
    long getNumSucceededFinishAMRequests() {
        return this.totalSucceededFinishAMRequests.lastStat().numSamples();
    }

    @VisibleForTesting
    double getLatencySucceededFinishAMRequests() {
        return this.totalSucceededFinishAMRequests.lastStat().mean();
    }

    public void succeededFinishAMRequests(long duration) {
        this.totalSucceededFinishAMRequests.add(duration);
        this.finishAMLatency.add(duration);
    }

    @VisibleForTesting
    long getNumSucceededAllocateRequests() {
        return this.totalSucceededAllocateRequests.lastStat().numSamples();
    }

    @VisibleForTesting
    double getLatencySucceededAllocateRequests() {
        return this.totalSucceededAllocateRequests.lastStat().mean();
    }

    public void succeededAllocateRequests(long duration) {
        this.totalSucceededAllocateRequests.add(duration);
        this.allocateLatency.add(duration);
    }

    long getFailedAppStartRequests() {
        return this.failedAppStartRequests.value();
    }

    public void incrFailedAppStartRequests() {
        this.failedAppStartRequests.incr();
    }

    long getFailedRegisterAMRequests() {
        return this.failedRegisterAMRequests.value();
    }

    public void incrFailedRegisterAMRequests() {
        this.failedRegisterAMRequests.incr();
    }

    long getFailedFinishAMRequests() {
        return this.failedFinishAMRequests.value();
    }

    public void incrFailedFinishAMRequests() {
        this.failedFinishAMRequests.incr();
    }

    long getFailedAllocateRequests() {
        return this.failedAllocateRequests.value();
    }

    public void incrFailedAllocateRequests() {
        this.failedAllocateRequests.incr();
    }

    long getFailedAppRecoveryCount() {
        return this.failedAppRecoveryCount.value();
    }

    public void incrFailedAppRecoveryCount() {
        this.failedAppRecoveryCount.incr();
    }
}

