/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.matchers.text;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.text.FormattedText;

public class ValuePrinter {
    private ValuePrinter() {
    }

    public static String print(final Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return '\"' + value.toString() + '\"';
        }
        if (value instanceof Character) {
            return ValuePrinter.printChar(((Character)value).charValue());
        }
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Double) {
            return value + "d";
        }
        if (value instanceof Float) {
            return value + "f";
        }
        if (value instanceof Short) {
            return "(short) " + value;
        }
        if (value instanceof Byte) {
            return String.format("(byte) 0x%02X", (Byte)value);
        }
        if (value instanceof Map) {
            return ValuePrinter.printMap((Map)value);
        }
        if (value.getClass().isArray()) {
            return ValuePrinter.printValues("[", ", ", "]", new Iterator<Object>(){
                private int currentIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentIndex < Array.getLength(value);
                }

                @Override
                public Object next() {
                    return Array.get(value, this.currentIndex++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove items from an array");
                }
            });
        }
        if (value instanceof FormattedText) {
            return ((FormattedText)value).getText();
        }
        return ValuePrinter.descriptionOf(value);
    }

    private static String printMap(Map<?, ?> map) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            result.append(ValuePrinter.print(entry.getKey())).append(" = ").append(ValuePrinter.print(entry.getValue()));
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return "{" + result.toString() + "}";
    }

    public static String printValues(String start, String separator, String end, Iterator<?> values) {
        if (start == null) {
            start = "(";
        }
        if (separator == null) {
            separator = ",";
        }
        if (end == null) {
            end = ")";
        }
        StringBuilder sb = new StringBuilder(start);
        while (values.hasNext()) {
            sb.append(ValuePrinter.print(values.next()));
            if (!values.hasNext()) continue;
            sb.append(separator);
        }
        return sb.append(end).toString();
    }

    private static String printChar(char value) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        switch (value) {
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                sb.append(value);
            }
        }
        sb.append('\'');
        return sb.toString();
    }

    private static String descriptionOf(Object value) {
        try {
            return String.valueOf(value);
        }
        catch (Exception e) {
            return value.getClass().getName() + "@" + Integer.toHexString(value.hashCode());
        }
    }
}

