/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

public class MockDomainNameResolver
implements DomainNameResolver {
    public static final String DOMAIN = "test.foo.bar";
    public static final String UNKNOW_DOMAIN = "unknown.foo.bar";
    public static final byte[] BYTE_ADDR_1 = new byte[]{10, 1, 1, 1};
    public static final byte[] BYTE_ADDR_2 = new byte[]{10, 1, 1, 2};
    public static final String ADDR_1 = "10.1.1.1";
    public static final String ADDR_2 = "10.1.1.2";
    public static final String FQDN_1 = "host01.test";
    public static final String FQDN_2 = "host02.test";
    private Map<String, InetAddress[]> addrs = new TreeMap<String, InetAddress[]>();
    private Map<InetAddress, String> ptrMap = new HashMap<InetAddress, String>();

    public MockDomainNameResolver() {
        try {
            InetAddress nn1Address = InetAddress.getByAddress(BYTE_ADDR_1);
            InetAddress nn2Address = InetAddress.getByAddress(BYTE_ADDR_2);
            this.addrs.put(DOMAIN, new InetAddress[]{nn1Address, nn2Address});
            this.ptrMap.put(nn1Address, FQDN_1);
            this.ptrMap.put(nn2Address, FQDN_2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public InetAddress[] getAllByDomainName(String domainName) throws UnknownHostException {
        if (!this.addrs.containsKey(domainName)) {
            throw new UnknownHostException(domainName + " is not resolvable");
        }
        return this.addrs.get(domainName);
    }

    public String getHostnameByIP(InetAddress address) {
        return this.ptrMap.containsKey(address) ? this.ptrMap.get(address) : null;
    }

    public String[] getAllResolvedHostnameByDomainName(String domainName, boolean useFQDN) throws UnknownHostException {
        InetAddress[] addresses = this.getAllByDomainName(domainName);
        String[] hosts = new String[addresses.length];
        if (useFQDN) {
            for (int i = 0; i < hosts.length; ++i) {
                hosts[i] = this.ptrMap.get(addresses[i]);
            }
        } else {
            for (int i = 0; i < hosts.length; ++i) {
                hosts[i] = addresses[i].getHostAddress();
            }
        }
        return hosts;
    }

    @VisibleForTesting
    public void setAddressMap(Map<String, InetAddress[]> addresses) {
        this.addrs = addresses;
    }
}

