/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowingSleepJob
extends SleepJob {
    private static final Logger LOG = LoggerFactory.getLogger(GrowingSleepJob.class);

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new GrowingSleepJob(), (String[])args);
        System.exit(res);
    }

    @Override
    public Job createJob(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) throws IOException {
        Job job = super.createJob(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
        job.setMapperClass(GrowingSleepMapper.class);
        job.setJobName("Growing sleep job");
        return job;
    }

    public static class GrowingSleepMapper
    extends SleepJob.SleepMapper {
        private final int MB = 0x100000;
        private ArrayList<byte[]> bytes = new ArrayList();

        @Override
        public void map(IntWritable key, IntWritable value, Mapper.Context context) throws IOException, InterruptedException {
            super.map(key, value, context);
            long free = Runtime.getRuntime().freeMemory();
            if (free > 0x2000000L) {
                LOG.info("Free memory = " + free + " bytes. Creating 1 MB on the heap.");
                this.bytes.add(new byte[0x100000]);
            }
        }
    }
}

