/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.IgnoreSnapshotException;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruption;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageTextWriter;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBImageCorruptionDetector
extends PBImageTextWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PBImageCorruptionDetector.class);
    private final CorruptionChecker corrChecker = new CorruptionChecker();
    private final Map<Long, PBImageCorruption> corruptionsMap = new TreeMap<Long, PBImageCorruption>();

    PBImageCorruptionDetector(PrintStream out, String delimiter, String tempPath) throws IOException {
        super(out, delimiter, tempPath);
    }

    @Override
    public String getHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CorruptionType");
        this.append(buffer, "Id");
        this.append(buffer, "IsSnapshot");
        this.append(buffer, "ParentPath");
        this.append(buffer, "ParentId");
        this.append(buffer, "Name");
        this.append(buffer, "NodeType");
        this.append(buffer, "CorruptChildren");
        return buffer.toString();
    }

    @Override
    public String getEntry(String parentPath, FsImageProto.INodeSection.INode inode) {
        long id = inode.getId();
        if (this.corruptionsMap.containsKey(id)) {
            OutputEntryBuilder entryBuilder = new OutputEntryBuilder(this, false);
            long parentId = -1L;
            try {
                parentId = this.getParentId(id);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            entryBuilder.setCorruption(this.corruptionsMap.get(id)).setParentPath(parentPath).setName(inode.getName().toStringUtf8()).setNodeType(this.corrChecker.getTypeOfId(id));
            if (parentId != -1L) {
                entryBuilder.setParentId(parentId);
            }
            this.corruptionsMap.remove(id);
            return entryBuilder.build();
        }
        return "";
    }

    @Override
    protected void checkNode(FsImageProto.INodeSection.INode p, AtomicInteger numDirs) throws IOException {
        super.checkNode(p, numDirs);
        this.corrChecker.saveNodeId(p.getId());
    }

    private void addCorruptedNode(long childId) {
        if (!this.corruptionsMap.containsKey(childId)) {
            PBImageCorruption c = new PBImageCorruption(childId, false, true, 0);
            this.corruptionsMap.put(childId, c);
        } else {
            PBImageCorruption c = this.corruptionsMap.get(childId);
            c.addCorruptNodeCorruption();
            this.corruptionsMap.put(childId, c);
        }
    }

    private void addCorruptedParent(long id, int numOfCorruption) {
        if (!this.corruptionsMap.containsKey(id)) {
            PBImageCorruption c = new PBImageCorruption(id, true, false, numOfCorruption);
            this.corruptionsMap.put(id, c);
        } else {
            PBImageCorruption c = this.corruptionsMap.get(id);
            c.addMissingChildCorruption();
            c.setNumberOfCorruption(numOfCorruption);
            this.corruptionsMap.put(id, c);
        }
    }

    @Override
    protected void buildNamespace(InputStream in, List<Long> refIdList) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        this.corrChecker.saveNodeRefIds(refIdList);
        LOG.debug("Saved INodeReference ids of size {}.", (Object)refIdList.size());
        int count = 0;
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            int i;
            long parentId;
            if (LOG.isDebugEnabled() && ++count % 10000 == 0) {
                LOG.debug("Scanned {} directories.", (Object)count);
            }
            if (!this.corrChecker.isNodeIdExist(parentId = e.getParent())) {
                LOG.debug("Corruption detected! Parent node is not contained in the list of known ids!");
                this.addCorruptedNode(parentId);
            }
            int numOfCorruption = 0;
            for (i = 0; i < e.getChildrenCount(); ++i) {
                long childId = e.getChildren(i);
                this.putDirChildToMetadataMap(parentId, childId);
                if (this.corrChecker.isNodeIdExist(childId)) continue;
                this.addCorruptedNode(childId);
                ++numOfCorruption;
            }
            if (numOfCorruption > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} corruption detected! Child nodes are missing.", (Object)numOfCorruption);
                }
                this.addCorruptedParent(parentId, numOfCorruption);
            }
            for (i = e.getChildrenCount(); i < e.getChildrenCount() + e.getRefChildrenCount(); ++i) {
                int refId = e.getRefChildren(i - e.getChildrenCount());
                this.putDirChildToMetadataMap(parentId, refIdList.get(refId));
            }
        }
        LOG.info("Scanned {} INode directories to build namespace.", (Object)count);
    }

    @Override
    public void afterOutput() throws IOException {
        if (!this.corruptionsMap.isEmpty()) {
            LOG.info("Outputting {} more corrupted nodes.", (Object)this.corruptionsMap.size());
            for (PBImageCorruption c : this.corruptionsMap.values()) {
                long id = c.getId();
                String name = "";
                long parentId = -1L;
                try {
                    name = this.getNodeName(id);
                }
                catch (IgnoreSnapshotException ignoreSnapshotException) {
                    // empty catch block
                }
                try {
                    parentId = this.getParentId(id);
                }
                catch (IgnoreSnapshotException ignoreSnapshotException) {
                    // empty catch block
                }
                OutputEntryBuilder entryBuilder = new OutputEntryBuilder(this, true);
                entryBuilder.setCorruption(this.corruptionsMap.get(id)).setName(name).setNodeType(this.corrChecker.getTypeOfId(id));
                if (parentId != -1L) {
                    entryBuilder.setParentId(parentId);
                }
                this.printIfNotEmpty(entryBuilder.build());
            }
        }
    }

    private static class CorruptionChecker {
        private static final String NODE_TYPE = "Node";
        private static final String REF_TYPE = "Ref";
        private static final String UNKNOWN_TYPE = "Unknown";
        private Set<Long> nodeIds = new HashSet<Long>();
        private Set<Long> nodeRefIds;

        CorruptionChecker() {
        }

        void saveNodeId(long id) {
            Preconditions.checkState((this.nodeIds != null && !this.nodeIds.contains(id) ? 1 : 0) != 0);
            this.nodeIds.add(id);
        }

        boolean isNodeIdExist(long id) {
            return this.nodeIds.contains(id);
        }

        boolean isNodeRefIdExist(long id) {
            return this.nodeRefIds.contains(id);
        }

        void saveNodeRefIds(List<Long> nodeRefIdList) {
            this.nodeRefIds = new HashSet<Long>(nodeRefIdList);
        }

        String getTypeOfId(long id) {
            if (this.isNodeIdExist(id)) {
                return NODE_TYPE;
            }
            if (this.isNodeRefIdExist(id)) {
                return REF_TYPE;
            }
            return UNKNOWN_TYPE;
        }
    }

    static class OutputEntryBuilder {
        private static final String MISSING = "Missing";
        private PBImageCorruptionDetector corrDetector;
        private PBImageCorruption corruption;
        private boolean isSnapshot;
        private String parentPath;
        private long parentId;
        private String name;
        private String nodeType;

        OutputEntryBuilder(PBImageCorruptionDetector corrDetector, boolean isSnapshot) {
            this.corrDetector = corrDetector;
            this.isSnapshot = isSnapshot;
            this.parentId = -1L;
            this.parentPath = "";
            this.name = "";
            this.nodeType = "";
        }

        OutputEntryBuilder setCorruption(PBImageCorruption corr) {
            this.corruption = corr;
            return this;
        }

        OutputEntryBuilder setParentPath(String path) {
            this.parentPath = path;
            return this;
        }

        OutputEntryBuilder setParentId(long id) {
            this.parentId = id;
            return this;
        }

        OutputEntryBuilder setName(String n) {
            this.name = n;
            return this;
        }

        OutputEntryBuilder setNodeType(String nType) {
            this.nodeType = nType;
            return this;
        }

        public String build() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.corruption.getType());
            this.corrDetector.append(buffer, this.corruption.getId());
            this.corrDetector.append(buffer, String.valueOf(this.isSnapshot));
            this.corrDetector.append(buffer, this.parentPath);
            if (this.parentId == -1L) {
                this.corrDetector.append(buffer, MISSING);
            } else {
                this.corrDetector.append(buffer, this.parentId);
            }
            this.corrDetector.append(buffer, this.name);
            this.corrDetector.append(buffer, this.nodeType);
            this.corrDetector.append(buffer, this.corruption.getNumOfCorruptChildren());
            return buffer.toString();
        }
    }
}

