/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.namenode.EncryptionFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ReencryptionUpdater;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.util.Time;

final class FSDirEncryptionZoneOp {
    private FSDirEncryptionZoneOp() {
    }

    private static KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedDataEncryptionKey(final FSDirectory fsd, final String ezKeyName) throws IOException {
        assert (!fsd.getFSNamesystem().hasReadLock());
        assert (!fsd.getFSNamesystem().hasWriteLock());
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return fsd.getProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        NameNode.getNameNodeMetrics().addGenerateEDEKTime(generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    static KeyProvider.Metadata ensureKeyIsInitialized(FSDirectory fsd, String keyName, String src) throws IOException {
        KeyProviderCryptoExtension provider = fsd.getProvider();
        if (provider == null) {
            throw new IOException("Can't create an encryption zone for " + src + " since no key provider is available.");
        }
        if (keyName == null || keyName.isEmpty()) {
            throw new IOException("Must specify a key name when creating an encryption zone");
        }
        EncryptionFaultInjector.getInstance().ensureKeyIsInitialized();
        KeyProvider.Metadata metadata = provider.getMetadata(keyName);
        if (metadata == null) {
            throw new IOException("Key " + keyName + " doesn't exist.");
        }
        provider.warmUpEncryptedKeys(new String[]{keyName});
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus createEncryptionZone(FSDirectory fsd, String srcArg, FSPermissionChecker pc, String cipher, String keyName, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        CipherSuite suite = CipherSuite.convert((String)cipher);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        CryptoProtocolVersion version = CryptoProtocolVersion.ENCRYPTION_ZONES;
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.WRITE);
            XAttr ezXAttr = fsd.ezManager.createEncryptionZone(iip, suite, version, keyName);
            xAttrs.add(ezXAttr);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetXAttrs(iip.getPath(), xAttrs, logRetryCache);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map.Entry<EncryptionZone, FileStatus> getEZForPath(FSDirectory fsd, String srcArg, FSPermissionChecker pc) throws IOException {
        EncryptionZone ret;
        INodesInPath iip;
        fsd.readLock();
        try {
            iip = fsd.resolvePath(pc, srcArg, FSDirectory.DirOp.READ);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.READ);
            }
            ret = fsd.ezManager.getEZINodeForPath(iip);
        }
        finally {
            fsd.readUnlock();
        }
        FileStatus auditStat = fsd.getAuditFileInfo(iip);
        return new AbstractMap.SimpleImmutableEntry<EncryptionZone, FileStatus>(ret, auditStat);
    }

    static EncryptionZone getEZForPath(FSDirectory fsd, INodesInPath iip) throws IOException {
        fsd.readLock();
        try {
            EncryptionZone encryptionZone = fsd.ezManager.getEZINodeForPath(iip);
            return encryptionZone;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(FSDirectory fsd, long prevId) throws IOException {
        fsd.readLock();
        try {
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = fsd.ezManager.listEncryptionZones(prevId);
            return batchedListEntries;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static List<XAttr> reencryptEncryptionZone(FSDirectory fsd, INodesInPath iip, String keyVersionName) throws IOException {
        assert (keyVersionName != null);
        return fsd.ezManager.reencryptEncryptionZone(iip, keyVersionName);
    }

    static List<XAttr> cancelReencryptEncryptionZone(FSDirectory fsd, INodesInPath iip) throws IOException {
        return fsd.ezManager.cancelReencryptEncryptionZone(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> listReencryptionStatus(FSDirectory fsd, long prevId) throws IOException {
        fsd.readLock();
        try {
            BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> batchedListEntries = fsd.ezManager.listReencryptionStatus(prevId);
            return batchedListEntries;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static XAttr updateReencryptionSubmitted(FSDirectory fsd, INodesInPath iip, String ezKeyVersionName) throws IOException {
        assert (fsd.hasWriteLock());
        Preconditions.checkNotNull((Object)ezKeyVersionName, (Object)"ezKeyVersionName is null.");
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = FSDirEncryptionZoneOp.getZoneEncryptionInfoProto(iip);
        Preconditions.checkNotNull((Object)zoneProto, (Object)"ZoneEncryptionInfoProto is null.");
        HdfsProtos.ReencryptionInfoProto newProto = PBHelperClient.convert((String)ezKeyVersionName, (Long)Time.now(), (boolean)false, (long)0L, (long)0L, null, null);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelperClient.convert((CipherSuite)PBHelperClient.convert((HdfsProtos.CipherSuiteProto)zoneProto.getSuite()), (CryptoProtocolVersion)PBHelperClient.convert((HdfsProtos.CryptoProtocolVersionProto)zoneProto.getCryptoProtocolVersion()), (String)zoneProto.getKeyName(), (HdfsProtos.ReencryptionInfoProto)newProto);
        XAttr xattr = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.encryption.zone", (byte[])newZoneProto.toByteArray());
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, iip, xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattr;
    }

    static XAttr updateReencryptionProgress(FSDirectory fsd, INode zoneNode, ZoneReencryptionStatus origStatus, String lastFile, long numReencrypted, long numFailures) throws IOException {
        assert (fsd.hasWriteLock());
        Preconditions.checkNotNull((Object)zoneNode, (Object)"Zone node is null");
        INodesInPath iip = INodesInPath.fromINode(zoneNode);
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = FSDirEncryptionZoneOp.getZoneEncryptionInfoProto(iip);
        Preconditions.checkNotNull((Object)zoneProto, (Object)"ZoneEncryptionInfoProto is null.");
        Preconditions.checkNotNull((Object)origStatus, (Object)("Null status for " + iip.getPath()));
        HdfsProtos.ReencryptionInfoProto newProto = PBHelperClient.convert((String)origStatus.getEzKeyVersionName(), (Long)origStatus.getSubmissionTime(), (boolean)false, (long)(origStatus.getFilesReencrypted() + numReencrypted), (long)(origStatus.getNumReencryptionFailures() + numFailures), null, (String)lastFile);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelperClient.convert((CipherSuite)PBHelperClient.convert((HdfsProtos.CipherSuiteProto)zoneProto.getSuite()), (CryptoProtocolVersion)PBHelperClient.convert((HdfsProtos.CryptoProtocolVersionProto)zoneProto.getCryptoProtocolVersion()), (String)zoneProto.getKeyName(), (HdfsProtos.ReencryptionInfoProto)newProto);
        XAttr xattr = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.encryption.zone", (byte[])newZoneProto.toByteArray());
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, iip, xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattr;
    }

    static List<XAttr> updateReencryptionFinish(FSDirectory fsd, INodesInPath zoneIIP, ZoneReencryptionStatus origStatus) throws IOException {
        assert (origStatus != null);
        assert (fsd.hasWriteLock());
        fsd.ezManager.getReencryptionStatus().markZoneCompleted(Long.valueOf(zoneIIP.getLastINode().getId()));
        XAttr xattr = FSDirEncryptionZoneOp.generateNewXAttrForReencryptionFinish(zoneIIP, origStatus);
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, zoneIIP, xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattrs;
    }

    static XAttr generateNewXAttrForReencryptionFinish(INodesInPath iip, ZoneReencryptionStatus status) throws IOException {
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = FSDirEncryptionZoneOp.getZoneEncryptionInfoProto(iip);
        HdfsProtos.ReencryptionInfoProto newRiProto = PBHelperClient.convert((String)status.getEzKeyVersionName(), (Long)status.getSubmissionTime(), (boolean)status.isCanceled(), (long)status.getFilesReencrypted(), (long)status.getNumReencryptionFailures(), (Long)Time.now(), null);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelperClient.convert((CipherSuite)PBHelperClient.convert((HdfsProtos.CipherSuiteProto)zoneProto.getSuite()), (CryptoProtocolVersion)PBHelperClient.convert((HdfsProtos.CryptoProtocolVersionProto)zoneProto.getCryptoProtocolVersion()), (String)zoneProto.getKeyName(), (HdfsProtos.ReencryptionInfoProto)newRiProto);
        XAttr xattr = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.encryption.zone", (byte[])newZoneProto.toByteArray());
        return xattr;
    }

    private static HdfsProtos.ZoneEncryptionInfoProto getZoneEncryptionInfoProto(INodesInPath iip) throws IOException {
        XAttr fileXAttr = FSDirXAttrOp.unprotectedGetXAttrByPrefixedName(iip.getLastINode(), iip.getPathSnapshotId(), "raw.hdfs.crypto.encryption.zone");
        if (fileXAttr == null) {
            throw new IOException("Could not find reencryption XAttr for file " + iip.getPath());
        }
        try {
            return HdfsProtos.ZoneEncryptionInfoProto.parseFrom((byte[])fileXAttr.getValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Could not parse file encryption info for inode " + iip.getPath(), e);
        }
    }

    static void saveFileXAttrsForBatch(FSDirectory fsd, List<ReencryptionUpdater.FileEdekInfo> batch) {
        assert (fsd.getFSNamesystem().hasWriteLock());
        if (batch != null && !batch.isEmpty()) {
            for (ReencryptionUpdater.FileEdekInfo entry : batch) {
                INode inode = fsd.getInode(entry.getInodeId());
                if (inode == null) {
                    NameNode.LOG.info("Cannot find inode {}, skip saving xattr for re-encryption", (Object)entry.getInodeId());
                    continue;
                }
                fsd.getEditLog().logSetXAttrs(inode.getFullPathName(), inode.getXAttrFeature().getXAttrs(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setFileEncryptionInfo(FSDirectory fsd, INodesInPath iip, FileEncryptionInfo info, XAttrSetFlag flag) throws IOException {
        HdfsProtos.PerFileEncryptionInfoProto proto = PBHelperClient.convertPerFileEncInfo((FileEncryptionInfo)info);
        byte[] protoBytes = proto.toByteArray();
        XAttr fileEncryptionAttr = XAttrHelper.buildXAttr((String)"raw.hdfs.crypto.file.encryption.info", (byte[])protoBytes);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(fileEncryptionAttr);
        fsd.writeLock();
        try {
            FSDirXAttrOp.unprotectedSetXAttrs(fsd, iip, xAttrs, EnumSet.of(flag));
        }
        finally {
            fsd.writeUnlock();
        }
    }

    static FileEncryptionInfo getFileEncryptionInfo(FSDirectory fsd, INodesInPath iip) throws IOException {
        if (iip.isRaw() || !fsd.ezManager.hasCreatedEncryptionZone() || !iip.getLastINode().isFile()) {
            return null;
        }
        fsd.readLock();
        try {
            XAttr fileXAttr;
            EncryptionZone encryptionZone = FSDirEncryptionZoneOp.getEZForPath(fsd, iip);
            if (encryptionZone == null) {
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            if ((encryptionZone.getPath() == null || encryptionZone.getPath().isEmpty()) && NameNode.LOG.isDebugEnabled()) {
                NameNode.LOG.debug("Encryption zone " + encryptionZone.getPath() + " does not have a valid path.");
            }
            if ((fileXAttr = FSDirXAttrOp.unprotectedGetXAttrByPrefixedName(iip.getLastINode(), iip.getPathSnapshotId(), "raw.hdfs.crypto.file.encryption.info")) == null) {
                NameNode.LOG.warn("Could not find encryption XAttr for file " + iip.getPath() + " in encryption zone " + encryptionZone.getPath());
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            CryptoProtocolVersion version = encryptionZone.getVersion();
            CipherSuite suite = encryptionZone.getSuite();
            String keyName = encryptionZone.getKeyName();
            try {
                HdfsProtos.PerFileEncryptionInfoProto fileProto = HdfsProtos.PerFileEncryptionInfoProto.parseFrom((byte[])fileXAttr.getValue());
                FileEncryptionInfo fileEncryptionInfo = PBHelperClient.convert((HdfsProtos.PerFileEncryptionInfoProto)fileProto, (CipherSuite)suite, (CryptoProtocolVersion)version, (String)keyName);
                return fileEncryptionInfo;
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException("Could not parse file encryption info for inode " + iip.getPath(), e);
            }
        }
        finally {
            fsd.readUnlock();
        }
    }

    static FileEncryptionInfo getFileEncryptionInfo(FSDirectory dir, INodesInPath iip, EncryptionKeyInfo ezInfo) throws RetryStartFileException, IOException {
        FileEncryptionInfo feInfo = null;
        EncryptionZone zone = FSDirEncryptionZoneOp.getEZForPath(dir, iip);
        if (zone != null) {
            if (ezInfo == null) {
                throw new RetryStartFileException();
            }
            String ezKeyName = zone.getKeyName();
            if (!ezKeyName.equals(ezInfo.edek.getEncryptionKeyName())) {
                throw new RetryStartFileException();
            }
            feInfo = new FileEncryptionInfo(ezInfo.suite, ezInfo.protocolVersion, ezInfo.edek.getEncryptedKeyVersion().getMaterial(), ezInfo.edek.getEncryptedKeyIv(), ezKeyName, ezInfo.edek.getEncryptionKeyVersionName());
        }
        return feInfo;
    }

    static boolean isInAnEZ(FSDirectory fsd, INodesInPath iip) throws UnresolvedLinkException, SnapshotAccessControlException, IOException {
        if (!fsd.ezManager.hasCreatedEncryptionZone()) {
            return false;
        }
        fsd.readLock();
        try {
            boolean bl = fsd.ezManager.isInAnEZ(iip);
            return bl;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void warmUpEdekCache(ExecutorService executor, FSDirectory fsd, int delay, int interval) {
        fsd.readLock();
        try {
            String[] edeks = fsd.ezManager.getKeyNames();
            executor.execute(new EDEKCacheLoader(edeks, fsd.getProvider(), delay, interval));
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EncryptionKeyInfo getEncryptionKeyInfo(FSNamesystem fsn, INodesInPath iip, CryptoProtocolVersion[] supportedVersions) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        EncryptionZone zone = FSDirEncryptionZoneOp.getEZForPath(fsd, iip);
        if (zone == null) {
            EncryptionFaultInjector.getInstance().startFileNoKey();
            return null;
        }
        CryptoProtocolVersion protocolVersion = fsn.chooseProtocolVersion(zone, supportedVersions);
        CipherSuite suite = zone.getSuite();
        String ezKeyName = zone.getKeyName();
        Preconditions.checkNotNull((Object)protocolVersion);
        Preconditions.checkNotNull((Object)suite);
        Preconditions.checkArgument((!suite.equals((Object)CipherSuite.UNKNOWN) ? 1 : 0) != 0, (Object)"Chose an UNKNOWN CipherSuite!");
        Preconditions.checkNotNull((Object)ezKeyName);
        fsn.writeUnlock();
        try {
            EncryptionFaultInjector.getInstance().startFileBeforeGenerateKey();
            EncryptionKeyInfo encryptionKeyInfo = new EncryptionKeyInfo(protocolVersion, suite, ezKeyName, FSDirEncryptionZoneOp.generateEncryptedDataEncryptionKey(fsd, ezKeyName));
            return encryptionKeyInfo;
        }
        finally {
            fsn.writeLock();
            EncryptionFaultInjector.getInstance().startFileAfterGenerateKey();
        }
    }

    static String getCurrentKeyVersion(FSDirectory dir, FSPermissionChecker pc, String zone) throws IOException {
        KeyProviderCryptoExtension.EncryptedKeyVersion edek;
        assert (dir.getProvider() != null);
        assert (!dir.hasReadLock());
        String keyName = FSDirEncryptionZoneOp.getKeyNameForZone(dir, pc, zone);
        if (keyName == null) {
            throw new IOException(zone + " is not an encryption zone.");
        }
        dir.getProvider().drain(keyName);
        try {
            edek = dir.getProvider().generateEncryptedKey(keyName);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        Preconditions.checkNotNull((Object)edek);
        return edek.getEncryptionKeyVersionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getKeyNameForZone(FSDirectory dir, FSPermissionChecker pc, String zone) throws IOException {
        assert (dir.getProvider() != null);
        dir.getFSNamesystem().readLock();
        try {
            INodesInPath iip = dir.resolvePath(pc, zone, FSDirectory.DirOp.READ);
            dir.ezManager.checkEncryptionZoneRoot(iip.getLastINode(), zone);
            String string = dir.ezManager.getKeyName(iip);
            return string;
        }
        finally {
            dir.getFSNamesystem().readUnlock();
        }
    }

    static class EncryptionKeyInfo {
        final CryptoProtocolVersion protocolVersion;
        final CipherSuite suite;
        final String ezKeyName;
        final KeyProviderCryptoExtension.EncryptedKeyVersion edek;

        EncryptionKeyInfo(CryptoProtocolVersion protocolVersion, CipherSuite suite, String ezKeyName, KeyProviderCryptoExtension.EncryptedKeyVersion edek) {
            this.protocolVersion = protocolVersion;
            this.suite = suite;
            this.ezKeyName = ezKeyName;
            this.edek = edek;
        }
    }

    static class EDEKCacheLoader
    implements Runnable {
        private final String[] keyNames;
        private final KeyProviderCryptoExtension kp;
        private int initialDelay;
        private int retryInterval;

        EDEKCacheLoader(String[] names, KeyProviderCryptoExtension kp, int delay, int interval) {
            this.keyNames = names;
            this.kp = kp;
            this.initialDelay = delay;
            this.retryInterval = interval;
        }

        @Override
        public void run() {
            NameNode.LOG.info("Warming up {} EDEKs... (initialDelay={}, retryInterval={})", new Object[]{this.keyNames.length, this.initialDelay, this.retryInterval});
            try {
                Thread.sleep(this.initialDelay);
            }
            catch (InterruptedException ie) {
                NameNode.LOG.info("EDEKCacheLoader interrupted before warming up.");
                return;
            }
            int logCoolDown = 10000;
            int sinceLastLog = 10000;
            boolean success = false;
            IOException lastSeenIOE = null;
            long warmUpEDEKStartTime = Time.monotonicNow();
            while (true) {
                try {
                    this.kp.warmUpEncryptedKeys(this.keyNames);
                    NameNode.LOG.info("Successfully warmed up {} EDEKs.", (Object)this.keyNames.length);
                    success = true;
                    break;
                }
                catch (IOException ioe) {
                    lastSeenIOE = ioe;
                    if (sinceLastLog >= 10000) {
                        NameNode.LOG.info("Failed to warm up EDEKs.", (Throwable)ioe);
                        sinceLastLog = 0;
                    } else {
                        NameNode.LOG.debug("Failed to warm up EDEKs.", (Throwable)ioe);
                    }
                }
                catch (Exception e) {
                    NameNode.LOG.error("Cannot warm up EDEKs.", (Throwable)e);
                    throw e;
                }
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException ie) {
                    NameNode.LOG.info("EDEKCacheLoader interrupted during retry.");
                    break;
                }
                sinceLastLog += this.retryInterval;
            }
            long warmUpEDEKTime = Time.monotonicNow() - warmUpEDEKStartTime;
            NameNode.getNameNodeMetrics().addWarmUpEDEKTime(warmUpEDEKTime);
            if (!success) {
                NameNode.LOG.warn("Unable to warm up EDEKs.");
                if (lastSeenIOE != null) {
                    NameNode.LOG.warn("Last seen exception:", (Throwable)lastSeenIOE);
                }
            }
        }
    }
}

