/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ProvidedReplica
extends ReplicaInfo {
    public static final Logger LOG = LoggerFactory.getLogger(ProvidedReplica.class);
    static final byte[] NULL_CHECKSUM_ARRAY = FsDatasetUtil.createNullChecksumByteArray();
    private URI fileURI;
    private Path pathPrefix;
    private String pathSuffix;
    private long fileOffset;
    private Configuration conf;
    private PathHandle pathHandle;
    private FileSystem remoteFS;

    public ProvidedReplica(long blockId, URI fileURI, long fileOffset, long blockLen, long genStamp, PathHandle pathHandle, FsVolumeSpi volume, Configuration conf, FileSystem remoteFS) {
        super(volume, blockId, blockLen, genStamp);
        this.fileURI = fileURI;
        this.fileOffset = fileOffset;
        this.conf = conf;
        this.pathHandle = pathHandle;
        if (remoteFS != null) {
            this.remoteFS = remoteFS;
        } else {
            LOG.warn("Creating an reference to the remote FS for provided block " + this);
            try {
                this.remoteFS = FileSystem.get((URI)fileURI, (Configuration)this.conf);
            }
            catch (IOException e) {
                LOG.warn("Failed to obtain filesystem for " + fileURI);
                this.remoteFS = null;
            }
        }
    }

    public ProvidedReplica(long blockId, Path pathPrefix, String pathSuffix, long fileOffset, long blockLen, long genStamp, PathHandle pathHandle, FsVolumeSpi volume, Configuration conf, FileSystem remoteFS) {
        super(volume, blockId, blockLen, genStamp);
        this.fileURI = null;
        this.pathPrefix = pathPrefix;
        this.pathSuffix = pathSuffix;
        this.fileOffset = fileOffset;
        this.conf = conf;
        this.pathHandle = pathHandle;
        if (remoteFS != null) {
            this.remoteFS = remoteFS;
        } else {
            LOG.warn("Creating an reference to the remote FS for provided block " + this);
            try {
                this.remoteFS = FileSystem.get((URI)pathPrefix.toUri(), (Configuration)this.conf);
            }
            catch (IOException e) {
                LOG.warn("Failed to obtain filesystem for " + pathPrefix);
                this.remoteFS = null;
            }
        }
    }

    public ProvidedReplica(ProvidedReplica r) {
        super(r);
        this.fileURI = r.fileURI;
        this.fileOffset = r.fileOffset;
        this.conf = r.conf;
        this.remoteFS = r.remoteFS;
        this.pathHandle = r.pathHandle;
        this.pathPrefix = r.pathPrefix;
        this.pathSuffix = r.pathSuffix;
    }

    @Override
    public URI getBlockURI() {
        return this.getRemoteURI();
    }

    @VisibleForTesting
    public String getPathSuffix() {
        return this.pathSuffix;
    }

    @VisibleForTesting
    public Path getPathPrefix() {
        return this.pathPrefix;
    }

    private URI getRemoteURI() {
        if (this.fileURI != null) {
            return this.fileURI;
        }
        if (this.pathPrefix == null) {
            return new Path(this.pathSuffix).toUri();
        }
        return new Path(this.pathPrefix, this.pathSuffix).toUri();
    }

    @Override
    public InputStream getDataInputStream(long seekOffset) throws IOException {
        if (this.remoteFS != null) {
            FSDataInputStream ins;
            try {
                ins = this.pathHandle != null ? this.remoteFS.open(this.pathHandle, this.conf.getInt("io.file.buffer.size", 4096)) : this.remoteFS.open(new Path(this.getRemoteURI()));
            }
            catch (UnsupportedOperationException e) {
                throw new IOException("PathHandle specified, but unsuported", e);
            }
            ins.seek(this.fileOffset + seekOffset);
            return new BoundedInputStream((InputStream)new FSDataInputStream((InputStream)ins), this.getBlockDataLength());
        }
        throw new IOException("Remote filesystem for provided replica " + this + " does not exist");
    }

    @Override
    public OutputStream getDataOutputStream(boolean append) throws IOException {
        throw new UnsupportedOperationException("OutputDataStream is not implemented for ProvidedReplica");
    }

    @Override
    public URI getMetadataURI() {
        return null;
    }

    @Override
    public OutputStream getMetadataOutputStream(boolean append) throws IOException {
        return null;
    }

    @Override
    public boolean blockDataExists() {
        if (this.remoteFS != null) {
            try {
                return this.remoteFS.exists(new Path(this.getRemoteURI()));
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean deleteBlockData() {
        throw new UnsupportedOperationException("ProvidedReplica does not support deleting block data");
    }

    @Override
    public long getBlockDataLength() {
        return this.getNumBytes();
    }

    @Override
    public LengthInputStream getMetadataInputStream(long offset) throws IOException {
        return new LengthInputStream(new ByteArrayInputStream(NULL_CHECKSUM_ARRAY), NULL_CHECKSUM_ARRAY.length);
    }

    @Override
    public boolean metadataExists() {
        return NULL_CHECKSUM_ARRAY != null;
    }

    @Override
    public boolean deleteMetadata() {
        throw new UnsupportedOperationException("ProvidedReplica does not support deleting metadata");
    }

    @Override
    public long getMetadataLength() {
        return NULL_CHECKSUM_ARRAY == null ? 0L : (long)NULL_CHECKSUM_ARRAY.length;
    }

    @Override
    public boolean renameMeta(URI destURI) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not support renaming metadata");
    }

    @Override
    public boolean renameData(URI destURI) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not support renaming data");
    }

    @Override
    public boolean getPinning(LocalFileSystem localFS) throws IOException {
        return false;
    }

    @Override
    public void setPinning(LocalFileSystem localFS) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not support pinning");
    }

    @Override
    public void bumpReplicaGS(long newGS) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support writes");
    }

    @Override
    public boolean breakHardLinksIfNeeded() throws IOException {
        return false;
    }

    @Override
    public ReplicaRecoveryInfo createInfo() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support writes");
    }

    @Override
    public int compareWith(FsVolumeSpi.ScanInfo info) {
        if (info.getFileRegion().equals(new FileRegion(this.getBlockId(), new Path(this.getRemoteURI()), this.fileOffset, this.getNumBytes(), this.getGenerationStamp()))) {
            return 0;
        }
        return (int)(info.getBlockLength() - this.getNumBytes());
    }

    @Override
    public void truncateBlock(long newLength) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support truncate");
    }

    @Override
    public void updateWithReplica(StorageLocation replicaLocation) {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support update");
    }

    @Override
    public void copyMetadata(URI destination) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support copy metadata");
    }

    @Override
    public void copyBlockdata(URI destination) throws IOException {
        throw new UnsupportedOperationException("ProvidedReplica does not yet support copy data");
    }

    @VisibleForTesting
    public void setPathHandle(PathHandle pathHandle) {
        this.pathHandle = pathHandle;
    }
}

