/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.ErrorReportAction;
import org.apache.hadoop.hdfs.server.datanode.ReportBadBlockAction;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;

@InterfaceAudience.Private
class BPOfferService {
    static final Logger LOG = DataNode.LOG;
    NamespaceInfo bpNSInfo;
    volatile DatanodeRegistration bpRegistration;
    private final String nameserviceId;
    private volatile String bpId;
    private final DataNode dn;
    private BPServiceActor bpServiceToActive = null;
    private final List<BPServiceActor> bpServices = new CopyOnWriteArrayList<BPServiceActor>();
    private long lastActiveClaimTxId = -1L;
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mReadWriteLock.readLock();
    private final Lock mWriteLock = this.mReadWriteLock.writeLock();

    void readLock() {
        this.mReadLock.lock();
    }

    void readUnlock() {
        this.mReadLock.unlock();
    }

    void writeLock() {
        this.mWriteLock.lock();
    }

    void writeUnlock() {
        this.mWriteLock.unlock();
    }

    BPOfferService(String nameserviceId, List<String> nnIds, List<InetSocketAddress> nnAddrs, List<InetSocketAddress> lifelineNnAddrs, DataNode dn) {
        Preconditions.checkArgument((!nnAddrs.isEmpty() ? 1 : 0) != 0, (Object)"Must pass at least one NN.");
        Preconditions.checkArgument((nnAddrs.size() == lifelineNnAddrs.size() ? 1 : 0) != 0, (Object)"Must pass same number of NN addresses and lifeline addresses.");
        this.nameserviceId = nameserviceId;
        this.dn = dn;
        for (int i = 0; i < nnAddrs.size(); ++i) {
            this.bpServices.add(new BPServiceActor(nameserviceId, nnIds.get(i), nnAddrs.get(i), lifelineNnAddrs.get(i), this));
        }
    }

    void refreshNNList(String serviceId, List<String> nnIds, ArrayList<InetSocketAddress> addrs, ArrayList<InetSocketAddress> lifelineAddrs) throws IOException {
        HashSet oldAddrs = Sets.newHashSet();
        for (BPServiceActor actor : this.bpServices) {
            oldAddrs.add(actor.getNNSocketAddress());
        }
        HashSet newAddrs = Sets.newHashSet(addrs);
        Sets.SetView addedNNs = Sets.difference((Set)newAddrs, (Set)oldAddrs);
        for (InetSocketAddress addedNN : addedNNs) {
            BPServiceActor actor = new BPServiceActor(serviceId, nnIds.get(addrs.indexOf(addedNN)), addedNN, lifelineAddrs.get(addrs.indexOf(addedNN)), this);
            actor.start();
            this.bpServices.add(actor);
        }
        Sets.SetView removedNNs = Sets.difference((Set)oldAddrs, (Set)newAddrs);
        block2: for (InetSocketAddress removedNN : removedNNs) {
            for (BPServiceActor actor : this.bpServices) {
                if (!actor.getNNSocketAddress().equals(removedNN)) continue;
                actor.stop();
                this.shutdownActor(actor);
                continue block2;
            }
        }
    }

    boolean isInitialized() {
        return this.bpRegistration != null;
    }

    boolean isAlive() {
        for (BPServiceActor actor : this.bpServices) {
            if (!actor.isAlive()) continue;
            return true;
        }
        return false;
    }

    String getNameserviceId() {
        return this.nameserviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getBlockPoolId(boolean quiet) {
        String id = this.bpId;
        if (id != null) {
            return id;
        }
        this.readLock();
        try {
            if (this.bpNSInfo != null) {
                String string = this.bpNSInfo.getBlockPoolID();
                return string;
            }
            if (!quiet) {
                LOG.warn("Block pool ID needed, but service not yet registered with NN, trace:", (Throwable)new Exception());
            }
            String string = null;
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    String getBlockPoolId() {
        return this.getBlockPoolId(false);
    }

    boolean hasBlockPoolId() {
        return this.getBlockPoolId(true) != null;
    }

    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.bpNSInfo;
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    NamespaceInfo setNamespaceInfo(NamespaceInfo nsInfo) throws IOException {
        this.writeLock();
        try {
            NamespaceInfo old = this.bpNSInfo;
            if (this.bpNSInfo != null && nsInfo != null) {
                BPOfferService.checkNSEquality(this.bpNSInfo.getBlockPoolID(), nsInfo.getBlockPoolID(), "Blockpool ID");
                BPOfferService.checkNSEquality(this.bpNSInfo.getNamespaceID(), nsInfo.getNamespaceID(), "Namespace ID");
                BPOfferService.checkNSEquality(this.bpNSInfo.getClusterID(), nsInfo.getClusterID(), "Cluster ID");
            }
            this.bpNSInfo = nsInfo;
            this.bpId = nsInfo != null ? nsInfo.getBlockPoolID() : null;
            NamespaceInfo namespaceInfo = old;
            return namespaceInfo;
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toString() {
        this.readLock();
        try {
            if (this.bpNSInfo == null) {
                String datanodeUuid = this.dn.getDatanodeUuid();
                if (datanodeUuid == null || datanodeUuid.isEmpty()) {
                    datanodeUuid = "unassigned";
                }
                String string = "Block pool <registering> (Datanode Uuid " + datanodeUuid + ")";
                return string;
            }
            String string = "Block pool " + this.getBlockPoolId() + " (Datanode Uuid " + this.dn.getDatanodeUuid() + ")";
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    void reportBadBlocks(ExtendedBlock block, String storageUuid, StorageType storageType) {
        this.checkBlock(block);
        for (BPServiceActor actor : this.bpServices) {
            ReportBadBlockAction rbbAction = new ReportBadBlockAction(block, storageUuid, storageType);
            actor.bpThreadEnqueue(rbbAction);
        }
    }

    void notifyNamenodeReceivedBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isOnTransientStorage) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, delHint, storageUuid, isOnTransientStorage);
    }

    void notifyNamenodeReceivingBlock(ExtendedBlock block, String storageUuid) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null, storageUuid, false);
    }

    void notifyNamenodeDeletedBlock(ExtendedBlock block, String storageUuid) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null, storageUuid, false);
    }

    private void notifyNamenodeBlock(ExtendedBlock block, ReceivedDeletedBlockInfo.BlockStatus status, String delHint, String storageUuid, boolean isOnTransientStorage) {
        this.checkBlock(block);
        ReceivedDeletedBlockInfo info = new ReceivedDeletedBlockInfo(block.getLocalBlock(), status, delHint);
        DatanodeStorage storage = this.dn.getFSDataset().getStorage(storageUuid);
        for (BPServiceActor actor : this.bpServices) {
            actor.getIbrManager().notifyNamenodeBlock(info, storage, isOnTransientStorage);
        }
    }

    private void checkBlock(ExtendedBlock block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block is null");
        String bpId = this.getBlockPoolId();
        Preconditions.checkArgument((boolean)block.getBlockPoolId().equals(bpId), (String)"block belongs to BP %s instead of BP %s", (Object)block.getBlockPoolId(), (Object)bpId);
    }

    void start() {
        for (BPServiceActor actor : this.bpServices) {
            actor.start();
        }
    }

    void stop() {
        for (BPServiceActor actor : this.bpServices) {
            actor.stop();
        }
    }

    void join() {
        for (BPServiceActor actor : this.bpServices) {
            actor.join();
        }
    }

    DataNode getDataNode() {
        return this.dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyAndSetNamespaceInfo(BPServiceActor actor, NamespaceInfo nsInfo) throws IOException {
        block8: {
            this.writeLock();
            if (nsInfo.getState() == HAServiceProtocol.HAServiceState.ACTIVE && this.bpServiceToActive == null) {
                LOG.info("Acknowledging ACTIVE Namenode during handshake" + actor);
                this.bpServiceToActive = actor;
            }
            try {
                if (this.setNamespaceInfo(nsInfo) != null) break block8;
                boolean success = false;
                try {
                    this.dn.initBlockPool(this);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.setNamespaceInfo(null);
                    }
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    void registrationSucceeded(BPServiceActor bpServiceActor, DatanodeRegistration reg) throws IOException {
        this.writeLock();
        try {
            if (this.bpRegistration != null) {
                BPOfferService.checkNSEquality(this.bpRegistration.getStorageInfo().getNamespaceID(), reg.getStorageInfo().getNamespaceID(), "namespace ID");
                BPOfferService.checkNSEquality(this.bpRegistration.getStorageInfo().getClusterID(), reg.getStorageInfo().getClusterID(), "cluster ID");
            }
            this.bpRegistration = reg;
            DataNodeFaultInjector.get().delayWhenOfferServiceHoldLock();
            this.dn.bpRegistrationSucceeded(this.bpRegistration, this.getBlockPoolId());
            if (this.dn.isBlockTokenEnabled) {
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), reg.getExportedKeys());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private static void checkNSEquality(Object ourID, Object theirID, String idHelpText) throws IOException {
        if (!ourID.equals(theirID)) {
            throw new IOException(idHelpText + " mismatch: previously connected to " + idHelpText + " " + ourID + " but now connected to " + idHelpText + " " + theirID);
        }
    }

    DatanodeRegistration createRegistration() {
        this.writeLock();
        try {
            Preconditions.checkState((this.bpNSInfo != null ? 1 : 0) != 0, (Object)"getRegistration() can only be called after initial handshake");
            DatanodeRegistration datanodeRegistration = this.dn.createBPRegistration(this.bpNSInfo);
            return datanodeRegistration;
        }
        finally {
            this.writeUnlock();
        }
    }

    void shutdownActor(BPServiceActor actor) {
        this.writeLock();
        try {
            if (this.bpServiceToActive == actor) {
                this.bpServiceToActive = null;
            }
            this.bpServices.remove(actor);
            if (this.bpServices.isEmpty()) {
                this.dn.shutdownBlockPool(this);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void trySendErrorReport(int errCode, String errMsg) {
        for (BPServiceActor actor : this.bpServices) {
            ErrorReportAction errorReportAction = new ErrorReportAction(errCode, errMsg);
            actor.bpThreadEnqueue(errorReportAction);
        }
    }

    void scheduleBlockReport(long delay) {
        for (BPServiceActor actor : this.bpServices) {
            actor.getScheduler().scheduleBlockReport(delay, false);
        }
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) {
        for (BPServiceActor actor : this.bpServices) {
            try {
                actor.reportRemoteBadBlock(dnInfo, block);
            }
            catch (IOException e) {
                LOG.warn("Couldn't report bad block " + block + " to " + actor, (Throwable)e);
            }
        }
    }

    DatanodeProtocolClientSideTranslatorPB getActiveNN() {
        this.readLock();
        try {
            if (this.bpServiceToActive != null) {
                DatanodeProtocolClientSideTranslatorPB datanodeProtocolClientSideTranslatorPB = this.bpServiceToActive.bpNamenode;
                return datanodeProtocolClientSideTranslatorPB;
            }
            DatanodeProtocolClientSideTranslatorPB datanodeProtocolClientSideTranslatorPB = null;
            return datanodeProtocolClientSideTranslatorPB;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    List<BPServiceActor> getBPServiceActors() {
        return Lists.newArrayList(this.bpServices);
    }

    void signalRollingUpgrade(RollingUpgradeStatus rollingUpgradeStatus) throws IOException {
        if (rollingUpgradeStatus == null) {
            return;
        }
        String bpid = this.getBlockPoolId();
        if (!rollingUpgradeStatus.isFinalized()) {
            this.dn.getFSDataset().enableTrash(bpid);
            this.dn.getFSDataset().setRollingUpgradeMarker(bpid);
        } else {
            this.dn.getFSDataset().clearTrash(bpid);
            this.dn.getFSDataset().clearRollingUpgradeMarker(bpid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateActorStatesFromHeartbeat(BPServiceActor actor, NNHAStatusHeartbeat nnHaState) {
        this.writeLock();
        try {
            boolean isMoreRecentClaim;
            long txid = nnHaState.getTxId();
            boolean nnClaimsActive = nnHaState.getState() == HAServiceProtocol.HAServiceState.ACTIVE;
            boolean bposThinksActive = this.bpServiceToActive == actor;
            boolean bl = isMoreRecentClaim = txid > this.lastActiveClaimTxId;
            if (nnClaimsActive && !bposThinksActive) {
                LOG.info("Namenode " + actor + " trying to claim ACTIVE state with txid=" + txid);
                if (!isMoreRecentClaim) {
                    LOG.warn("NN " + actor + " tried to claim ACTIVE state at txid=" + txid + " but there was already a more recent claim at txid=" + this.lastActiveClaimTxId);
                    return;
                }
                if (this.bpServiceToActive == null) {
                    LOG.info("Acknowledging ACTIVE Namenode " + actor);
                } else {
                    LOG.info("Namenode " + actor + " taking over ACTIVE state from " + this.bpServiceToActive + " at higher txid=" + txid);
                }
                this.bpServiceToActive = actor;
            } else if (!nnClaimsActive && bposThinksActive) {
                LOG.info("Namenode " + actor + " relinquishing ACTIVE state with txid=" + nnHaState.getTxId());
                this.bpServiceToActive = null;
            }
            if (this.bpServiceToActive == actor) {
                assert (txid >= this.lastActiveClaimTxId);
                this.lastActiveClaimTxId = txid;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean containsNN(InetSocketAddress addr) {
        for (BPServiceActor actor : this.bpServices) {
            if (!actor.getNNSocketAddress().equals(addr)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int countNameNodes() {
        return this.bpServices.size();
    }

    @VisibleForTesting
    void triggerBlockReportForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.triggerBlockReportForTests();
        }
    }

    @VisibleForTesting
    void triggerDeletionReportForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.getIbrManager().triggerDeletionReportForTests();
        }
    }

    @VisibleForTesting
    void triggerHeartbeatForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.triggerHeartbeatForTests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processCommandFromActor(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        assert (this.bpServices.contains(actor));
        if (cmd == null) {
            return true;
        }
        if (4 == cmd.getAction()) {
            LOG.info("DatanodeCommand action : DNA_REGISTER from " + actor.nnAddr + " with " + actor.state + " state");
            actor.reRegister();
            return false;
        }
        this.writeLock();
        try {
            if (actor == this.bpServiceToActive) {
                boolean bl = this.processCommandFromActive(cmd, actor);
                return bl;
            }
            boolean bl = this.processCommandFromStandby(cmd, actor);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private String blockIdArrayToString(long[] ids) {
        long maxNumberOfBlocksToLog = this.dn.getMaxNumberOfBlocksToLog();
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (int i = 0; i < ids.length; ++i) {
            if ((long)i >= maxNumberOfBlocksToLog) {
                bld.append("...");
                break;
            }
            bld.append(prefix).append(ids[i]);
            prefix = ", ";
        }
        return bld.toString();
    }

    private boolean processCommandFromActive(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        BlockCommand bcmd = cmd instanceof BlockCommand ? (BlockCommand)cmd : null;
        BlockIdCommand blockIdCmd = cmd instanceof BlockIdCommand ? (BlockIdCommand)cmd : null;
        switch (cmd.getAction()) {
            case 1: {
                this.dn.transferBlocks(bcmd.getBlockPoolId(), bcmd.getBlocks(), bcmd.getTargets(), bcmd.getTargetStorageTypes(), bcmd.getTargetStorageIDs());
                break;
            }
            case 2: {
                Block[] toDelete = bcmd.getBlocks();
                this.dn.getFSDataset().invalidate(bcmd.getBlockPoolId(), toDelete);
                this.dn.metrics.incrBlocksRemoved(toDelete.length);
                break;
            }
            case 9: {
                LOG.info("DatanodeCommand action: DNA_CACHE for " + blockIdCmd.getBlockPoolId() + " of [" + this.blockIdArrayToString(blockIdCmd.getBlockIds()) + "]");
                this.dn.getFSDataset().cache(blockIdCmd.getBlockPoolId(), blockIdCmd.getBlockIds());
                break;
            }
            case 10: {
                LOG.info("DatanodeCommand action: DNA_UNCACHE for " + blockIdCmd.getBlockPoolId() + " of [" + this.blockIdArrayToString(blockIdCmd.getBlockIds()) + "]");
                this.dn.getFSDataset().uncache(blockIdCmd.getBlockPoolId(), blockIdCmd.getBlockIds());
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Received unimplemented DNA_SHUTDOWN");
            }
            case 5: {
                String bp = ((FinalizeCommand)cmd).getBlockPoolId();
                LOG.info("Got finalize command for block pool " + bp);
                assert (this.getBlockPoolId().equals(bp)) : "BP " + this.getBlockPoolId() + " received DNA_FINALIZE for other block pool " + bp;
                this.dn.finalizeUpgradeForPool(bp);
                break;
            }
            case 6: {
                String who = "NameNode at " + actor.getNNSocketAddress();
                this.dn.getBlockRecoveryWorker().recoverBlocks(who, ((BlockRecoveryCommand)cmd).getRecoveringBlocks());
                break;
            }
            case 7: {
                LOG.info("DatanodeCommand action: DNA_ACCESSKEYUPDATE");
                if (!this.dn.isBlockTokenEnabled) break;
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), ((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            case 8: {
                LOG.info("DatanodeCommand action: DNA_BALANCERBANDWIDTHUPDATE");
                long bandwidth = ((BalancerBandwidthCommand)cmd).getBalancerBandwidthValue();
                if (bandwidth <= 0L) break;
                DataXceiverServer dxcs = (DataXceiverServer)this.dn.dataXceiverServer.getRunnable();
                LOG.info("Updating balance throttler bandwidth from " + dxcs.balanceThrottler.getBandwidth() + " bytes/s to: " + bandwidth + " bytes/s.");
                dxcs.balanceThrottler.setBandwidth(bandwidth);
                break;
            }
            case 11: {
                LOG.info("DatanodeCommand action: DNA_ERASURE_CODING_RECOVERY");
                Collection<BlockECReconstructionCommand.BlockECReconstructionInfo> ecTasks = ((BlockECReconstructionCommand)cmd).getECTasks();
                this.dn.getErasureCodingWorker().processErasureCodingTasks(ecTasks);
                break;
            }
            default: {
                LOG.warn("Unknown DatanodeCommand action: " + cmd.getAction());
            }
        }
        return true;
    }

    private boolean processCommandFromStandby(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        switch (cmd.getAction()) {
            case 7: {
                LOG.info("DatanodeCommand action from standby: DNA_ACCESSKEYUPDATE");
                if (!this.dn.isBlockTokenEnabled) break;
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), ((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                LOG.warn("Got a command from standby NN - ignoring command:" + cmd.getAction());
                break;
            }
            default: {
                LOG.warn("Unknown DatanodeCommand action: " + cmd.getAction());
            }
        }
        return true;
    }

    boolean shouldRetryInit() {
        if (this.hasBlockPoolId()) {
            return true;
        }
        return this.isAlive();
    }
}

