/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorBase;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorInterface;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.util.CyclicIteration;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ChunkedArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeAdminDefaultMonitor
extends DatanodeAdminMonitorBase
implements DatanodeAdminMonitorInterface {
    private final TreeMap<DatanodeDescriptor, AbstractList<BlockInfo>> outOfServiceNodeBlocks;
    private int numBlocksPerCheck;
    private int numBlocksChecked = 0;
    private int numBlocksCheckedPerLock = 0;
    private int numNodesChecked = 0;
    private DatanodeDescriptor iterkey = new DatanodeDescriptor(new DatanodeID("", "", "", 0, 0, 0, 0));
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeAdminDefaultMonitor.class);

    DatanodeAdminDefaultMonitor() {
        this.outOfServiceNodeBlocks = new TreeMap();
    }

    @Override
    protected void processConf() {
        this.numBlocksPerCheck = this.conf.getInt("dfs.namenode.decommission.blocks.per.interval", 500000);
        if (this.numBlocksPerCheck <= 0) {
            LOG.error("{} must be greater than zero. Defaulting to {}", (Object)"dfs.namenode.decommission.blocks.per.interval", (Object)500000);
            this.numBlocksPerCheck = 500000;
        }
        LOG.info("Initialized the Default Decommission and Maintenance monitor");
    }

    private boolean exceededNumBlocksPerCheck() {
        LOG.trace("Processed {} blocks so far this tick", (Object)this.numBlocksChecked);
        return this.numBlocksChecked >= this.numBlocksPerCheck;
    }

    @Override
    public void stopTrackingNode(DatanodeDescriptor dn) {
        this.pendingNodes.remove((Object)dn);
        this.outOfServiceNodeBlocks.remove((Object)dn);
    }

    @Override
    public int getTrackedNodeCount() {
        return this.outOfServiceNodeBlocks.size();
    }

    @Override
    public int getNumNodesChecked() {
        return this.numNodesChecked;
    }

    @Override
    public void run() {
        LOG.debug("DatanodeAdminMonitor is running.");
        if (!this.namesystem.isRunning()) {
            LOG.info("Namesystem is not running, skipping decommissioning/maintenance checks.");
            return;
        }
        this.numBlocksChecked = 0;
        this.numBlocksCheckedPerLock = 0;
        this.numNodesChecked = 0;
        this.namesystem.writeLock();
        try {
            this.processPendingNodes();
            this.check();
        }
        catch (Exception e) {
            LOG.warn("DatanodeAdminMonitor caught exception when processing node.", (Throwable)e);
        }
        finally {
            this.namesystem.writeUnlock();
        }
        if (this.numBlocksChecked + this.numNodesChecked > 0) {
            LOG.info("Checked {} blocks and {} nodes this tick. {} nodes are now in maintenance or transitioning state. {} nodes pending.", new Object[]{this.numBlocksChecked, this.numNodesChecked, this.outOfServiceNodeBlocks.size(), this.pendingNodes.size()});
        }
    }

    private void processPendingNodes() {
        while (!(this.pendingNodes.isEmpty() || this.maxConcurrentTrackedNodes != 0 && this.outOfServiceNodeBlocks.size() >= this.maxConcurrentTrackedNodes)) {
            this.outOfServiceNodeBlocks.put((DatanodeDescriptor)((Object)this.pendingNodes.poll()), (AbstractList<BlockInfo>)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        Iterator<Map.Entry<DatanodeDescriptor, AbstractList<BlockInfo>>> it = new CyclicIteration<DatanodeDescriptor, AbstractList<BlockInfo>>(this.outOfServiceNodeBlocks, this.iterkey).iterator();
        ArrayList<DatanodeDescriptor> toRemove = new ArrayList<DatanodeDescriptor>();
        while (it.hasNext() && !this.exceededNumBlocksPerCheck() && this.namesystem.isRunning()) {
            ++this.numNodesChecked;
            Map.Entry<DatanodeDescriptor, AbstractList<BlockInfo>> entry = it.next();
            DatanodeDescriptor dn = entry.getKey();
            try {
                AbstractList<BlockInfo> blocks = entry.getValue();
                boolean fullScan = false;
                if (dn.isMaintenance() && dn.maintenanceExpired()) {
                    this.dnAdmin.stopMaintenance(dn);
                    toRemove.add(dn);
                    continue;
                }
                if (dn.isInMaintenance()) continue;
                if (blocks == null) {
                    LOG.debug("Newly-added node {}, doing full scan to find insufficiently-replicated blocks.", (Object)dn);
                    blocks = this.handleInsufficientlyStored(dn);
                    this.outOfServiceNodeBlocks.put(dn, blocks);
                    fullScan = true;
                } else {
                    LOG.debug("Processing {} node {}", (Object)dn.getAdminState(), (Object)dn);
                    this.pruneReliableBlocks(dn, blocks);
                }
                if (blocks.size() == 0) {
                    if (!fullScan) {
                        LOG.debug("Node {} has finished replicating current set of blocks, checking with the full block map.", (Object)dn);
                        blocks = this.handleInsufficientlyStored(dn);
                        this.outOfServiceNodeBlocks.put(dn, blocks);
                    }
                    boolean isHealthy = this.blockManager.isNodeHealthyForDecommissionOrMaintenance(dn);
                    if (blocks.size() == 0 && isHealthy) {
                        if (dn.isDecommissionInProgress()) {
                            this.dnAdmin.setDecommissioned(dn);
                            toRemove.add(dn);
                        } else if (dn.isEnteringMaintenance()) {
                            this.dnAdmin.setInMaintenance(dn);
                        } else {
                            Preconditions.checkState((boolean)false, (String)"Node %s is in an invalid state! Invalid state: %s %s blocks are on this dn.", (Object)((Object)dn), (Object)dn.getAdminState(), (Object)blocks.size());
                        }
                        LOG.debug("Node {} is sufficiently replicated and healthy, marked as {}.", (Object)dn, (Object)dn.getAdminState());
                        continue;
                    }
                    LOG.info("Node {} {} healthy. It needs to replicate {} more blocks. {} is still in progress.", new Object[]{dn, isHealthy ? "is" : "isn't", blocks.size(), dn.getAdminState()});
                    continue;
                }
                LOG.info("Node {} still has {} blocks to replicate before it is a candidate to finish {}.", new Object[]{dn, blocks.size(), dn.getAdminState()});
            }
            catch (Exception e) {
                LOG.warn("DatanodeAdminMonitor caught exception when processing node {}.", (Object)dn, (Object)e);
                this.pendingNodes.add(dn);
                toRemove.add(dn);
            }
            finally {
                this.iterkey = dn;
            }
        }
        for (DatanodeDescriptor dn : toRemove) {
            Preconditions.checkState((dn.isDecommissioned() || dn.isInService() ? 1 : 0) != 0, (String)"Removing node %s that is not yet decommissioned or in service!", (Object)((Object)dn));
            this.outOfServiceNodeBlocks.remove((Object)dn);
        }
    }

    private void pruneReliableBlocks(DatanodeDescriptor datanode, AbstractList<BlockInfo> blocks) {
        this.processBlocksInternal(datanode, blocks.iterator(), null, true);
    }

    private AbstractList<BlockInfo> handleInsufficientlyStored(DatanodeDescriptor datanode) {
        ChunkedArrayList insufficient = new ChunkedArrayList();
        this.processBlocksInternal(datanode, datanode.getBlockIterator(), (List<BlockInfo>)insufficient, false);
        return insufficient;
    }

    private void processBlocksInternal(DatanodeDescriptor datanode, Iterator<BlockInfo> it, List<BlockInfo> insufficientList, boolean pruneReliableBlocks) {
        boolean firstReplicationLog = true;
        int lowRedundancyBlocksInOpenFiles = 0;
        LightWeightLinkedSet<Long> lowRedundancyOpenFiles = new LightWeightLinkedSet<Long>();
        int lowRedundancyBlocks = 0;
        int outOfServiceOnlyReplicas = 0;
        while (it.hasNext()) {
            boolean neededReconstruction;
            if (insufficientList == null && this.numBlocksCheckedPerLock >= this.numBlocksPerCheck) {
                this.namesystem.writeUnlock();
                try {
                    LOG.debug("Yielded lock during decommission/maintenance check");
                    Thread.sleep(0L, 500);
                }
                catch (InterruptedException ignored) {
                    return;
                }
                this.numBlocksCheckedPerLock = 0;
                this.namesystem.writeLock();
            }
            ++this.numBlocksChecked;
            ++this.numBlocksCheckedPerLock;
            BlockInfo block = it.next();
            if (this.blockManager.blocksMap.getStoredBlock(block) == null) {
                LOG.trace("Removing unknown block {}", (Object)block);
                it.remove();
                continue;
            }
            long bcId = block.getBlockCollectionId();
            if (bcId == -1L) continue;
            BlockCollection bc = this.blockManager.getBlockCollection(block);
            NumberReplicas num = this.blockManager.countNodes(block);
            int liveReplicas = num.liveReplicas();
            boolean isDecommission = datanode.isDecommissionInProgress();
            boolean isMaintenance = datanode.isEnteringMaintenance();
            boolean bl = neededReconstruction = isDecommission ? this.blockManager.isNeededReconstruction(block, num) : this.blockManager.isNeededReconstructionForMaintenance(block, num);
            if (neededReconstruction && !this.blockManager.neededReconstruction.contains(block) && this.blockManager.pendingReconstruction.getNumReplicas(block) == 0 && this.blockManager.isPopulatingReplQueues()) {
                this.blockManager.neededReconstruction.add(block, liveReplicas, num.readOnlyReplicas(), num.outOfServiceReplicas(), this.blockManager.getExpectedRedundancyNum(block));
            }
            if (this.dnAdmin.isSufficient(block, bc, num, isDecommission, isMaintenance)) {
                if (!pruneReliableBlocks) continue;
                it.remove();
                continue;
            }
            if (insufficientList != null) {
                insufficientList.add(block);
            }
            if (firstReplicationLog) {
                this.dnAdmin.logBlockReplicationInfo(block, bc, datanode, num, this.blockManager.blocksMap.getStorages(block));
                firstReplicationLog = false;
            }
            ++lowRedundancyBlocks;
            if (bc.isUnderConstruction()) {
                INode ucFile = this.namesystem.getFSDirectory().getInode(bc.getId());
                if (!(ucFile instanceof INodeFile) || !ucFile.asFile().isUnderConstruction()) {
                    LOG.warn("File {} is not under construction. Skipping add to low redundancy open files!", (Object)ucFile.getLocalName());
                } else {
                    ++lowRedundancyBlocksInOpenFiles;
                    lowRedundancyOpenFiles.add(ucFile.getId());
                }
            }
            if (liveReplicas != 0 || num.outOfServiceReplicas() <= 0) continue;
            ++outOfServiceOnlyReplicas;
        }
        datanode.getLeavingServiceStatus().set(lowRedundancyBlocksInOpenFiles, lowRedundancyOpenFiles, lowRedundancyBlocks, outOfServiceOnlyReplicas);
    }
}

