/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ExecutionTypeRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlRootElement(name="resourceRequests")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceRequestInfo {
    @XmlElement(name="priority")
    private int priority;
    @XmlElement(name="allocationRequestId")
    private long allocationRequestId;
    @XmlElement(name="resourceName")
    private String resourceName;
    @XmlElement(name="capability")
    private ResourceInfo capability;
    @XmlElement(name="numContainers")
    private int numContainers;
    @XmlElement(name="relaxLocality")
    private boolean relaxLocality;
    @XmlElement(name="nodeLabelExpression")
    private String nodeLabelExpression;
    @XmlElement(name="executionTypeRequest")
    private ExecutionTypeRequestInfo executionTypeRequest;
    @XmlElement(name="placementConstraint")
    private String placementConstraint;
    @XmlElement(name="allocationTags")
    private Set<String> allocationTags;

    public ResourceRequestInfo() {
    }

    public ResourceRequestInfo(ResourceRequest request) {
        this.priority = request.getPriority().getPriority();
        this.allocationRequestId = request.getAllocationRequestId();
        this.resourceName = request.getResourceName();
        this.capability = new ResourceInfo(request.getCapability());
        this.numContainers = request.getNumContainers();
        this.relaxLocality = request.getRelaxLocality();
        this.nodeLabelExpression = request.getNodeLabelExpression();
        if (request.getExecutionTypeRequest() != null) {
            this.executionTypeRequest = new ExecutionTypeRequestInfo(request.getExecutionTypeRequest());
        }
    }

    public ResourceRequestInfo(SchedulingRequest request) {
        this.priority = request.getPriority().getPriority();
        this.allocationRequestId = request.getAllocationRequestId();
        this.capability = new ResourceInfo(request.getResourceSizing().getResources());
        this.numContainers = request.getResourceSizing().getNumAllocations();
        if (request.getExecutionType() != null) {
            this.executionTypeRequest = new ExecutionTypeRequestInfo(request.getExecutionType());
        }
        this.allocationTags = request.getAllocationTags();
        if (request.getPlacementConstraint() != null) {
            this.placementConstraint = request.getPlacementConstraint().toString();
        }
    }

    public Priority getPriority() {
        return Priority.newInstance((int)this.priority);
    }

    public void setPriority(Priority priority) {
        this.priority = priority.getPriority();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ResourceInfo getCapability() {
        return this.capability;
    }

    public void setCapability(ResourceInfo capability) {
        this.capability = capability;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public void setNumContainers(int numContainers) {
        this.numContainers = numContainers;
    }

    public boolean getRelaxLocality() {
        return this.relaxLocality;
    }

    public void setRelaxLocality(boolean relaxLocality) {
        this.relaxLocality = relaxLocality;
    }

    public String getNodeLabelExpression() {
        return this.nodeLabelExpression;
    }

    public void setNodeLabelExpression(String nodeLabelExpression) {
        this.nodeLabelExpression = nodeLabelExpression;
    }

    public void setExecutionTypeRequest(ExecutionTypeRequest executionTypeRequest) {
        this.executionTypeRequest = new ExecutionTypeRequestInfo(executionTypeRequest);
    }

    public ExecutionTypeRequestInfo getExecutionTypeRequest() {
        return this.executionTypeRequest;
    }

    public String getPlacementConstraint() {
        return this.placementConstraint;
    }

    public void setPlacementConstraint(String placementConstraint) {
        this.placementConstraint = placementConstraint;
    }

    public Set<String> getAllocationTags() {
        return this.allocationTags;
    }

    public void setAllocationTags(Set<String> allocationTags) {
        this.allocationTags = allocationTags;
    }

    public long getAllocationRequestId() {
        return this.allocationRequestId;
    }

    public void setAllocationRequestId(long allocationRequestId) {
        this.allocationRequestId = allocationRequestId;
    }
}

