/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;

public class ActivityNode {
    private String activityNodeName;
    private String parentName;
    private String appPriority;
    private String requestPriority;
    private ActivityState state;
    private String diagnostic;
    private List<ActivityNode> childNode;

    public ActivityNode(String activityNodeName, String parentName, String priority, ActivityState state, String diagnostic, String type) {
        this.activityNodeName = activityNodeName;
        this.parentName = parentName;
        if (type != null) {
            if (type.equals("app")) {
                this.appPriority = priority;
            } else if (type.equals("container")) {
                this.requestPriority = priority;
            }
        }
        this.state = state;
        this.diagnostic = diagnostic;
        this.childNode = new LinkedList<ActivityNode>();
    }

    public String getName() {
        return this.activityNodeName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void addChild(ActivityNode node) {
        this.childNode.add(0, node);
    }

    public List<ActivityNode> getChildren() {
        return this.childNode;
    }

    public ActivityState getState() {
        return this.state;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public String getAppPriority() {
        return this.appPriority;
    }

    public String getRequestPriority() {
        return this.requestPriority;
    }

    public boolean getType() {
        return this.appPriority != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.activityNodeName + " ");
        sb.append(this.appPriority + " ");
        sb.append((Object)((Object)this.state) + " ");
        if (!this.diagnostic.equals("")) {
            sb.append(this.diagnostic + "\n");
        }
        sb.append("\n");
        for (ActivityNode child : this.childNode) {
            sb.append(child.toString() + "\n");
        }
        return sb.toString();
    }
}

