/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ContainerUpdateContext {
    public static final ContainerId UNDEFINED = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)-1L, (int)-1), (int)-1), (long)-1L);
    protected static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private final Map<SchedulerRequestKey, Map<Resource, Map<NodeId, Set<ContainerId>>>> outstandingIncreases = new HashMap<SchedulerRequestKey, Map<Resource, Map<NodeId, Set<ContainerId>>>>();
    private final Map<ContainerId, Resource> outstandingDecreases = new HashMap<ContainerId, Resource>();
    private final AppSchedulingInfo appSchedulingInfo;

    ContainerUpdateContext(AppSchedulingInfo appSchedulingInfo) {
        this.appSchedulingInfo = appSchedulingInfo;
    }

    public synchronized boolean checkAndAddToOutstandingDecreases(UpdateContainerRequest updateReq, SchedulerNode schedulerNode, Container container) {
        if (this.outstandingDecreases.containsKey(container.getId())) {
            return false;
        }
        if (ContainerUpdateType.DECREASE_RESOURCE == updateReq.getContainerUpdateType()) {
            SchedulerRequestKey updateKey = new SchedulerRequestKey(container.getPriority(), container.getAllocationRequestId(), container.getId());
            this.cancelPreviousRequest(schedulerNode, updateKey);
            this.outstandingDecreases.put(container.getId(), updateReq.getCapability());
        } else {
            this.outstandingDecreases.put(container.getId(), container.getResource());
        }
        return true;
    }

    public synchronized boolean checkAndAddToOutstandingIncreases(RMContainer rmContainer, SchedulerNode schedulerNode, UpdateContainerRequest updateRequest) {
        Set<ContainerId> containerIds;
        Container container = rmContainer.getContainer();
        SchedulerRequestKey schedulerKey = SchedulerRequestKey.create(updateRequest, rmContainer.getAllocatedSchedulerKey());
        Map<Resource, Map<NodeId, Set<ContainerId>>> resourceMap = this.outstandingIncreases.get(schedulerKey);
        if (resourceMap == null) {
            resourceMap = new HashMap<Resource, Map<NodeId, Set<ContainerId>>>();
            this.outstandingIncreases.put(schedulerKey, resourceMap);
        } else if (ContainerUpdateType.INCREASE_RESOURCE == updateRequest.getContainerUpdateType()) {
            this.cancelPreviousRequest(schedulerNode, schedulerKey);
        } else {
            return false;
        }
        Resource resToIncrease = this.getResourceToIncrease(updateRequest, rmContainer);
        Map<NodeId, Set<ContainerId>> locationMap = resourceMap.get(resToIncrease);
        if (locationMap == null) {
            locationMap = new HashMap<NodeId, Set<ContainerId>>();
            resourceMap.put(resToIncrease, locationMap);
        }
        if ((containerIds = locationMap.get(container.getNodeId())) == null) {
            containerIds = new HashSet<ContainerId>();
            locationMap.put(container.getNodeId(), containerIds);
        }
        if (this.outstandingDecreases.containsKey(container.getId())) {
            return false;
        }
        containerIds.add(container.getId());
        if (!Resources.isNone((Resource)resToIncrease)) {
            HashMap<SchedulerRequestKey, Map<String, ResourceRequest>> updateResReqs = new HashMap<SchedulerRequestKey, Map<String, ResourceRequest>>();
            Map<String, ResourceRequest> resMap = this.createResourceRequests(rmContainer, schedulerNode, schedulerKey, resToIncrease);
            updateResReqs.put(schedulerKey, resMap);
            this.appSchedulingInfo.updateResourceRequests(updateResReqs, false);
        }
        return true;
    }

    private void cancelPreviousRequest(SchedulerNode schedulerNode, SchedulerRequestKey schedulerKey) {
        PendingAsk pendingAsk;
        AppPlacementAllocator appPlacementAllocator = this.appSchedulingInfo.getAppPlacementAllocator(schedulerKey);
        if (appPlacementAllocator != null && (pendingAsk = appPlacementAllocator.getPendingAsk("*")) != null && pendingAsk.getCount() > 0) {
            Container container = Container.newInstance((ContainerId)UNDEFINED, (NodeId)schedulerNode.getNodeID(), (String)"host:port", (Resource)pendingAsk.getPerAllocationResource(), (Priority)schedulerKey.getPriority(), null);
            this.appSchedulingInfo.allocate(NodeType.OFF_SWITCH, schedulerNode, schedulerKey, new RMContainerImpl(container, schedulerKey, this.appSchedulingInfo.getApplicationAttemptId(), schedulerNode.getNodeID(), this.appSchedulingInfo.getUser(), this.appSchedulingInfo.getRMContext(), appPlacementAllocator.getPrimaryRequestedNodePartition()));
        }
    }

    private Map<String, ResourceRequest> createResourceRequests(RMContainer rmContainer, SchedulerNode schedulerNode, SchedulerRequestKey schedulerKey, Resource resToIncrease) {
        HashMap<String, ResourceRequest> resMap = new HashMap<String, ResourceRequest>();
        resMap.put(rmContainer.getContainer().getNodeId().getHost(), ContainerUpdateContext.createResourceReqForIncrease(schedulerKey, resToIncrease, (ResourceRequest)RECORD_FACTORY.newRecordInstance(ResourceRequest.class), rmContainer, rmContainer.getContainer().getNodeId().getHost()));
        resMap.put(schedulerNode.getRackName(), ContainerUpdateContext.createResourceReqForIncrease(schedulerKey, resToIncrease, (ResourceRequest)RECORD_FACTORY.newRecordInstance(ResourceRequest.class), rmContainer, schedulerNode.getRackName()));
        resMap.put("*", ContainerUpdateContext.createResourceReqForIncrease(schedulerKey, resToIncrease, (ResourceRequest)RECORD_FACTORY.newRecordInstance(ResourceRequest.class), rmContainer, "*"));
        return resMap;
    }

    private Resource getResourceToIncrease(UpdateContainerRequest updateReq, RMContainer rmContainer) {
        if (updateReq.getContainerUpdateType() == ContainerUpdateType.PROMOTE_EXECUTION_TYPE) {
            return rmContainer.getContainer().getResource();
        }
        if (updateReq.getContainerUpdateType() == ContainerUpdateType.INCREASE_RESOURCE) {
            Resource maxCap = Resources.componentwiseMax((Resource)updateReq.getCapability(), (Resource)rmContainer.getContainer().getResource());
            return Resources.add((Resource)maxCap, (Resource)Resources.negate((Resource)rmContainer.getContainer().getResource()));
        }
        return null;
    }

    private static ResourceRequest createResourceReqForIncrease(SchedulerRequestKey schedulerRequestKey, Resource resToIncrease, ResourceRequest rr, RMContainer rmContainer, String resourceName) {
        rr.setResourceName(resourceName);
        rr.setNumContainers(1);
        rr.setRelaxLocality(false);
        rr.setPriority(rmContainer.getContainer().getPriority());
        rr.setAllocationRequestId(schedulerRequestKey.getAllocationRequestId());
        rr.setCapability(resToIncrease);
        rr.setNodeLabelExpression(rmContainer.getNodeLabelExpression());
        rr.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED, (boolean)true));
        return rr;
    }

    public synchronized void removeFromOutstandingUpdate(SchedulerRequestKey schedulerKey, Container container) {
        Map<Resource, Map<NodeId, Set<ContainerId>>> resourceMap = this.outstandingIncreases.get(schedulerKey);
        if (resourceMap != null) {
            Map<NodeId, Set<ContainerId>> locationMap = resourceMap.get(container.getResource());
            if (locationMap != null) {
                Set<ContainerId> containerIds = locationMap.get(container.getNodeId());
                if (containerIds != null && !containerIds.isEmpty()) {
                    containerIds.remove(container.getId());
                    if (containerIds.isEmpty()) {
                        locationMap.remove(container.getNodeId());
                    }
                }
                if (locationMap.isEmpty()) {
                    resourceMap.remove(container.getResource());
                }
            }
            if (resourceMap.isEmpty()) {
                this.outstandingIncreases.remove(schedulerKey);
            }
        }
        this.outstandingDecreases.remove(container.getId());
    }

    public ContainerId matchContainerToOutstandingIncreaseReq(SchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer rmContainer) {
        Set<ContainerId> containerIds;
        Map<NodeId, Set<ContainerId>> locationMap;
        ContainerId retVal = null;
        Container container = rmContainer.getContainer();
        Map<Resource, Map<NodeId, Set<ContainerId>>> resourceMap = this.outstandingIncreases.get(schedulerKey);
        if (resourceMap != null && (locationMap = resourceMap.get(container.getResource())) != null && (containerIds = locationMap.get(container.getNodeId())) != null && !containerIds.isEmpty()) {
            retVal = containerIds.iterator().next();
        }
        if (resourceMap != null && retVal == null) {
            HashMap<SchedulerRequestKey, Map<String, ResourceRequest>> reqsToUpdate = new HashMap<SchedulerRequestKey, Map<String, ResourceRequest>>();
            Map<String, ResourceRequest> resMap = this.createResourceRequests(rmContainer, node, schedulerKey, rmContainer.getContainer().getResource());
            reqsToUpdate.put(schedulerKey, resMap);
            this.appSchedulingInfo.updateResourceRequests(reqsToUpdate, true);
            return UNDEFINED;
        }
        return retVal;
    }

    public RMContainer swapContainer(RMContainer tempRMContainer, RMContainer existingRMContainer, ContainerUpdateType updateType) {
        ContainerId matchedContainerId = existingRMContainer.getContainerId();
        Container tempContainer = tempRMContainer.getContainer();
        Resource updatedResource = this.createUpdatedResource(tempContainer, existingRMContainer.getContainer(), updateType);
        Resource resourceToRelease = this.createResourceToRelease(existingRMContainer.getContainer(), updateType);
        Container newContainer = Container.newInstance((ContainerId)matchedContainerId, (NodeId)existingRMContainer.getContainer().getNodeId(), (String)existingRMContainer.getContainer().getNodeHttpAddress(), (Resource)updatedResource, (Priority)existingRMContainer.getContainer().getPriority(), null, (ExecutionType)tempContainer.getExecutionType());
        newContainer.setAllocationRequestId(existingRMContainer.getContainer().getAllocationRequestId());
        newContainer.setVersion(existingRMContainer.getContainer().getVersion());
        tempRMContainer.getContainer().setResource(resourceToRelease);
        tempRMContainer.getContainer().setExecutionType(existingRMContainer.getContainer().getExecutionType());
        ((RMContainerImpl)existingRMContainer).setContainer(newContainer);
        return existingRMContainer;
    }

    private Resource createUpdatedResource(Container tempContainer, Container existingContainer, ContainerUpdateType updateType) {
        if (ContainerUpdateType.INCREASE_RESOURCE == updateType) {
            return Resources.add((Resource)existingContainer.getResource(), (Resource)tempContainer.getResource());
        }
        if (ContainerUpdateType.DECREASE_RESOURCE == updateType) {
            return this.outstandingDecreases.get(existingContainer.getId());
        }
        return existingContainer.getResource();
    }

    private Resource createResourceToRelease(Container existingContainer, ContainerUpdateType updateType) {
        if (ContainerUpdateType.INCREASE_RESOURCE == updateType) {
            return Resources.none();
        }
        if (ContainerUpdateType.DECREASE_RESOURCE == updateType) {
            return Resources.add((Resource)existingContainer.getResource(), (Resource)Resources.negate((Resource)this.outstandingDecreases.get(existingContainer.getId())));
        }
        return existingContainer.getResource();
    }
}

