/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class LoadBasedRouterPolicy
extends AbstractRouterPolicy {
    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        WeightedPolicyInfo tempPolicy = this.getPolicyInfo();
        super.reinitialize(policyContext);
        for (Float weight : this.getPolicyInfo().getRouterPolicyWeights().values()) {
            if (weight.floatValue() == 0.0f || weight.floatValue() == 1.0f) continue;
            this.setPolicyInfo(tempPolicy);
            throw new FederationPolicyInitializationException(this.getClass().getCanonicalName() + " policy expects all weights to be either \"0\" or \"1\"");
        }
    }

    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blacklist) throws YarnException {
        this.validate(appSubmissionContext);
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getActiveSubclusters();
        FederationPolicyUtils.validateSubClusterAvailability(new ArrayList<SubClusterId>(activeSubclusters.keySet()), blacklist);
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        SubClusterIdInfo chosen = null;
        long currBestMem = -1L;
        for (Map.Entry<SubClusterId, SubClusterInfo> entry : activeSubclusters.entrySet()) {
            long availableMemory;
            SubClusterIdInfo id;
            if (blacklist != null && blacklist.contains(entry.getKey()) || !weights.containsKey(id = new SubClusterIdInfo(entry.getKey())) || !(weights.get(id).floatValue() > 0.0f) || (availableMemory = this.getAvailableMemory(entry.getValue())) <= currBestMem) continue;
            currBestMem = availableMemory;
            chosen = id;
        }
        return chosen.toId();
    }

    private long getAvailableMemory(SubClusterInfo value) throws YarnException {
        try {
            long mem = -1L;
            JSONObject obj = new JSONObject(value.getCapability());
            mem = obj.getJSONObject("clusterMetrics").getLong("availableMB");
            return mem;
        }
        catch (JSONException j) {
            throw new YarnException("FederationSubCluserInfo cannot be parsed", (Throwable)j);
        }
    }
}

