/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.events;

import org.apache.hadoop.shaded.org.ehcache.event.CacheEvent;
import org.apache.hadoop.shaded.org.ehcache.event.CacheEventListener;

public abstract class CacheEventAdapter<K, V>
implements CacheEventListener<K, V> {
    @Override
    public final void onEvent(CacheEvent<? extends K, ? extends V> event) {
        switch (event.getType()) {
            case CREATED: {
                this.onCreation(event.getKey(), event.getNewValue());
                break;
            }
            case UPDATED: {
                this.onUpdate(event.getKey(), event.getOldValue(), event.getNewValue());
                break;
            }
            case REMOVED: {
                this.onRemoval(event.getKey(), event.getOldValue());
                break;
            }
            case EXPIRED: {
                this.onExpiry(event.getKey(), event.getOldValue());
                break;
            }
            case EVICTED: {
                this.onEviction(event.getKey(), event.getOldValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported event type " + (Object)((Object)event.getType())));
            }
        }
    }

    protected void onEviction(K key, V evictedValue) {
    }

    protected void onExpiry(K key, V expiredValue) {
    }

    protected void onRemoval(K key, V removedValue) {
    }

    protected void onUpdate(K key, V oldValue, V newValue) {
    }

    protected void onCreation(K key, V newValue) {
    }
}

