/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxnFactory
extends ServerCnxnFactory
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnFactory.class);
    ServerSocketChannel ss;
    final Selector selector = Selector.open();
    final ByteBuffer directBuffer = ByteBuffer.allocateDirect(65536);
    final HashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new HashMap();
    int maxClientCnxns = 60;
    Thread thread;

    @Override
    public void configure(InetSocketAddress addr, int maxcc) throws IOException {
        this.configureSaslLogin();
        this.thread = new ZooKeeperThread(this, "NIOServerCxn.Factory:" + addr);
        this.thread.setDaemon(true);
        this.maxClientCnxns = maxcc;
        this.ss = ServerSocketChannel.open();
        this.ss.socket().setReuseAddress(true);
        LOG.info("binding to port " + addr);
        this.ss.socket().bind(addr);
        this.ss.configureBlocking(false);
        this.ss.register(this.selector, 16);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        this.maxClientCnxns = max;
    }

    @Override
    public void start() {
        if (this.thread.getState() == Thread.State.NEW) {
            this.thread.start();
        }
    }

    @Override
    public void startup(ZooKeeperServer zks) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zks);
        zks.startdata();
        zks.startup();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ss.socket().getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCnxn(NIOServerCnxn cnxn) throws IOException {
        HashSet hashSet = this.cnxns;
        synchronized (hashSet) {
            this.cnxns.add(cnxn);
            HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
            synchronized (hashMap) {
                InetAddress addr = cnxn.getSocketAddress();
                if (addr == null) {
                    throw new IOException("Socket of " + cnxn + " has been closed");
                }
                Set<NIOServerCnxn> s = this.ipMap.get(addr);
                if (s == null) {
                    s = new HashSet<NIOServerCnxn>(2);
                    s.add(cnxn);
                    this.ipMap.put(addr, s);
                } else {
                    s.add(cnxn);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCnxn(NIOServerCnxn cnxn) {
        HashSet hashSet = this.cnxns;
        synchronized (hashSet) {
            long sessionId = cnxn.getSessionId();
            if (sessionId != 0L) {
                this.sessionMap.remove(sessionId);
            }
            if (!this.cnxns.remove(cnxn)) {
                return;
            }
            HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
            synchronized (hashMap) {
                Set<NIOServerCnxn> s;
                InetAddress addr = cnxn.getSocketAddress();
                if (addr != null && (s = this.ipMap.get(addr)) != null) {
                    s.remove(cnxn);
                }
            }
            this.unregisterConnection(cnxn);
        }
    }

    protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk) throws IOException {
        return new NIOServerCnxn(this.zkServer, sock, sk, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClientCnxnCount(InetAddress cl) {
        HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
        synchronized (hashMap) {
            Set<NIOServerCnxn> s = this.ipMap.get(cl);
            if (s == null) {
                return 0;
            }
            return s.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.ss.socket().isClosed()) {
            try {
                Set<SelectionKey> selected;
                this.selector.select(1000L);
                NIOServerCnxnFactory nIOServerCnxnFactory = this;
                synchronized (nIOServerCnxnFactory) {
                    selected = this.selector.selectedKeys();
                }
                ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                Collections.shuffle(selectedList);
                for (SelectionKey k : selectedList) {
                    if ((k.readyOps() & 0x10) != 0) {
                        SocketChannel sc = ((ServerSocketChannel)k.channel()).accept();
                        InetAddress ia = sc.socket().getInetAddress();
                        int cnxncount = this.getClientCnxnCount(ia);
                        if (this.maxClientCnxns > 0 && cnxncount >= this.maxClientCnxns) {
                            LOG.warn("Too many connections from " + ia + " - max is " + this.maxClientCnxns);
                            sc.close();
                            continue;
                        }
                        LOG.info("Accepted socket connection from " + sc.socket().getRemoteSocketAddress());
                        sc.configureBlocking(false);
                        SelectionKey sk = sc.register(this.selector, 1);
                        NIOServerCnxn cnxn = this.createConnection(sc, sk);
                        sk.attach(cnxn);
                        this.addCnxn(cnxn);
                        continue;
                    }
                    if ((k.readyOps() & 5) != 0) {
                        NIOServerCnxn c = (NIOServerCnxn)k.attachment();
                        c.doIO(k);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Unexpected ops in select " + k.readyOps());
                }
                selected.clear();
            }
            catch (RuntimeException e) {
                LOG.warn("Ignoring unexpected runtime exception", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception", (Throwable)e);
            }
        }
        this.closeAll();
        LOG.info("NIOServerCnxn factory exited run method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeAll() {
        HashSet cnxns;
        this.selector.wakeup();
        HashSet hashSet = this.cnxns;
        synchronized (hashSet) {
            cnxns = (HashSet)this.cnxns.clone();
        }
        for (NIOServerCnxn cnxn : cnxns) {
            try {
                cnxn.close();
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.sessionId), (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.ss.close();
            this.closeAll();
            this.thread.interrupt();
            this.thread.join();
            if (this.login != null) {
                this.login.shutdown();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Ignoring interrupted exception during shutdown", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", (Throwable)e);
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            LOG.warn("Selector closing", (Throwable)e);
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
    }

    @Override
    public synchronized void closeSession(long sessionId) {
        this.selector.wakeup();
        this.closeSessionWithoutWakeup(sessionId);
    }

    private void closeSessionWithoutWakeup(long sessionId) {
        NIOServerCnxn cnxn = (NIOServerCnxn)this.sessionMap.remove(sessionId);
        if (cnxn != null) {
            try {
                cnxn.close();
            }
            catch (Exception e) {
                LOG.warn("exception during session close", (Throwable)e);
            }
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    static {
        try {
            Selector.open().close();
        }
        catch (IOException ie) {
            LOG.error("Selector failed to open", (Throwable)ie);
        }
    }
}

