/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.spi;

import java.util.Set;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.ConfigurationException;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.shaded.com.google.inject.spi.ElementVisitor;
import org.apache.hadoop.shaded.com.google.inject.spi.InjectionPoint;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type, T instance) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.type = (TypeLiteral)Preconditions.checkNotNull(type, (Object)"type");
        this.instance = Preconditions.checkNotNull(instance, (Object)"instance");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.instance.getClass());
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }
}

