/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.GenericsUtil;

public class SerializationTestUtil {
    public static <K> K testSerialization(Configuration conf, K before) throws Exception {
        SerializationFactory factory = new SerializationFactory(conf);
        Serializer serializer = factory.getSerializer(GenericsUtil.getClass(before));
        Deserializer deserializer = factory.getDeserializer(GenericsUtil.getClass(before));
        DataOutputBuffer out = new DataOutputBuffer();
        serializer.open((OutputStream)out);
        serializer.serialize(before);
        serializer.close();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        deserializer.open((InputStream)in);
        Object after = deserializer.deserialize(null);
        deserializer.close();
        return (K)after;
    }
}

