/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicResourceConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicResourceConfiguration.class);
    @InterfaceAudience.Private
    public static final String PREFIX = "yarn.resource.dynamic.";
    @InterfaceAudience.Private
    public static final String DOT = ".";
    @InterfaceAudience.Private
    public static final String NODES = "nodes";
    @InterfaceAudience.Private
    public static final String VCORES = "vcores";
    @InterfaceAudience.Private
    public static final String MEMORY = "memory";
    @InterfaceAudience.Private
    public static final String OVERCOMMIT_TIMEOUT = "overcommittimeout";

    public DynamicResourceConfiguration() {
        this(new Configuration());
    }

    public DynamicResourceConfiguration(Configuration configuration) {
        super(configuration);
        this.addResource("dynamic-resources.xml");
    }

    public DynamicResourceConfiguration(Configuration configuration, InputStream drInputStream) {
        super(configuration);
        this.addResource(drInputStream);
    }

    private String getNodePrefix(String node) {
        String nodeName = PREFIX + node + DOT;
        return nodeName;
    }

    public int getVcoresPerNode(String node) {
        int vcoresPerNode = this.getInt(this.getNodePrefix(node) + VCORES, 8);
        return vcoresPerNode;
    }

    public void setVcoresPerNode(String node, int vcores) {
        this.setInt(this.getNodePrefix(node) + VCORES, vcores);
        LOG.debug("DRConf - setVcoresPerNode: nodePrefix=" + this.getNodePrefix(node) + ", vcores=" + vcores);
    }

    public int getMemoryPerNode(String node) {
        int memoryPerNode = this.getInt(this.getNodePrefix(node) + MEMORY, 8192);
        return memoryPerNode;
    }

    public void setMemoryPerNode(String node, int memory) {
        this.setInt(this.getNodePrefix(node) + MEMORY, memory);
        LOG.debug("DRConf - setMemoryPerNode: nodePrefix=" + this.getNodePrefix(node) + ", memory=" + memory);
    }

    public int getOverCommitTimeoutPerNode(String node) {
        int overCommitTimeoutPerNode = this.getInt(this.getNodePrefix(node) + OVERCOMMIT_TIMEOUT, -1);
        return overCommitTimeoutPerNode;
    }

    public void setOverCommitTimeoutPerNode(String node, int overCommitTimeout) {
        this.setInt(this.getNodePrefix(node) + OVERCOMMIT_TIMEOUT, overCommitTimeout);
        LOG.debug("DRConf - setOverCommitTimeoutPerNode: nodePrefix=" + this.getNodePrefix(node) + ", overCommitTimeout=" + overCommitTimeout);
    }

    public String[] getNodes() {
        String[] nodes = this.getStrings("yarn.resource.dynamic.nodes");
        return nodes;
    }

    public void setNodes(String[] nodes) {
        this.set("yarn.resource.dynamic.nodes", StringUtils.arrayToString((String[])nodes));
    }

    public Map<NodeId, ResourceOption> getNodeResourceMap() {
        String[] nodes = this.getNodes();
        HashMap<NodeId, ResourceOption> resourceOptions = new HashMap<NodeId, ResourceOption>();
        for (String node : nodes) {
            NodeId nid = NodeId.fromString((String)node);
            int vcores = this.getVcoresPerNode(node);
            int memory = this.getMemoryPerNode(node);
            int overCommitTimeout = this.getOverCommitTimeoutPerNode(node);
            Resource resource = Resources.createResource((int)memory, (int)vcores);
            ResourceOption resourceOption = ResourceOption.newInstance((Resource)resource, (int)overCommitTimeout);
            resourceOptions.put(nid, resourceOption);
        }
        return resourceOptions;
    }
}

