/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceAllocationRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public final class ReservationSystemUtil {
    private ReservationSystemUtil() {
    }

    public static Resource toResource(ReservationRequest request) {
        Resource resource = Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers());
        return resource;
    }

    public static Map<ReservationInterval, Resource> toResources(Map<ReservationInterval, ReservationRequest> allocations) {
        HashMap<ReservationInterval, Resource> resources = new HashMap<ReservationInterval, Resource>();
        for (Map.Entry<ReservationInterval, ReservationRequest> entry : allocations.entrySet()) {
            resources.put(entry.getKey(), ReservationSystemUtil.toResource(entry.getValue()));
        }
        return resources;
    }

    public static YarnProtos.ReservationAllocationStateProto buildStateProto(ReservationAllocation allocation) {
        YarnProtos.ReservationAllocationStateProto.Builder builder = YarnProtos.ReservationAllocationStateProto.newBuilder();
        builder.setAcceptanceTime(allocation.getAcceptanceTime());
        builder.setContainsGangs(allocation.containsGangs());
        builder.setStartTime(allocation.getStartTime());
        builder.setEndTime(allocation.getEndTime());
        builder.setUser(allocation.getUser());
        YarnProtos.ReservationDefinitionProto definitionProto = ReservationSystemUtil.convertToProtoFormat(allocation.getReservationDefinition());
        builder.setReservationDefinition(definitionProto);
        for (Map.Entry<ReservationInterval, Resource> entry : allocation.getAllocationRequests().entrySet()) {
            YarnProtos.ResourceAllocationRequestProto p = YarnProtos.ResourceAllocationRequestProto.newBuilder().setStartTime(entry.getKey().getStartTime()).setEndTime(entry.getKey().getEndTime()).setResource(ReservationSystemUtil.convertToProtoFormat(entry.getValue())).build();
            builder.addAllocationRequests(p);
        }
        YarnProtos.ReservationAllocationStateProto allocationProto = builder.build();
        return allocationProto;
    }

    private static YarnProtos.ReservationDefinitionProto convertToProtoFormat(ReservationDefinition reservationDefinition) {
        return ((ReservationDefinitionPBImpl)reservationDefinition).getProto();
    }

    public static YarnProtos.ResourceProto convertToProtoFormat(Resource e) {
        return YarnProtos.ResourceProto.newBuilder().setMemory(e.getMemorySize()).setVirtualCores(e.getVirtualCores()).build();
    }

    public static Map<ReservationInterval, Resource> toAllocations(List<YarnProtos.ResourceAllocationRequestProto> allocationRequestsList) {
        HashMap<ReservationInterval, Resource> allocations = new HashMap<ReservationInterval, Resource>();
        for (YarnProtos.ResourceAllocationRequestProto proto : allocationRequestsList) {
            allocations.put(new ReservationInterval(proto.getStartTime(), proto.getEndTime()), (Resource)ReservationSystemUtil.convertFromProtoFormat(proto.getResource()));
        }
        return allocations;
    }

    private static ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    public static ReservationDefinitionPBImpl convertFromProtoFormat(YarnProtos.ReservationDefinitionProto r) {
        return new ReservationDefinitionPBImpl(r);
    }

    public static ReservationIdPBImpl convertFromProtoFormat(YarnProtos.ReservationIdProto r) {
        return new ReservationIdPBImpl(r);
    }

    public static ReservationId toReservationId(YarnProtos.ReservationIdProto reservationId) {
        return new ReservationIdPBImpl(reservationId);
    }

    public static InMemoryReservationAllocation toInMemoryAllocation(String planName, ReservationId reservationId, YarnProtos.ReservationAllocationStateProto allocationState, Resource minAlloc, ResourceCalculator planResourceCalculator) {
        ReservationDefinitionPBImpl definition = ReservationSystemUtil.convertFromProtoFormat(allocationState.getReservationDefinition());
        Map<ReservationInterval, Resource> allocations = ReservationSystemUtil.toAllocations(allocationState.getAllocationRequestsList());
        InMemoryReservationAllocation allocation = new InMemoryReservationAllocation(reservationId, (ReservationDefinition)definition, allocationState.getUser(), planName, allocationState.getStartTime(), allocationState.getEndTime(), allocations, planResourceCalculator, minAlloc, allocationState.getContainsGangs());
        return allocation;
    }

    public static List<ReservationAllocationState> convertAllocationsToReservationInfo(Set<ReservationAllocation> res, boolean includeResourceAllocations) {
        ArrayList<ReservationAllocationState> reservationInfo = new ArrayList<ReservationAllocationState>();
        for (ReservationAllocation allocation : res) {
            ArrayList<ResourceAllocationRequest> allocations = new ArrayList<ResourceAllocationRequest>();
            if (includeResourceAllocations) {
                Map<ReservationInterval, Resource> requests = allocation.getAllocationRequests();
                for (Map.Entry<ReservationInterval, Resource> request : requests.entrySet()) {
                    ReservationInterval interval = request.getKey();
                    allocations.add(ResourceAllocationRequest.newInstance((long)interval.getStartTime(), (long)interval.getEndTime(), (Resource)request.getValue()));
                }
            }
            reservationInfo.add(ReservationAllocationState.newInstance((long)allocation.getAcceptanceTime(), (String)allocation.getUser(), allocations, (ReservationId)allocation.getReservationId(), (ReservationDefinition)allocation.getReservationDefinition()));
        }
        return reservationInfo;
    }
}

