/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.preprocessor;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.ContextProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.NodeLabelProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.QueueProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.TagAddProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionContextPreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SubmissionContextPreProcessor.class);
    private static final String DEFAULT_COMMANDS = "*";
    private static final int INITIAL_DELAY = 1000;
    private String hostsFilePath;
    private volatile long lastModified = -1L;
    private volatile Map<String, Map<ContextProp, String>> hostCommands = new HashMap<String, Map<ContextProp, String>>();
    private ScheduledExecutorService executorService;

    public void start(Configuration conf) {
        this.hostsFilePath = conf.get("yarn.resourcemanager.submission-preprocessor.file-path", "");
        int refreshPeriod = conf.getInt("yarn.resourcemanager.submission-preprocessor.file-refresh-interval-ms", 0);
        LOG.info("Submission Context Preprocessor enabled: file=[{}], interval=[{}]", (Object)this.hostsFilePath, (Object)refreshPeriod);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        Runnable refreshConf = new Runnable(){

            @Override
            public void run() {
                try {
                    SubmissionContextPreProcessor.this.refresh();
                }
                catch (Exception ex) {
                    LOG.error("Error while refreshing Submission PreProcessor file [{}]", (Object)SubmissionContextPreProcessor.this.hostsFilePath, (Object)ex);
                }
            }
        };
        if (refreshPeriod > 0) {
            this.executorService.scheduleAtFixedRate(refreshConf, 1000L, refreshPeriod, TimeUnit.MILLISECONDS);
        } else {
            this.executorService.schedule(refreshConf, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public void preProcess(String host, ApplicationId applicationId, ApplicationSubmissionContext submissionContext) {
        Map<ContextProp, String> cMap = this.hostCommands.get(host);
        if (cMap == null) {
            for (Map.Entry<Object, Object> entry : this.hostCommands.entrySet()) {
                if (((String)entry.getKey()).equals(DEFAULT_COMMANDS)) continue;
                try {
                    Pattern p = Pattern.compile((String)entry.getKey());
                    Matcher m = p.matcher(host);
                    if (!m.find()) continue;
                    cMap = this.hostCommands.get(entry.getKey());
                }
                catch (PatternSyntaxException exception) {
                    LOG.warn("Invalid regex pattern: " + (String)entry.getKey());
                }
            }
        }
        if (cMap == null) {
            cMap = this.hostCommands.get(DEFAULT_COMMANDS);
        }
        if (cMap != null) {
            for (Map.Entry<Object, Object> entry : cMap.entrySet()) {
                ((ContextProp)((Object)entry.getKey())).cp.process(host, (String)entry.getValue(), applicationId, submissionContext);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public void refresh() throws Exception {
        BufferedReader reader;
        FileInputStream fileInputStream;
        block12: {
            if (null == this.hostsFilePath || this.hostsFilePath.isEmpty()) {
                LOG.warn("Host list file path [{}] is empty or does not exist !!", (Object)this.hostsFilePath);
                return;
            }
            File hostFile = new File(this.hostsFilePath);
            if (!hostFile.exists() || !hostFile.isFile()) {
                LOG.warn("Host list file [{}] does not exist or is not a file !!", (Object)hostFile);
                return;
            }
            if (hostFile.lastModified() <= this.lastModified) {
                LOG.debug("Host list file [{}] has not been modified from last refresh", (Object)hostFile);
                return;
            }
            fileInputStream = new FileInputStream(hostFile);
            reader = null;
            HashMap<String, Map<ContextProp, String>> tempHostCommands = new HashMap<String, Map<ContextProp, String>>();
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    String host;
                    String[] commands = line.split("[ \t\n\f\r]+");
                    if (commands == null || commands.length <= 1 || (host = commands[0].trim()).startsWith("#")) continue;
                    HashMap<ContextProp, String> cMap = null;
                    for (int i = 1; i < commands.length; ++i) {
                        String[] cSplit = commands[i].split("=");
                        if (cSplit == null || cSplit.length != 2) {
                            LOG.error("No commands found for line [{}]", (Object)commands[i]);
                            continue;
                        }
                        if (cMap == null) {
                            cMap = new HashMap<ContextProp, String>();
                        }
                        cMap.put(ContextProp.valueOf(cSplit[0]), cSplit[1]);
                    }
                    if (cMap == null || cMap.size() <= 0) continue;
                    tempHostCommands.put(host, (Map<ContextProp, String>)cMap);
                    LOG.info("Following commands registered for host[{}] : {}", (Object)host, (Object)cMap);
                }
                this.lastModified = hostFile.lastModified();
                if (tempHostCommands == null || tempHostCommands.size() <= 0) break block12;
                this.hostCommands = tempHostCommands;
            }
            catch (Exception ex) {
                try {
                    tempHostCommands = null;
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (tempHostCommands != null && tempHostCommands.size() > 0) {
                        this.hostCommands = tempHostCommands;
                    }
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader, fileInputStream});
                    throw throwable;
                }
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader, fileInputStream});
        return;
    }

    static enum ContextProp {
        NL(new NodeLabelProcessor()),
        Q(new QueueProcessor()),
        TA(new TagAddProcessor());

        private ContextProcessor cp;

        private ContextProp(ContextProcessor cp) {
            this.cp = cp;
        }
    }
}

