/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreHeartbeat;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationStateStoreService
extends AbstractService
implements FederationStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreService.class);
    private Configuration config;
    private ScheduledExecutorService scheduledExecutorService;
    private FederationStateStoreHeartbeat stateStoreHeartbeat;
    private FederationStateStore stateStoreClient = null;
    private SubClusterId subClusterId;
    private long heartbeatInterval;
    private RMContext rmContext;

    public FederationStateStoreService(RMContext rmContext) {
        super(FederationStateStoreService.class.getName());
        LOG.info("FederationStateStoreService initialized");
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.config = conf;
        RetryPolicy retryPolicy = FederationStateStoreFacade.createRetryPolicy(conf);
        this.stateStoreClient = (FederationStateStore)FederationStateStoreFacade.createRetryInstance(conf, "yarn.federation.state-store.class", "org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore", FederationStateStore.class, retryPolicy);
        this.stateStoreClient.init(conf);
        LOG.info("Initialized state store client class");
        this.subClusterId = SubClusterId.newInstance(YarnConfiguration.getClusterId((Configuration)conf));
        this.heartbeatInterval = conf.getLong("yarn.federation.state-store.heartbeat-interval-secs", 300L);
        if (this.heartbeatInterval <= 0L) {
            this.heartbeatInterval = 300L;
        }
        LOG.info("Initialized federation membership service.");
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.registerAndInitializeHeartbeat();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        Exception ex = null;
        try {
            if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isShutdown()) {
                this.scheduledExecutorService.shutdown();
                LOG.info("Stopped federation membership heartbeat");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to shutdown ScheduledExecutorService", (Throwable)e);
            ex = e;
        }
        if (this.stateStoreClient != null) {
            try {
                this.deregisterSubCluster(SubClusterDeregisterRequest.newInstance(this.subClusterId, SubClusterState.SC_UNREGISTERED));
            }
            finally {
                this.stateStoreClient.close();
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private String getServiceAddress(InetSocketAddress address) {
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)address);
        return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
    }

    private void registerAndInitializeHeartbeat() {
        String clientRMAddress = this.getServiceAddress(this.rmContext.getClientRMService().getBindAddress());
        String amRMAddress = this.getServiceAddress(this.rmContext.getApplicationMasterService().getBindAddress());
        String rmAdminAddress = this.getServiceAddress(this.config.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033));
        String webAppAddress = this.getServiceAddress(NetUtils.createSocketAddr((String)WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.config)));
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance(this.subClusterId, amRMAddress, clientRMAddress, rmAdminAddress, webAppAddress, SubClusterState.SC_NEW, ResourceManager.getClusterTimeStamp(), "");
        try {
            this.registerSubCluster(SubClusterRegisterRequest.newInstance(subClusterInfo));
            LOG.info("Successfully registered for federation subcluster: {}", (Object)subClusterInfo);
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Failed to register Federation membership with the StateStore", (Throwable)e);
        }
        this.stateStoreHeartbeat = new FederationStateStoreHeartbeat(this.subClusterId, this.stateStoreClient, this.rmContext.getScheduler());
        this.scheduledExecutorService = HadoopExecutors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleWithFixedDelay(this.stateStoreHeartbeat, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.SECONDS);
        LOG.info("Started federation membership heartbeat with interval: {}", (Object)this.heartbeatInterval);
    }

    @VisibleForTesting
    public FederationStateStore getStateStoreClient() {
        return this.stateStoreClient;
    }

    @VisibleForTesting
    public FederationStateStoreHeartbeat getStateStoreHeartbeatThread() {
        return this.stateStoreHeartbeat;
    }

    @Override
    public Version getCurrentVersion() {
        return this.stateStoreClient.getCurrentVersion();
    }

    @Override
    public Version loadVersion() {
        return this.stateStoreClient.getCurrentVersion();
    }

    @Override
    public GetSubClusterPolicyConfigurationResponse getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest request) throws YarnException {
        return this.stateStoreClient.getPolicyConfiguration(request);
    }

    @Override
    public SetSubClusterPolicyConfigurationResponse setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest request) throws YarnException {
        return this.stateStoreClient.setPolicyConfiguration(request);
    }

    @Override
    public GetSubClusterPoliciesConfigurationsResponse getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        return this.stateStoreClient.getPoliciesConfigurations(request);
    }

    @Override
    public SubClusterRegisterResponse registerSubCluster(SubClusterRegisterRequest registerSubClusterRequest) throws YarnException {
        return this.stateStoreClient.registerSubCluster(registerSubClusterRequest);
    }

    @Override
    public SubClusterDeregisterResponse deregisterSubCluster(SubClusterDeregisterRequest subClusterDeregisterRequest) throws YarnException {
        return this.stateStoreClient.deregisterSubCluster(subClusterDeregisterRequest);
    }

    @Override
    public SubClusterHeartbeatResponse subClusterHeartbeat(SubClusterHeartbeatRequest subClusterHeartbeatRequest) throws YarnException {
        return this.stateStoreClient.subClusterHeartbeat(subClusterHeartbeatRequest);
    }

    @Override
    public GetSubClusterInfoResponse getSubCluster(GetSubClusterInfoRequest subClusterRequest) throws YarnException {
        return this.stateStoreClient.getSubCluster(subClusterRequest);
    }

    @Override
    public GetSubClustersInfoResponse getSubClusters(GetSubClustersInfoRequest subClustersRequest) throws YarnException {
        return this.stateStoreClient.getSubClusters(subClustersRequest);
    }

    @Override
    public AddApplicationHomeSubClusterResponse addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest request) throws YarnException {
        return this.stateStoreClient.addApplicationHomeSubCluster(request);
    }

    @Override
    public UpdateApplicationHomeSubClusterResponse updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest request) throws YarnException {
        return this.stateStoreClient.updateApplicationHomeSubCluster(request);
    }

    @Override
    public GetApplicationHomeSubClusterResponse getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest request) throws YarnException {
        return this.stateStoreClient.getApplicationHomeSubCluster(request);
    }

    @Override
    public GetApplicationsHomeSubClusterResponse getApplicationsHomeSubCluster(GetApplicationsHomeSubClusterRequest request) throws YarnException {
        return this.stateStoreClient.getApplicationsHomeSubCluster(request);
    }

    @Override
    public DeleteApplicationHomeSubClusterResponse deleteApplicationHomeSubCluster(DeleteApplicationHomeSubClusterRequest request) throws YarnException {
        return this.stateStoreClient.deleteApplicationHomeSubCluster(request);
    }
}

