/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.util.AlternateDocBase;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.util.MappingData;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.Ascii;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.Constants;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.MessageBytes;

public class Mapper {
    private static final Logger logger = Grizzly.logger(Mapper.class);
    private static final String DEFAULT_SERVLET = System.getProperty("org.apache.hadoop.shaded.org.glassfish.grizzly.servlet.defaultServlet", "default");
    private static final String JSP_SERVLET = System.getProperty("org.apache.hadoop.shaded.org.glassfish.grizzly.servlet.jspServlet", "jsp");
    private static final CharChunk SLASH = new CharChunk();
    private static boolean allowReplacement = false;
    protected Host[] hosts = new Host[0];
    protected String defaultHostName = null;
    protected Context context = new Context();
    private Map<String, String> defaultContextPathsMap = new HashMap<String, String>();
    private int port = 0;

    public static void setAllowReplacement(boolean ar) {
        allowReplacement = ar;
    }

    public static boolean allowReplacement() {
        return allowReplacement;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        MapElement[] newHosts = new Host[this.hosts.length + 1];
        Host newHost = new Host();
        ContextList contextList = new ContextList();
        Context[] defaultContexts = new Context[1];
        String[] defaultContextPaths = new String[1];
        newHost.name = name;
        newHost.contextList = contextList;
        newHost.object = host;
        newHost.defaultContexts = defaultContexts;
        newHost.defaultContextPaths = defaultContextPaths;
        Host oldElem = (Host)Mapper.insertMapIgnoreCase(this.hosts, newHosts, newHost);
        if (oldElem == null) {
            this.hosts = newHosts;
        } else if (allowReplacement) {
            oldElem.object = host;
            contextList = oldElem.contextList;
        }
        for (String alias : aliases) {
            newHosts = new Host[this.hosts.length + 1];
            newHost = new Host();
            newHost.name = alias;
            newHost.contextList = contextList;
            newHost.defaultContexts = defaultContexts;
            newHost.defaultContextPaths = defaultContextPaths;
            newHost.object = host;
            if (Mapper.insertMapIgnoreCase(this.hosts, newHosts, newHost) != null) continue;
            this.hosts = newHosts;
        }
        String defaultContextPath = this.defaultContextPathsMap.get(name);
        if (defaultContextPath != null) {
            newHost.defaultContextPaths[0] = defaultContextPath;
        }
    }

    public synchronized void removeHost(String name) {
        int pos = Mapper.findIgnoreCase((MapElement[])this.hosts, name);
        if (pos < 0) {
            return;
        }
        Object host = this.hosts[pos].object;
        MapElement[] newHosts = new Host[this.hosts.length - 1];
        if (Mapper.removeMapIgnoreCase(this.hosts, newHosts, name)) {
            this.hosts = newHosts;
        }
        for (MapElement newHost : newHosts) {
            MapElement[] newHosts2;
            if (((Host)newHost).object != host || !Mapper.removeMapIgnoreCase(this.hosts, newHosts2 = new Host[this.hosts.length - 1], ((Host)newHost).name)) continue;
            this.hosts = newHosts2;
        }
        this.defaultContextPathsMap.remove(name);
    }

    public String[] getHosts() {
        String[] hostN = new String[this.hosts.length];
        for (int i = 0; i < this.hosts.length; ++i) {
            hostN[i] = this.hosts[i].name;
        }
        return hostN;
    }

    public void setContext(String path, String[] welcomeResources, javax.naming.Context resources) {
        this.context.name = path;
        this.context.welcomeResources = welcomeResources;
        this.context.resources = resources;
    }

    public void addContext(String hostName, String path, Object context, String[] welcomeResources, javax.naming.Context resources) {
        this.addContext(hostName, path, context, welcomeResources, resources, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(String hostName, String path, Object context, String[] welcomeResources, javax.naming.Context resources, List<AlternateDocBase> alternateDocBases) {
        MapElement[] newHosts = this.hosts;
        int pos = Mapper.findIgnoreCase(newHosts, hostName);
        if (pos < 0) {
            this.addHost(hostName, new String[0], "");
            newHosts = this.hosts;
            pos = Mapper.findIgnoreCase(newHosts, hostName);
        }
        if (pos < 0) {
            logger.log(Level.FINE, "No host found: {0} for Mapper listening on port: {1}", new Object[]{hostName, this.port});
            return;
        }
        MapElement host = newHosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            int slashCount = Mapper.slashCount(path);
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (slashCount > ((Host)host).contextList.nesting) {
                    ((Host)host).contextList.nesting = slashCount;
                }
                MapElement[] newContexts = new Context[contexts.length + 1];
                Context newContext = new Context();
                newContext.name = path;
                newContext.object = context;
                newContext.welcomeResources = welcomeResources;
                newContext.resources = resources;
                newContext.alternateDocBases = alternateDocBases;
                Context oldElem = (Context)Mapper.insertMap(contexts, newContexts, newContext);
                if (oldElem == null) {
                    ((Host)host).contextList.contexts = newContexts;
                    if (path.equals(((Host)host).defaultContextPaths[0])) {
                        ((Host)host).defaultContexts[0] = newContext;
                    }
                } else if (allowReplacement) {
                    oldElem.object = context;
                    oldElem.welcomeResources = welcomeResources;
                    oldElem.resources = resources;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(String hostName, String path) {
        MapElement[] newHosts = this.hosts;
        int pos = Mapper.findIgnoreCase(newHosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = newHosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (contexts.length == 0) {
                    return;
                }
                MapElement[] newContexts = new Context[contexts.length - 1];
                if (Mapper.removeMap(contexts, newContexts, path)) {
                    ((Host)host).contextList.contexts = newContexts;
                    ((Host)host).contextList.nesting = 0;
                    for (MapElement newContext : newContexts) {
                        int slashCount = Mapper.slashCount(((Context)newContext).name);
                        if (slashCount <= ((Host)host).contextList.nesting) continue;
                        ((Host)host).contextList.nesting = slashCount;
                    }
                }
            }
        }
    }

    public String[] getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Host host : this.hosts) {
            for (int j = 0; j < host.contextList.contexts.length; ++j) {
                String cname = host.contextList.contexts[j].name;
                list.add("//" + host.name + (cname.startsWith("/") ? cname : "/"));
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper) {
        this.addWrapper(hostName, contextPath, path, wrapper, false);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard) {
        this.addWrapper(hostName, contextPath, path, wrapper, jspWildCard, null, false);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard, String servletName, boolean isEmptyPathSpecial) {
        MapElement[] newHosts = this.hosts;
        int pos = Mapper.findIgnoreCase(newHosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = newHosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                logger.log(Level.SEVERE, "No context found: {0}", contextPath);
                return;
            }
            MapElement ctx = contexts[pos2];
            if (((Context)ctx).name.equals(contextPath)) {
                this.addWrapper((Context)ctx, path, wrapper, jspWildCard, servletName, isEmptyPathSpecial);
            }
        }
    }

    public void addWrapper(String path, Object wrapper) {
        this.addWrapper(this.context, path, wrapper);
    }

    public void addWrapper(String path, Object wrapper, boolean jspWildCard, boolean isEmptyPathSpecial) {
        this.addWrapper(this.context, path, wrapper, jspWildCard, isEmptyPathSpecial);
    }

    protected void addWrapper(Context context, String path, Object wrapper) {
        this.addWrapper(context, path, wrapper, false, false);
    }

    protected void addWrapper(Context context, String path, Object wrapper, boolean jspWildCard, boolean isEmptyPathSpecial) {
        this.addWrapper(context, path, wrapper, jspWildCard, null, isEmptyPathSpecial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(Context context, String path, Object wrapper, boolean jspWildCard, String servletName, boolean isEmptyPathSpecial) {
        Context context2 = context;
        synchronized (context2) {
            Wrapper newWrapper = new Wrapper();
            newWrapper.object = wrapper;
            newWrapper.jspWildCard = jspWildCard;
            newWrapper.servletName = servletName;
            if (path.endsWith("/*")) {
                newWrapper.name = path.substring(0, path.length() - 2);
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                if (oldElem == null) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                } else if (allowReplacement) {
                    oldElem.object = wrapper;
                    oldElem.jspWildCard = jspWildCard;
                }
            } else if (path.startsWith("*.")) {
                newWrapper.name = path.substring(2);
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                if (oldElem == null) {
                    context.extensionWrappers = newWrappers;
                } else if (allowReplacement) {
                    oldElem.object = wrapper;
                    oldElem.jspWildCard = jspWildCard;
                }
            } else {
                boolean isSlashPath = "/".equals(path);
                if (isSlashPath) {
                    newWrapper.name = "";
                    context.defaultWrapper = newWrapper;
                }
                if (!isSlashPath || !DEFAULT_SERVLET.equals(servletName)) {
                    newWrapper.name = path;
                    if (isEmptyPathSpecial && path.length() == 0) {
                        context.emptyPathWrapper = newWrapper;
                    } else {
                        MapElement[] oldWrappers = context.exactWrappers;
                        MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                        Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                        if (oldElem == null) {
                            context.exactWrappers = newWrappers;
                        } else if (allowReplacement) {
                            oldElem.object = wrapper;
                            oldElem.jspWildCard = jspWildCard;
                        }
                    }
                }
            }
        }
    }

    public void removeWrapper(String path) {
        this.removeWrapper(this.context, path);
    }

    public void removeWrapper(String hostName, String contextPath, String path) {
        MapElement[] newHosts = this.hosts;
        int pos = Mapper.findIgnoreCase(newHosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = newHosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                return;
            }
            MapElement ctx = contexts[pos2];
            if (((Context)ctx).name.equals(contextPath)) {
                this.removeWrapper((Context)ctx, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(Context context, String path) {
        Context context2 = context;
        synchronized (context2) {
            if (path.endsWith("/*")) {
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(0, path.length() - 2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.nesting = 0;
                    for (MapElement newWrapper : newWrappers) {
                        int slashCount = Mapper.slashCount(((Wrapper)newWrapper).name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path.startsWith("*.")) {
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if ("/".equals(path)) {
                context.defaultWrapper = null;
            } else {
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, path)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public String getWrappersString(String host, String context) {
        String[] names = this.getWrapperNames(host, context);
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name).append(":");
        }
        return sb.toString();
    }

    public String[] getWrapperNames(String host, String context) {
        ArrayList<String> list = new ArrayList<String>();
        if (host == null) {
            host = "";
        }
        if (context == null) {
            context = "";
        }
        for (Host host1 : this.hosts) {
            if (!host.equals(host1.name)) continue;
            for (int j = 0; j < host1.contextList.contexts.length; ++j) {
                int k;
                if (!context.equals(host1.contextList.contexts[j].name)) continue;
                Context ctx = host1.contextList.contexts[j];
                list.add(ctx.defaultWrapper.path);
                for (k = 0; k < ctx.exactWrappers.length; ++k) {
                    list.add(ctx.exactWrappers[k].path);
                }
                for (k = 0; k < ctx.wildcardWrappers.length; ++k) {
                    list.add(ctx.wildcardWrappers[k].path + "*");
                }
                for (k = 0; k < ctx.extensionWrappers.length; ++k) {
                    list.add("*." + ctx.extensionWrappers[k].path);
                }
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void setDefaultContextPath(String hostName, String defaultContextPath) throws Exception {
        int pos;
        if (defaultContextPath != null) {
            this.defaultContextPathsMap.put(hostName, defaultContextPath);
        }
        if ((pos = Mapper.findIgnoreCase((MapElement[])this.hosts, hostName)) < 0) {
            return;
        }
        this.hosts[pos].defaultContextPaths[0] = defaultContextPath;
        if (defaultContextPath != null) {
            this.addDefaultContext(this.hosts[pos], defaultContextPath);
        } else {
            this.hosts[pos].defaultContexts[0] = null;
            this.defaultContextPathsMap.remove(hostName);
        }
    }

    private void addDefaultContext(Host host, String defaultContextPath) throws Exception {
        boolean defaultContextFound = false;
        Context[] contexts = host.contextList.contexts;
        if (contexts != null) {
            for (Context context1 : contexts) {
                if (!context1.name.equals(defaultContextPath)) continue;
                host.defaultContexts[0] = context1;
                defaultContextFound = true;
                break;
            }
        }
        if (!defaultContextFound) {
            throw new Exception("No context matching " + defaultContextPath + " deployed on virtual server " + host.name);
        }
    }

    public void mapUriWithSemicolon(DataChunk serverName, DataChunk decodedURI, MappingData mappingData, int semicolonPos) throws Exception {
        CharChunk charChunk = decodedURI.getCharChunk();
        int oldEnd = charChunk.getEnd();
        if (semicolonPos == 0) {
            semicolonPos = decodedURI.indexOf(';', 0);
        }
        DataChunk localDecodedURI = decodedURI;
        if (semicolonPos >= 0) {
            charChunk.setEnd(semicolonPos);
            localDecodedURI = mappingData.tmpMapperDC;
            localDecodedURI.duplicate(decodedURI);
        }
        this.map(serverName, localDecodedURI, mappingData);
        charChunk.setEnd(oldEnd);
    }

    public void map(DataChunk host, DataChunk uri, MappingData mappingData) throws Exception {
        if (host.isNull()) {
            host.getCharChunk().append(this.defaultHostName);
        }
        host.toChars(Constants.DEFAULT_HTTP_CHARSET);
        uri.toChars(null);
        this.internalMap(host.getCharChunk(), uri.getCharChunk(), mappingData);
    }

    public void map(MessageBytes uri, MappingData mappingData) throws Exception {
        uri.toChars();
        CharChunk uricc = uri.getCharChunk();
        uricc.setLimit(-1);
        this.internalMapWrapper(this.context, uricc, mappingData);
    }

    private void internalMap(CharChunk host, CharChunk uri, MappingData mappingData) throws Exception {
        int pos;
        uri.setLimit(-1);
        MapElement[] contexts = null;
        Context ctx = null;
        int nesting = 0;
        int hostPos = -1;
        if (mappingData.host == null) {
            MapElement[] newHosts = this.hosts;
            pos = Mapper.findIgnoreCase(newHosts, host);
            if (pos != -1 && host.equalsIgnoreCase(((Host)newHosts[pos]).name)) {
                mappingData.host = ((Host)newHosts[pos]).object;
                hostPos = pos;
                contexts = ((Host)newHosts[pos]).contextList.contexts;
                nesting = ((Host)newHosts[pos]).contextList.nesting;
            } else {
                if (this.defaultHostName == null) {
                    return;
                }
                pos = Mapper.findIgnoreCase(newHosts, this.defaultHostName);
                if (pos != -1 && this.defaultHostName.equalsIgnoreCase(((Host)newHosts[pos]).name)) {
                    mappingData.host = ((Host)newHosts[pos]).object;
                    hostPos = pos;
                    contexts = ((Host)newHosts[pos]).contextList.contexts;
                    nesting = ((Host)newHosts[pos]).contextList.nesting;
                } else {
                    return;
                }
            }
        }
        if (mappingData.context == null) {
            boolean found = false;
            pos = Mapper.find(contexts, uri);
            if (pos == -1) {
                if (this.hosts[hostPos].defaultContexts[0] == null) {
                    return;
                }
                ctx = this.hosts[hostPos].defaultContexts[0];
                mappingData.context = ctx.object;
                mappingData.contextPath.setString(ctx.name);
                found = true;
                mappingData.isDefaultContext = true;
            }
            if (!found) {
                int lastSlash = -1;
                int uriEnd = uri.getEnd();
                while (pos >= 0) {
                    if (uri.startsWith(contexts[pos].name)) {
                        int length = contexts[pos].name.length();
                        if (uri.getLength() == length) {
                            found = true;
                            break;
                        }
                        if (uri.startsWithIgnoreCase("/", length)) {
                            found = true;
                            break;
                        }
                    }
                    lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, nesting + 1) : Mapper.lastSlash(uri);
                    uri.setEnd(lastSlash);
                    pos = Mapper.find(contexts, uri);
                }
                uri.setEnd(uriEnd);
                if (!found) {
                    if ("".equals(contexts[0].name)) {
                        ctx = contexts[0];
                    } else if (this.hosts[hostPos].defaultContexts[0] != null) {
                        ctx = this.hosts[hostPos].defaultContexts[0];
                        mappingData.isDefaultContext = true;
                    }
                } else {
                    ctx = contexts[pos];
                }
                if (ctx != null) {
                    mappingData.context = ctx.object;
                    mappingData.contextPath.setString(ctx.name);
                }
            }
        }
        if (ctx != null && mappingData.wrapper == null) {
            this.internalMapWrapper(ctx, uri, mappingData);
        }
    }

    private void internalMapWrapper(Context context, CharChunk path, MappingData mappingData) throws Exception {
        int servletPath;
        int pathOffset = path.getStart();
        int pathEnd = path.getEnd();
        boolean noServletPath = false;
        if (mappingData.isDefaultContext) {
            servletPath = pathOffset;
        } else {
            int length = context.name.length();
            if (length != pathEnd - pathOffset) {
                servletPath = pathOffset + length;
            } else {
                noServletPath = true;
                path.append('/');
                pathOffset = path.getStart();
                pathEnd = path.getEnd();
                servletPath = pathOffset + length;
            }
        }
        path.setStart(servletPath);
        if (context.emptyPathWrapper != null && path.equals(SLASH)) {
            mappingData.wrapper = context.emptyPathWrapper.object;
            mappingData.requestPath.setString("");
            mappingData.wrapperPath.setString("");
            mappingData.pathInfo.setString("/");
        }
        Wrapper[] exactWrappers = context.exactWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapExactWrapper(exactWrappers, path, mappingData);
        }
        boolean checkJspWelcomeFiles = false;
        Wrapper[] wildcardWrappers = context.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                char[] buf = path.getBuffer();
                if (buf[pathEnd - 1] == '/') {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setChars(buf, path.getStart(), path.getEnd());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (noServletPath) {
            boolean redirect;
            boolean bl = redirect = mappingData.wrapper == null;
            if (!redirect) {
                String wpath = mappingData.wrapperPath.toString();
                boolean bl2 = redirect = wpath != null && wpath.length() == 0;
            }
            if (redirect) {
                mappingData.redirectPath.setChars(path.getBuffer(), pathOffset, pathEnd);
                path.setEnd(pathEnd - 1);
                return;
            }
        }
        Wrapper[] extensionWrappers = context.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
        }
        if (mappingData.wrapper == null) {
            boolean checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles && pathEnd > 0) {
                char[] buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                int i;
                for (i = 0; i < context.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setStart(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(context.welcomeResources[i], 0, context.welcomeResources[i].length());
                    path.setStart(servletPath);
                    if (mappingData.wrapper != null || context.resources == null) continue;
                    Object file = null;
                    String pathStr = path.toString();
                    if (context.alternateDocBases == null || context.alternateDocBases.isEmpty()) {
                        try {
                            file = context.resources.lookup(pathStr);
                        }
                        catch (NamingException nex) {}
                    } else {
                        AlternateDocBase match = AlternateDocBase.findMatch(pathStr, context.alternateDocBases);
                        if (match != null) {
                            try {
                                file = match.getResources().lookup(pathStr);
                            }
                            catch (NamingException nex) {}
                        } else {
                            try {
                                file = context.resources.lookup(pathStr);
                            }
                            catch (NamingException nex) {
                                // empty catch block
                            }
                        }
                    }
                    if (file == null || file instanceof DirContext) continue;
                    this.internalMapExactWrapper(exactWrappers, path, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
                    }
                    if (mappingData.wrapper == null) {
                        this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
                    }
                    if (mappingData.wrapper != null || context.defaultWrapper == null) continue;
                    mappingData.wrapper = context.defaultWrapper.object;
                    mappingData.servletName = context.defaultWrapper.servletName;
                    mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
                    mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
                if (mappingData.wrapper == null) {
                    for (i = 0; i < context.welcomeResources.length && mappingData.wrapper == null; ++i) {
                        path.setStart(pathOffset);
                        path.setEnd(pathEnd);
                        path.append(context.welcomeResources[i], 0, context.welcomeResources[i].length());
                        path.setStart(servletPath);
                        this.internalMapExactWrapper(exactWrappers, path, mappingData);
                        if (mappingData.wrapper == null) {
                            this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
                        }
                        if (mappingData.wrapper == null) {
                            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
                        }
                        if (mappingData.wrapper == null || !JSP_SERVLET.equals(mappingData.servletName)) continue;
                        mappingData.wrapper = null;
                    }
                }
                path.setStart(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (context.defaultWrapper != null) {
                mappingData.wrapper = context.defaultWrapper.object;
                mappingData.servletName = context.defaultWrapper.servletName;
                mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
                mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
            }
            char[] buf = path.getBuffer();
            if (context.resources != null && pathEnd > 0 && buf[pathEnd - 1] != '/') {
                Object file = null;
                String pathStr = path.toString();
                if (context.alternateDocBases == null || context.alternateDocBases.isEmpty()) {
                    try {
                        file = context.resources.lookup(pathStr);
                    }
                    catch (NamingException nex) {}
                } else {
                    AlternateDocBase match = AlternateDocBase.findMatch(pathStr, context.alternateDocBases);
                    if (match != null) {
                        try {
                            file = match.getResources().lookup(pathStr);
                        }
                        catch (NamingException nex) {}
                    } else {
                        try {
                            file = context.resources.lookup(pathStr);
                        }
                        catch (NamingException nex) {
                            // empty catch block
                        }
                    }
                }
                if (file != null && file instanceof DirContext) {
                    path.setStart(pathOffset);
                    path.append('/');
                    mappingData.redirectPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
                } else {
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
            }
        }
        path.setStart(pathOffset);
        path.setEnd(pathEnd);
    }

    private void internalMapExactWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData) {
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1 && path.equals(wrappers[pos].name)) {
            mappingData.requestPath.setString(wrappers[pos].name);
            mappingData.wrapperPath.setString(wrappers[pos].name);
            mappingData.wrapper = wrappers[pos].object;
            mappingData.servletName = wrappers[pos].servletName;
        }
    }

    private void internalMapWildcardWrapper(Wrapper[] wrappers, int nesting, CharChunk path, MappingData mappingData) {
        int pathEnd = path.getEnd();
        int lastSlash = -1;
        int length = -1;
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1) {
            boolean found = false;
            while (pos >= 0) {
                if (path.startsWith(wrappers[pos].name)) {
                    length = wrappers[pos].name.length();
                    if (path.getLength() == length) {
                        found = true;
                        break;
                    }
                    if (path.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path, nesting + 1) : Mapper.lastSlash(path);
                path.setEnd(lastSlash);
                pos = Mapper.find((MapElement[])wrappers, path);
            }
            path.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setString(wrappers[pos].name);
                if (path.getLength() > length) {
                    mappingData.pathInfo.setChars(path.getBuffer(), path.getStart() + length, path.getEnd());
                }
                mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getEnd());
                mappingData.wrapper = wrappers[pos].object;
                mappingData.servletName = wrappers[pos].servletName;
                mappingData.jspWildCard = wrappers[pos].jspWildCard;
            }
        }
    }

    private void internalMapExtensionWrapper(Wrapper[] wrappers, CharChunk path, MappingData mappingData) {
        char[] buf = path.getBuffer();
        int pathEnd = path.getEnd();
        int servletPath = path.getStart();
        int slash = -1;
        for (int i = pathEnd - 1; i >= servletPath; --i) {
            if (buf[i] != '/') continue;
            slash = i;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i = pathEnd - 1; i > slash; --i) {
                if (buf[i] != '.') continue;
                period = i;
                break;
            }
            if (period >= 0) {
                path.setStart(period + 1);
                path.setEnd(pathEnd);
                int pos = Mapper.find((MapElement[])wrappers, path);
                if (pos != -1 && path.equals(wrappers[pos].name)) {
                    mappingData.wrapperPath.setChars(buf, servletPath, pathEnd);
                    mappingData.requestPath.setChars(buf, servletPath, pathEnd);
                    mappingData.wrapper = wrappers[pos].object;
                    mappingData.servletName = wrappers[pos].servletName;
                }
                path.setStart(servletPath);
                path.setEnd(pathEnd);
            }
        }
    }

    private static int find(MapElement[] map, CharChunk name) {
        return Mapper.find(map, name, name.getStart(), name.getEnd());
    }

    private static int find(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compare(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = Mapper.compare(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compare(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int findIgnoreCase(MapElement[] map, CharChunk name) {
        return Mapper.findIgnoreCase(map, name, name.getStart(), name.getEnd());
    }

    private static int findIgnoreCase(MapElement[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = Mapper.compareIgnoreCase(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compareIgnoreCase(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int findIgnoreCase(MapElement[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = Mapper.compareIgnoreCase(name, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compareIgnoreCase(name, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int find(MapElement[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int compare(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (c[i + start] > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (c[i + start] >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static int compareIgnoreCase(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower(c[i + start]) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower(c[i + start]) >= Ascii.toLower(compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static int compareIgnoreCase(String name, String compareTo) {
        int compareToLen;
        int result = 0;
        int nameLen = name.length();
        int len = nameLen < (compareToLen = compareTo.length()) ? nameLen : compareToLen;
        for (int i = 0; i < len && result == 0; ++i) {
            int compareToLower;
            int nameLower = Ascii.toLower(name.charAt(i));
            if (nameLower > (compareToLower = Ascii.toLower(compareTo.charAt(i)))) {
                result = 1;
                continue;
            }
            if (nameLower >= compareToLower) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareToLen > nameLen) {
                result = -1;
            } else if (compareToLen < nameLen) {
                result = 1;
            }
        }
        return result;
    }

    private static int lastSlash(CharChunk name) {
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int start = name.getStart();
        int pos = end;
        while (pos > start && c[--pos] != '/') {
        }
        return pos;
    }

    private static int nthSlash(CharChunk name, int n) {
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int pos = name.getStart();
        int count = 0;
        while (pos < end) {
            if (c[pos++] != '/' || ++count != n) continue;
            --pos;
            break;
        }
        return pos;
    }

    private static int slashCount(String name) {
        int pos = -1;
        int count = 0;
        while ((pos = name.indexOf(47, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static MapElement insertMap(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        int pos = Mapper.find(oldMap, newElement.name);
        if (pos != -1 && newElement.name.equals(oldMap[pos].name)) {
            return oldMap[pos];
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return null;
    }

    private static MapElement insertMapIgnoreCase(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        CharChunk cc = new CharChunk();
        char[] chars = newElement.name.toCharArray();
        cc.setChars(chars, 0, chars.length);
        int pos = Mapper.findIgnoreCase(oldMap, cc);
        if (pos != -1 && newElement.name.equalsIgnoreCase(oldMap[pos].name)) {
            return oldMap[pos];
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return null;
    }

    private static boolean removeMap(MapElement[] oldMap, MapElement[] newMap, String name) {
        int pos = Mapper.find(oldMap, name);
        if (pos != -1 && name.equals(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    private static boolean removeMapIgnoreCase(MapElement[] oldMap, MapElement[] newMap, String name) {
        CharChunk cc = new CharChunk();
        char[] chars = name.toCharArray();
        cc.setChars(chars, 0, chars.length);
        int pos = Mapper.findIgnoreCase(oldMap, cc);
        if (pos != -1 && name.equalsIgnoreCase(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    static {
        try {
            SLASH.append('/');
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected static class Wrapper
    extends MapElement {
        public String path = null;
        public boolean jspWildCard = false;
        public String servletName = null;

        protected Wrapper() {
        }
    }

    protected static final class Context
    extends MapElement {
        public String path = null;
        public String[] welcomeResources = new String[0];
        public javax.naming.Context resources = null;
        public List<AlternateDocBase> alternateDocBases = null;
        public Wrapper defaultWrapper = null;
        public Wrapper emptyPathWrapper = null;
        public Wrapper[] exactWrappers = new Wrapper[0];
        public Wrapper[] wildcardWrappers = new Wrapper[0];
        public Wrapper[] extensionWrappers = new Wrapper[0];
        public int nesting = 0;

        protected Context() {
        }
    }

    protected static final class ContextList {
        public Context[] contexts = new Context[0];
        public int nesting = 0;

        protected ContextList() {
        }
    }

    protected static final class Host
    extends MapElement {
        public ContextList contextList = null;
        public String[] defaultContextPaths = null;
        public Context[] defaultContexts = null;

        protected Host() {
        }
    }

    protected static abstract class MapElement {
        public String name = null;
        public Object object = null;

        protected MapElement() {
        }
    }
}

