/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.dns.BaseServiceRecordProcessor;
import org.apache.hadoop.registry.server.dns.ZoneSelector;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;

public class ContainerServiceRecordProcessor
extends BaseServiceRecordProcessor {
    public ContainerServiceRecordProcessor(ServiceRecord record, String path, String domain, ZoneSelector zoneSelector) throws Exception {
        super(record, path, domain, zoneSelector);
    }

    @Override
    public void initTypeToInfoMapping(ServiceRecord serviceRecord) throws Exception {
        if (serviceRecord.get("yarn:ip") != null) {
            block6: for (int type : this.getRecordTypes()) {
                switch (type) {
                    case 1: {
                        this.createAInfo(serviceRecord);
                        continue block6;
                    }
                    case 28: {
                        this.createAAAAInfo(serviceRecord);
                        continue block6;
                    }
                    case 12: {
                        this.createPTRInfo(serviceRecord);
                        continue block6;
                    }
                    case 16: {
                        this.createTXTInfo(serviceRecord);
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + type);
                    }
                }
            }
        }
    }

    protected void createTXTInfo(ServiceRecord serviceRecord) throws Exception {
        TXTContainerRecordDescriptor txtInfo = new TXTContainerRecordDescriptor(this.getPath(), serviceRecord);
        this.registerRecordDescriptor(16, txtInfo);
    }

    protected void createPTRInfo(ServiceRecord record) throws Exception {
        PTRContainerRecordDescriptor ptrInfo = new PTRContainerRecordDescriptor(this.getPath(), record);
        this.registerRecordDescriptor(12, ptrInfo);
    }

    protected void createAAAAInfo(ServiceRecord record) throws Exception {
        AAAAContainerRecordDescriptor recordInfo = new AAAAContainerRecordDescriptor(this.getPath(), record);
        this.registerRecordDescriptor(28, recordInfo);
    }

    protected void createAInfo(ServiceRecord record) throws Exception {
        AContainerRecordDescriptor recordInfo = new AContainerRecordDescriptor(this.getPath(), record);
        this.registerRecordDescriptor(1, recordInfo);
    }

    @Override
    public int[] getRecordTypes() {
        return new int[]{1, 28, 12, 16};
    }

    class AAAAContainerRecordDescriptor
    extends AContainerRecordDescriptor {
        public AAAAContainerRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(path, record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) {
            super.init(serviceRecord);
            try {
                this.setTarget(BaseServiceRecordProcessor.getIpv6Address((InetAddress)this.getTarget()));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    class AContainerRecordDescriptor
    extends BaseServiceRecordProcessor.ContainerRecordDescriptor<InetAddress> {
        public AContainerRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(path, record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) {
            String ip = serviceRecord.get("yarn:ip");
            if (ip == null) {
                throw new IllegalArgumentException("No IP specified");
            }
            try {
                this.setTarget(InetAddress.getByName(ip));
                this.setNames(new Name[]{this.getContainerName(), this.getContainerIDName(), this.getComponentName()});
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    class PTRContainerRecordDescriptor
    extends BaseServiceRecordProcessor.ContainerRecordDescriptor<Name> {
        public PTRContainerRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(path, record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) {
            String host = serviceRecord.get("yarn:hostname");
            String ip = serviceRecord.get("yarn:ip");
            Name reverseLookupName = null;
            if (host != null && ip != null) {
                try {
                    reverseLookupName = ContainerServiceRecordProcessor.this.reverseIP(ip);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            this.setNames(new Name[]{reverseLookupName});
            try {
                this.setTarget(this.getContainerName());
            }
            catch (TextParseException textParseException) {
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    class TXTContainerRecordDescriptor
    extends BaseServiceRecordProcessor.ContainerRecordDescriptor<List<String>> {
        public TXTContainerRecordDescriptor(String path, ServiceRecord record) throws Exception {
            super(path, record);
        }

        @Override
        protected void init(ServiceRecord serviceRecord) {
            try {
                this.setNames(new Name[]{this.getContainerName()});
            }
            catch (TextParseException textParseException) {
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            ArrayList<String> txts = new ArrayList<String>();
            txts.add("id=" + serviceRecord.get("yarn:id"));
            this.setTarget(txts);
        }
    }
}

